/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RecordLoadOverride;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageRelationshipCursor;

abstract class RecordRelationshipCursor
extends RelationshipRecord
implements RelationshipVisitor<RuntimeException>,
StorageRelationshipCursor {
    final RelationshipStore relationshipStore;
    RecordLoadOverride loadMode;
    private final PageCursorTracer cursorTracer;

    RecordRelationshipCursor(RelationshipStore relationshipStore, PageCursorTracer cursorTracer) {
        super(-1L);
        this.relationshipStore = relationshipStore;
        this.cursorTracer = cursorTracer;
        this.loadMode = RecordLoadOverride.none();
    }

    public long entityReference() {
        return this.getId();
    }

    public int type() {
        return this.getType();
    }

    public boolean hasProperties() {
        return this.nextProp != -1L;
    }

    public long sourceNodeReference() {
        return this.getFirstNode();
    }

    public long targetNodeReference() {
        return this.getSecondNode();
    }

    public long propertiesReference() {
        return this.getNextProp();
    }

    public void properties(StoragePropertyCursor propertyCursor) {
        propertyCursor.initRelationshipProperties(this.getNextProp());
    }

    public void visit(long relationshipId, int typeId, long startNodeId, long endNodeId) {
        this.setId(relationshipId);
        this.initialize(true, -1L, startNodeId, endNodeId, typeId, -1L, -1L, -1L, -1L, false, false);
    }

    protected void resetState() {
        this.loadMode = RecordLoadOverride.none();
    }

    PageCursor relationshipPage(long reference) {
        return this.relationshipStore.openPageCursorForReading(reference, this.cursorTracer);
    }

    void relationship(RelationshipRecord record, long reference, PageCursor pageCursor) {
        this.relationshipStore.getRecordByCursor(reference, record, this.loadMode.orElse(RecordLoad.CHECK).lenient(), pageCursor);
    }

    void relationshipFull(RelationshipRecord record, long reference, PageCursor pageCursor) {
        this.relationshipStore.getRecordByCursor(reference, record, this.loadMode.orElse(RecordLoad.ALWAYS), pageCursor);
    }

    long relationshipHighMark() {
        return this.relationshipStore.getHighestPossibleIdInUse(this.cursorTracer);
    }

    public void setForceLoad() {
        this.loadMode = RecordLoadOverride.FORCE;
    }

    @Override
    public RelationshipRecord copy() {
        throw new UnsupportedOperationException("Record cursors are not copyable.");
    }
}

