/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RecordLoadOverride;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class RecordRelationshipGroupCursor
extends RelationshipGroupRecord
implements AutoCloseable {
    private final RelationshipStore relationshipStore;
    private final RelationshipGroupStore groupStore;
    private final PageCursorTracer cursorTracer;
    private final RelationshipRecord edge = new RelationshipRecord(-1L);
    private PageCursor page;
    private PageCursor edgePage;
    private boolean open;
    RecordLoadOverride loadMode;

    RecordRelationshipGroupCursor(RelationshipStore relationshipStore, RelationshipGroupStore groupStore, PageCursorTracer cursorTracer, RecordLoadOverride loadMode) {
        super(-1L);
        this.relationshipStore = relationshipStore;
        this.groupStore = groupStore;
        this.cursorTracer = cursorTracer;
        this.loadMode = loadMode;
    }

    void init(long nodeReference, long reference, boolean nodeIsDense) {
        if (reference != -1L && !nodeIsDense) {
            throw new UnsupportedOperationException("Not a dense node");
        }
        this.direct(nodeReference, reference);
        this.open = true;
    }

    void direct(long nodeReference, long reference) {
        this.clear();
        this.setOwningNode(nodeReference);
        this.setNext(reference);
        if (this.page == null) {
            this.page = this.groupPage(reference);
        }
    }

    boolean next() {
        do {
            if (this.getNext() == -1L) {
                return false;
            }
            this.group(this, this.getNext(), this.page);
        } while (!this.inUse());
        return true;
    }

    int outgoingCount() {
        return this.count(this.outgoingRawId());
    }

    int incomingCount() {
        return this.count(this.incomingRawId());
    }

    int loopCount() {
        return this.count(this.loopsRawId());
    }

    private int count(long reference) {
        if (reference == -1L) {
            return 0;
        }
        if (this.edgePage == null) {
            this.edgePage = this.relationshipStore.openPageCursorForReading(reference, this.cursorTracer);
        }
        this.relationshipStore.getRecordByCursor(reference, this.edge, this.loadMode.orElse(RecordLoad.ALWAYS), this.edgePage);
        if (this.edge.getFirstNode() == this.getOwningNode()) {
            return (int)this.edge.getFirstPrevRel();
        }
        return (int)this.edge.getSecondPrevRel();
    }

    @Override
    public RelationshipGroupRecord copy() {
        throw new UnsupportedOperationException("Record cursors are not copyable.");
    }

    @Override
    public String toString() {
        if (!this.open) {
            return "RelationshipGroupCursor[closed state]";
        }
        return "RelationshipGroupCursor[id=" + this.getId() + ", open state with: underlying record=" + super.toString() + "]";
    }

    long outgoingRawId() {
        return this.getFirstOut();
    }

    long incomingRawId() {
        return this.getFirstIn();
    }

    long loopsRawId() {
        return this.getFirstLoop();
    }

    @Override
    public void close() {
        if (this.edgePage != null) {
            this.edgePage.close();
            this.edgePage = null;
        }
        if (this.page != null) {
            this.page.close();
            this.page = null;
        }
    }

    private PageCursor groupPage(long reference) {
        return this.groupStore.openPageCursorForReading(reference, this.cursorTracer);
    }

    private void group(RelationshipGroupRecord record, long reference, PageCursor page) {
        this.groupStore.getRecordByCursor(reference, record, this.loadMode.orElse(RecordLoad.ALWAYS), page);
    }
}

