/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.internal.recordstorage.IntegrityValidator;
import org.neo4j.internal.recordstorage.Loaders;
import org.neo4j.internal.recordstorage.PropertyCreator;
import org.neo4j.internal.recordstorage.PropertyDeleter;
import org.neo4j.internal.recordstorage.PropertyTraverser;
import org.neo4j.internal.recordstorage.RecordChangeSet;
import org.neo4j.internal.recordstorage.RelationshipCreator;
import org.neo4j.internal.recordstorage.RelationshipDeleter;
import org.neo4j.internal.recordstorage.RelationshipGroupGetter;
import org.neo4j.internal.recordstorage.TransactionRecordState;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StandardDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandCreationContext;

class RecordStorageCommandCreationContext
implements CommandCreationContext {
    private final NeoStores neoStores;
    private final Loaders loaders;
    private final MemoryTracker memoryTracker;
    private final RelationshipCreator relationshipCreator;
    private final RelationshipDeleter relationshipDeleter;
    private final PropertyCreator propertyCreator;
    private final PropertyDeleter propertyDeleter;
    private final PageCursorTracer cursorTracer;

    RecordStorageCommandCreationContext(NeoStores neoStores, TokenNameLookup tokenNameLookup, LogProvider logProvider, int denseNodeThreshold, Config config, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        this.cursorTracer = cursorTracer;
        this.neoStores = neoStores;
        this.memoryTracker = memoryTracker;
        this.loaders = new Loaders(neoStores);
        RelationshipGroupGetter relationshipGroupGetter = new RelationshipGroupGetter(neoStores.getRelationshipGroupStore(), cursorTracer);
        this.relationshipCreator = new RelationshipCreator(relationshipGroupGetter, denseNodeThreshold, cursorTracer);
        PropertyTraverser propertyTraverser = new PropertyTraverser(cursorTracer);
        this.propertyDeleter = new PropertyDeleter(propertyTraverser, neoStores, tokenNameLookup, logProvider, config, cursorTracer, memoryTracker);
        this.relationshipDeleter = new RelationshipDeleter(relationshipGroupGetter, this.propertyDeleter, cursorTracer);
        PropertyStore propertyStore = neoStores.getPropertyStore();
        this.propertyCreator = new PropertyCreator(new StandardDynamicRecordAllocator(propertyStore.getStringStore(), propertyStore.getStringStore().getRecordDataSize()), new StandardDynamicRecordAllocator(propertyStore.getArrayStore(), propertyStore.getArrayStore().getRecordDataSize()), propertyStore, propertyTraverser, propertyStore.allowStorePointsAndTemporal(), cursorTracer, memoryTracker);
    }

    private long nextId(StoreType storeType) {
        return this.neoStores.getRecordStore(storeType).nextId(this.cursorTracer);
    }

    public long reserveNode() {
        return this.nextId(StoreType.NODE);
    }

    public long reserveRelationship() {
        return this.nextId(StoreType.RELATIONSHIP);
    }

    public long reserveSchema() {
        return this.nextId(StoreType.SCHEMA);
    }

    public int reserveRelationshipTypeTokenId() {
        return Math.toIntExact(this.neoStores.getRelationshipTypeTokenStore().nextId(this.cursorTracer));
    }

    public int reservePropertyKeyTokenId() {
        return Math.toIntExact(this.neoStores.getPropertyKeyTokenStore().nextId(this.cursorTracer));
    }

    public int reserveLabelTokenId() {
        return Math.toIntExact(this.neoStores.getLabelTokenStore().nextId(this.cursorTracer));
    }

    public void close() {
    }

    TransactionRecordState createTransactionRecordState(IntegrityValidator integrityValidator, long lastTransactionIdWhenStarted, ResourceLocker locks) {
        RecordChangeSet recordChangeSet = new RecordChangeSet(this.loaders, this.memoryTracker);
        return new TransactionRecordState(this.neoStores, integrityValidator, recordChangeSet, lastTransactionIdWhenStarted, locks, this.relationshipCreator, this.relationshipDeleter, this.propertyCreator, this.propertyDeleter, this.cursorTracer, this.memoryTracker);
    }
}

