/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.function.ThrowingAction;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.DiagnosticsManager;
import org.neo4j.internal.diagnostics.DiagnosticsProvider;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.kernel.api.exceptions.TransactionApplyKernelException;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.BridgingCacheAccess;
import org.neo4j.internal.recordstorage.CacheAccessBackDoor;
import org.neo4j.internal.recordstorage.CacheInvalidationTransactionApplierFactory;
import org.neo4j.internal.recordstorage.ConsistencyCheckingApplierFactory;
import org.neo4j.internal.recordstorage.CountsRecordState;
import org.neo4j.internal.recordstorage.CountsStoreTransactionApplierFactory;
import org.neo4j.internal.recordstorage.EnqueuingIdUpdateListener;
import org.neo4j.internal.recordstorage.HighIdTransactionApplierFactory;
import org.neo4j.internal.recordstorage.IdGeneratorUpdateWork;
import org.neo4j.internal.recordstorage.IndexTransactionApplierFactory;
import org.neo4j.internal.recordstorage.IndexUpdatesWork;
import org.neo4j.internal.recordstorage.IntegrityValidator;
import org.neo4j.internal.recordstorage.NeoStoreTransactionApplierFactory;
import org.neo4j.internal.recordstorage.NeoStoresDiagnostics;
import org.neo4j.internal.recordstorage.RecordStorageCommandCreationContext;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.internal.recordstorage.SchemaCache;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.recordstorage.TokenUpdateWork;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.internal.recordstorage.TransactionApplierFactoryChain;
import org.neo4j.internal.recordstorage.TransactionRecordState;
import org.neo4j.internal.recordstorage.TransactionToRecordStateVisitor;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.IdUpdateListener;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.lock.LockService;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Health;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.CountsDelta;
import org.neo4j.storageengine.api.EntityTokenUpdateListener;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TransactionCountingStateVisitor;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.util.concurrent.WorkSync;

public class RecordStorageEngine
implements StorageEngine,
Lifecycle {
    private static final String STORAGE_ENGINE_START_TAG = "storageEngineStart";
    private static final String SCHEMA_CACHE_START_TAG = "schemaCacheStart";
    private static final String TOKENS_INIT_TAG = "tokensInitialisation";
    private final NeoStores neoStores;
    private final DatabaseLayout databaseLayout;
    private final Config config;
    private final LogProvider logProvider;
    private final TokenHolders tokenHolders;
    private final Health databaseHealth;
    private final SchemaCache schemaCache;
    private final IntegrityValidator integrityValidator;
    private final CacheAccessBackDoor cacheAccess;
    private final SchemaState schemaState;
    private final SchemaRuleAccess schemaRuleAccess;
    private final ConstraintRuleAccessor constraintSemantics;
    private final LockService lockService;
    private final boolean consistencyCheckApply;
    private WorkSync<EntityTokenUpdateListener, TokenUpdateWork> labelScanStoreSync;
    private WorkSync<EntityTokenUpdateListener, TokenUpdateWork> relationshipTypeScanStoreSync;
    private WorkSync<IndexUpdateListener, IndexUpdatesWork> indexUpdatesSync;
    private final IdController idController;
    private final PageCacheTracer cacheTracer;
    private final MemoryTracker otherMemoryTracker;
    private final GBPTreeCountsStore countsStore;
    private final int denseNodeThreshold;
    private final Map<IdType, WorkSync<IdGenerator, IdGeneratorUpdateWork>> idGeneratorWorkSyncs = new EnumMap<IdType, WorkSync<IdGenerator, IdGeneratorUpdateWork>>(IdType.class);
    private final Map<TransactionApplicationMode, TransactionApplierFactoryChain> applierChains = new EnumMap<TransactionApplicationMode, TransactionApplierFactoryChain>(TransactionApplicationMode.class);
    private IndexUpdateListener indexUpdateListener;
    private EntityTokenUpdateListener nodeLabelUpdateListener;
    private EntityTokenUpdateListener relationshipTypeUpdateListener;

    public RecordStorageEngine(DatabaseLayout databaseLayout, Config config, PageCache pageCache, FileSystemAbstraction fs, LogProvider logProvider, TokenHolders tokenHolders, SchemaState schemaState, ConstraintRuleAccessor constraintSemantics, IndexConfigCompleter indexConfigCompleter, LockService lockService, Health databaseHealth, IdGeneratorFactory idGeneratorFactory, IdController idController, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, PageCacheTracer cacheTracer, boolean createStoreIfNotExists, MemoryTracker otherMemoryTracker) {
        this.databaseLayout = databaseLayout;
        this.config = config;
        this.logProvider = logProvider;
        this.tokenHolders = tokenHolders;
        this.schemaState = schemaState;
        this.lockService = lockService;
        this.databaseHealth = databaseHealth;
        this.constraintSemantics = constraintSemantics;
        this.idController = idController;
        this.cacheTracer = cacheTracer;
        this.otherMemoryTracker = otherMemoryTracker;
        StoreFactory factory = new StoreFactory(databaseLayout, config, idGeneratorFactory, pageCache, fs, logProvider, cacheTracer);
        this.neoStores = factory.openAllNeoStores(createStoreIfNotExists);
        for (IdType idType : IdType.values()) {
            this.idGeneratorWorkSyncs.put(idType, (WorkSync<IdGenerator, IdGeneratorUpdateWork>)new WorkSync((Object)idGeneratorFactory.get(idType)));
        }
        try {
            this.schemaRuleAccess = SchemaRuleAccess.getSchemaRuleAccess(this.neoStores.getSchemaStore(), tokenHolders);
            this.schemaCache = new SchemaCache(constraintSemantics, indexConfigCompleter);
            this.integrityValidator = new IntegrityValidator(this.neoStores);
            this.cacheAccess = new BridgingCacheAccess(this.schemaCache, schemaState, tokenHolders);
            this.denseNodeThreshold = (Integer)config.get(GraphDatabaseSettings.dense_node_threshold);
            this.countsStore = this.openCountsStore(pageCache, fs, databaseLayout, config, logProvider, recoveryCleanupWorkCollector, cacheTracer);
            this.consistencyCheckApply = (Boolean)config.get(GraphDatabaseInternalSettings.consistency_check_on_apply);
        }
        catch (Throwable failure) {
            this.neoStores.close();
            throw failure;
        }
    }

    private void buildApplierChains() {
        for (TransactionApplicationMode mode : TransactionApplicationMode.values()) {
            this.applierChains.put(mode, this.buildApplierFacadeChain(mode));
        }
    }

    private TransactionApplierFactoryChain buildApplierFacadeChain(TransactionApplicationMode mode) {
        Supplier<IdUpdateListener> listenerSupplier = mode == TransactionApplicationMode.REVERSE_RECOVERY ? () -> IdUpdateListener.IGNORE : () -> new EnqueuingIdUpdateListener(this.idGeneratorWorkSyncs, this.cacheTracer);
        ArrayList<TransactionApplierFactory> appliers = new ArrayList<TransactionApplierFactory>();
        if (this.consistencyCheckApply && mode.needsAuxiliaryStores()) {
            appliers.add(new ConsistencyCheckingApplierFactory(this.neoStores));
        }
        appliers.add(new NeoStoreTransactionApplierFactory(mode, this.neoStores, this.cacheAccess, this.lockService(mode)));
        if (mode.needsHighIdTracking()) {
            appliers.add(new HighIdTransactionApplierFactory(this.neoStores));
        }
        if (mode.needsCacheInvalidationOnUpdates()) {
            appliers.add(new CacheInvalidationTransactionApplierFactory(this.neoStores, this.cacheAccess));
        }
        if (mode.needsAuxiliaryStores()) {
            appliers.add(new CountsStoreTransactionApplierFactory(this.countsStore));
            appliers.add(new IndexTransactionApplierFactory(this.indexUpdateListener));
        }
        return new TransactionApplierFactoryChain(listenerSupplier, appliers.toArray(new TransactionApplierFactory[0]));
    }

    private GBPTreeCountsStore openCountsStore(final PageCache pageCache, FileSystemAbstraction fs, final DatabaseLayout layout, Config config, final LogProvider logProvider, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, final PageCacheTracer pageCacheTracer) {
        boolean readOnly = (Boolean)config.get(GraphDatabaseSettings.read_only);
        try {
            return new GBPTreeCountsStore(pageCache, layout.countStore(), fs, recoveryCleanupWorkCollector, new CountsBuilder(){
                private final Log log;
                {
                    this.log = logProvider.getLog(MetaDataStore.class);
                }

                @Override
                public void initialize(CountsAccessor.Updater updater, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
                    this.log.warn("Missing counts store, rebuilding it.");
                    new CountsComputer(RecordStorageEngine.this.neoStores, pageCache, pageCacheTracer, layout, memoryTracker, this.log).initialize(updater, cursorTracer, memoryTracker);
                    this.log.warn("Counts store rebuild completed.");
                }

                @Override
                public long lastCommittedTxId() {
                    return RecordStorageEngine.this.neoStores.getMetaDataStore().getLastCommittedTransactionId();
                }
            }, readOnly, pageCacheTracer, GBPTreeCountsStore.NO_MONITOR);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    public RecordStorageReader newReader() {
        return new RecordStorageReader(this.tokenHolders, this.neoStores, (CountsAccessor)this.countsStore, this.schemaCache);
    }

    public RecordStorageCommandCreationContext newCommandCreationContext(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        return new RecordStorageCommandCreationContext(this.neoStores, (TokenNameLookup)this.tokenHolders, this.logProvider, this.denseNodeThreshold, this.config, cursorTracer, memoryTracker);
    }

    public void addIndexUpdateListener(IndexUpdateListener listener) {
        Preconditions.checkState((this.indexUpdateListener == null ? 1 : 0) != 0, (String)("Only supports a single listener. Tried to add " + listener + ", but " + this.indexUpdateListener + " has already been added"));
        this.indexUpdateListener = listener;
        this.indexUpdatesSync = new WorkSync((Object)listener);
        this.integrityValidator.setIndexValidator(listener);
    }

    public void addNodeLabelUpdateListener(EntityTokenUpdateListener listener) {
        Preconditions.checkState((this.nodeLabelUpdateListener == null ? 1 : 0) != 0, (String)("Only supports a single listener. Tried to add " + listener + ", but " + this.nodeLabelUpdateListener + " has already been added"));
        this.nodeLabelUpdateListener = listener;
        this.labelScanStoreSync = new WorkSync((Object)listener);
    }

    public void addRelationshipTypeUpdateListener(EntityTokenUpdateListener listener) {
        Preconditions.checkState((this.relationshipTypeUpdateListener == null ? 1 : 0) != 0, (String)("Only supports a single listener. Tried to add " + listener + ", but " + this.relationshipTypeUpdateListener + " has already been added"));
        this.relationshipTypeUpdateListener = listener;
        this.relationshipTypeScanStoreSync = new WorkSync((Object)listener);
    }

    public void createCommands(Collection<StorageCommand> commands, ReadableTransactionState txState, StorageReader storageReader, CommandCreationContext commandCreationContext, ResourceLocker locks, long lastTransactionIdWhenStarted, TxStateVisitor.Decorator additionalTxStateVisitor, PageCursorTracer cursorTracer, MemoryTracker transactionMemoryTracker) throws KernelException {
        if (txState != null) {
            RecordStorageCommandCreationContext creationContext = (RecordStorageCommandCreationContext)commandCreationContext;
            TransactionRecordState recordState = creationContext.createTransactionRecordState(this.integrityValidator, lastTransactionIdWhenStarted, locks);
            TransactionToRecordStateVisitor txStateVisitor = new TransactionToRecordStateVisitor(recordState, this.schemaState, this.schemaRuleAccess, this.constraintSemantics, cursorTracer);
            CountsRecordState countsRecordState = new CountsRecordState();
            txStateVisitor = (TxStateVisitor)additionalTxStateVisitor.apply((Object)txStateVisitor);
            try (TransactionToRecordStateVisitor visitor = txStateVisitor = new TransactionCountingStateVisitor((TxStateVisitor)txStateVisitor, storageReader, txState, (CountsDelta)countsRecordState, cursorTracer);){
                txState.accept((TxStateVisitor)visitor);
            }
            recordState.extractCommands(commands, transactionMemoryTracker);
            countsRecordState.extractCommands(commands, transactionMemoryTracker);
        }
    }

    public void apply(CommandsToApply batch, TransactionApplicationMode mode) throws Exception {
        TransactionApplierFactoryChain batchApplier = this.applierChain(mode);
        CommandsToApply initialBatch = batch;
        try (BatchContext context = new BatchContext(this.indexUpdateListener, this.labelScanStoreSync, this.relationshipTypeScanStoreSync, this.indexUpdatesSync, this.neoStores.getNodeStore(), this.neoStores.getPropertyStore(), this, this.schemaCache, initialBatch.cursorTracer(), this.otherMemoryTracker, batchApplier.getIdUpdateListenerSupplier().get());){
            while (batch != null) {
                try (TransactionApplier txApplier = batchApplier.startTx(batch, context);){
                    batch.accept((Visitor)txApplier);
                }
                batch = batch.next();
            }
        }
        catch (Throwable cause) {
            TransactionApplyKernelException kernelException = new TransactionApplyKernelException(cause, "Failed to apply transaction: %s", new Object[]{batch == null ? initialBatch : batch});
            this.databaseHealth.panic((Throwable)kernelException);
            throw kernelException;
        }
    }

    protected TransactionApplierFactoryChain applierChain(TransactionApplicationMode mode) {
        return this.applierChains.get(mode);
    }

    private LockService lockService(TransactionApplicationMode mode) {
        return mode == TransactionApplicationMode.RECOVERY || mode == TransactionApplicationMode.REVERSE_RECOVERY ? LockService.NO_LOCK_SERVICE : this.lockService;
    }

    public void init() {
        this.buildApplierChains();
    }

    public void start() throws Exception {
        try (PageCursorTracer cursor = this.cacheTracer.createPageCursorTracer(STORAGE_ENGINE_START_TAG);){
            this.neoStores.start(cursor);
            this.countsStore.start(cursor, this.otherMemoryTracker);
            this.idController.start();
        }
    }

    @VisibleForTesting
    public void loadSchemaCache() {
        try (PageCursorTracer cursor = this.cacheTracer.createPageCursorTracer(SCHEMA_CACHE_START_TAG);){
            this.schemaCache.load(this.schemaRuleAccess.getAll(cursor));
        }
    }

    public void stop() throws Exception {
        ThrowingAction[] throwingActionArray = new ThrowingAction[1];
        throwingActionArray[0] = () -> ((IdController)this.idController).stop();
        ThrowingAction.executeAll((ThrowingAction[])throwingActionArray);
    }

    public void shutdown() throws Exception {
        ThrowingAction[] throwingActionArray = new ThrowingAction[2];
        throwingActionArray[0] = this.countsStore::close;
        throwingActionArray[1] = this.neoStores::close;
        ThrowingAction.executeAll((ThrowingAction[])throwingActionArray);
    }

    public void flushAndForce(IOLimiter limiter, PageCursorTracer cursorTracer) throws IOException {
        this.countsStore.checkpoint(limiter, cursorTracer);
        this.neoStores.flush(limiter, cursorTracer);
    }

    public void dumpDiagnostics(Log errorLog, DiagnosticsLogger diagnosticsLog) {
        DiagnosticsManager.dump((DiagnosticsProvider)new NeoStoresDiagnostics.NeoStoreIdUsage(this.neoStores), (Log)errorLog, (DiagnosticsLogger)diagnosticsLog);
        DiagnosticsManager.dump((DiagnosticsProvider)new NeoStoresDiagnostics.NeoStoreRecords(this.neoStores), (Log)errorLog, (DiagnosticsLogger)diagnosticsLog);
        DiagnosticsManager.dump((DiagnosticsProvider)new NeoStoresDiagnostics.NeoStoreVersions(this.neoStores), (Log)errorLog, (DiagnosticsLogger)diagnosticsLog);
    }

    public void forceClose() {
        try {
            this.shutdown();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<StoreFileMetadata> listStorageFiles() {
        ArrayList<StoreFileMetadata> files = new ArrayList<StoreFileMetadata>();
        files.add(new StoreFileMetadata(this.databaseLayout.countStore(), 1));
        for (StoreType type : StoreType.values()) {
            RecordStore recordStore = this.neoStores.getRecordStore(type);
            StoreFileMetadata metadata = new StoreFileMetadata(recordStore.getStorageFile(), recordStore.getRecordSize());
            files.add(metadata);
        }
        return files;
    }

    @VisibleForTesting
    public NeoStores testAccessNeoStores() {
        return this.neoStores;
    }

    @VisibleForTesting
    public SchemaRuleAccess testAccessSchemaRules() {
        return this.schemaRuleAccess;
    }

    public StoreId getStoreId() {
        return this.neoStores.getMetaDataStore().getStoreId();
    }

    public Lifecycle schemaAndTokensLifecycle() {
        return new LifecycleAdapter(){

            public void init() {
                try (PageCursorTracer cursorTracer = RecordStorageEngine.this.cacheTracer.createPageCursorTracer(RecordStorageEngine.TOKENS_INIT_TAG);){
                    RecordStorageEngine.this.tokenHolders.setInitialTokens(StoreTokens.allTokens(RecordStorageEngine.this.neoStores), cursorTracer);
                }
                RecordStorageEngine.this.loadSchemaCache();
            }
        };
    }

    public CountsAccessor countsAccessor() {
        return this.countsStore;
    }

    public MetadataProvider metadataProvider() {
        return this.neoStores.getMetaDataStore();
    }
}

