/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.ScanOnOpenReadOnlyIdGeneratorFactory;
import org.neo4j.internal.recordstorage.ReadOnlyLogVersionRepository;
import org.neo4j.internal.recordstorage.ReadOnlyTransactionIdStore;
import org.neo4j.internal.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.SchemaRuleMigrationAccessImpl;
import org.neo4j.internal.recordstorage.SchemaStorage;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.storemigration.IdGeneratorMigrator;
import org.neo4j.kernel.impl.storemigration.RecordStorageMigrator;
import org.neo4j.kernel.impl.storemigration.RecordStoreRollingUpgradeCompatibility;
import org.neo4j.kernel.impl.storemigration.RecordStoreVersion;
import org.neo4j.kernel.impl.storemigration.RecordStoreVersionCheck;
import org.neo4j.lock.LockService;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StorageFilesState;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.migration.RollingUpgradeCompatibility;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccess;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

public class RecordStorageEngineFactory
implements StorageEngineFactory {
    public StoreVersionCheck versionCheck(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config config, PageCache pageCache, LogService logService, PageCacheTracer pageCacheTracer) {
        return new RecordStoreVersionCheck(fs, pageCache, databaseLayout, logService.getInternalLogProvider(), config, pageCacheTracer);
    }

    public StoreVersion versionInformation(String storeVersion) {
        return new RecordStoreVersion(RecordFormatSelector.selectForVersion(storeVersion));
    }

    public RollingUpgradeCompatibility rollingUpgradeCompatibility() {
        return new RecordStoreRollingUpgradeCompatibility(RecordFormatSelector.allFormats());
    }

    public List<StoreMigrationParticipant> migrationParticipants(FileSystemAbstraction fs, Config config, PageCache pageCache, JobScheduler jobScheduler, LogService logService, PageCacheTracer cacheTracer, MemoryTracker memoryTracker) {
        BatchImporterFactory batchImporterFactory = BatchImporterFactory.withHighestPriority();
        RecordStorageMigrator recordStorageMigrator = new RecordStorageMigrator(fs, pageCache, config, logService, jobScheduler, cacheTracer, batchImporterFactory, memoryTracker);
        IdGeneratorMigrator idGeneratorMigrator = new IdGeneratorMigrator(fs, pageCache, config, cacheTracer);
        return List.of(recordStorageMigrator, idGeneratorMigrator);
    }

    public StorageEngine instantiate(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config config, PageCache pageCache, TokenHolders tokenHolders, SchemaState schemaState, ConstraintRuleAccessor constraintSemantics, IndexConfigCompleter indexConfigCompleter, LockService lockService, IdGeneratorFactory idGeneratorFactory, IdController idController, DatabaseHealth databaseHealth, LogProvider logProvider, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, PageCacheTracer cacheTracer, boolean createStoreIfNotExists, MemoryTracker memoryTracker) {
        return new RecordStorageEngine(databaseLayout, config, pageCache, fs, logProvider, tokenHolders, schemaState, constraintSemantics, indexConfigCompleter, lockService, (Health)databaseHealth, idGeneratorFactory, idController, recoveryCleanupWorkCollector, cacheTracer, createStoreIfNotExists, memoryTracker);
    }

    public List<Path> listStorageFiles(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout) throws IOException {
        if (!fileSystem.fileExists(databaseLayout.metadataStore())) {
            throw new IOException("No storage present at " + databaseLayout + " on " + fileSystem);
        }
        return Arrays.stream(StoreType.values()).map(t -> databaseLayout.file(t.getDatabaseFile())).filter(arg_0 -> ((FileSystemAbstraction)fileSystem).fileExists(arg_0)).collect(Collectors.toList());
    }

    public boolean storageExists(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout, PageCache pageCache) {
        return NeoStores.isStorePresent(fileSystem, databaseLayout);
    }

    public TransactionIdStore readOnlyTransactionIdStore(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout, PageCache pageCache, PageCursorTracer cursorTracer) throws IOException {
        return new ReadOnlyTransactionIdStore(fileSystem, pageCache, databaseLayout, cursorTracer);
    }

    public LogVersionRepository readOnlyLogVersionRepository(DatabaseLayout databaseLayout, PageCache pageCache, PageCursorTracer cursorTracer) throws IOException {
        return new ReadOnlyLogVersionRepository(pageCache, databaseLayout, cursorTracer);
    }

    public MetadataProvider transactionMetaDataStore(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config config, PageCache pageCache, PageCacheTracer cacheTracer) {
        RecordFormats recordFormats = RecordFormatSelector.selectForStoreOrConfig(Config.defaults(), databaseLayout, fs, pageCache, (LogProvider)NullLogProvider.getInstance(), cacheTracer);
        Object factory = (Boolean)config.get(GraphDatabaseSettings.read_only) != false ? new ScanOnOpenReadOnlyIdGeneratorFactory() : new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.immediate());
        return new StoreFactory(databaseLayout, config, (IdGeneratorFactory)factory, pageCache, fs, recordFormats, (LogProvider)NullLogProvider.getInstance(), cacheTracer, (ImmutableSet<OpenOption>)Sets.immutable.empty()).openNeoStores(StoreType.META_DATA).getMetaDataStore();
    }

    public StoreId storeId(DatabaseLayout databaseLayout, PageCache pageCache, PageCursorTracer cursorTracer) throws IOException {
        return MetaDataStore.getStoreId(pageCache, databaseLayout.metadataStore(), cursorTracer);
    }

    public void setExternalStoreUUID(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, PageCursorTracer cursorTracer, UUID externalStoreId) throws IOException {
        MetaDataStore.setExternalStoreUUID(pageCache, databaseLayout.metadataStore(), externalStoreId, cursorTracer);
    }

    public SchemaRuleMigrationAccess schemaRuleMigrationAccess(FileSystemAbstraction fs, PageCache pageCache, Config config, DatabaseLayout databaseLayout, LogService logService, String recordFormats, PageCacheTracer cacheTracer, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        RecordFormats formats = RecordFormatSelector.selectForVersion(recordFormats);
        StoreFactory factory = new StoreFactory(databaseLayout, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.immediate()), pageCache, fs, formats, logService.getInternalLogProvider(), cacheTracer, (ImmutableSet<OpenOption>)Sets.immutable.empty());
        NeoStores stores = factory.openNeoStores(true, StoreType.SCHEMA, StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY);
        try {
            stores.start(cursorTracer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return RecordStorageEngineFactory.createMigrationTargetSchemaRuleAccess(stores, cursorTracer, memoryTracker);
    }

    public CommandReaderFactory commandReaderFactory() {
        return RecordStorageCommandReaderFactory.INSTANCE;
    }

    public StorageFilesState checkStoreFileState(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache) {
        boolean allIdFilesExist = databaseLayout.idFiles().stream().allMatch(arg_0 -> ((FileSystemAbstraction)fs).fileExists(arg_0));
        if (!allIdFilesExist) {
            return StorageFilesState.recoverableState();
        }
        Set storeFiles = databaseLayout.storeFiles();
        storeFiles.remove(databaseLayout.countStore());
        storeFiles.remove(databaseLayout.indexStatisticsStore());
        storeFiles.remove(databaseLayout.labelScanStore());
        storeFiles.remove(databaseLayout.relationshipTypeScanStore());
        boolean allStoreFilesExist = storeFiles.stream().allMatch(arg_0 -> ((FileSystemAbstraction)fs).fileExists(arg_0));
        if (!allStoreFilesExist) {
            return StorageFilesState.unrecoverableState((Collection)storeFiles.stream().filter(file -> !fs.fileExists(file)).collect(Collectors.toList()));
        }
        return StorageFilesState.recoveredState();
    }

    public static SchemaRuleMigrationAccess createMigrationTargetSchemaRuleAccess(NeoStores stores, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        SchemaStore dstSchema = stores.getSchemaStore();
        TokenCreator propertyKeyTokenCreator = (name, internal) -> {
            PropertyKeyTokenStore keyTokenStore = stores.getPropertyKeyTokenStore();
            DynamicStringStore nameStore = keyTokenStore.getNameStore();
            byte[] bytes = PropertyStore.encodeString(name);
            ArrayList<DynamicRecord> nameRecords = new ArrayList<DynamicRecord>();
            AbstractDynamicStore.allocateRecordsFromBytes(nameRecords, bytes, nameStore, cursorTracer, memoryTracker);
            nameRecords.forEach(record -> nameStore.prepareForCommit(record, cursorTracer));
            nameRecords.forEach(record -> nameStore.updateRecord(record, cursorTracer));
            nameRecords.forEach(record -> nameStore.setHighestPossibleIdInUse(record.getId()));
            int nameId = ((DynamicRecord)Iterables.first(nameRecords)).getIntId();
            PropertyKeyTokenRecord keyTokenRecord = (PropertyKeyTokenRecord)keyTokenStore.newRecord();
            long tokenId = keyTokenStore.nextId(cursorTracer);
            keyTokenRecord.setId(tokenId);
            keyTokenRecord.initialize(true, nameId);
            keyTokenRecord.setInternal(internal);
            keyTokenRecord.setCreated();
            keyTokenStore.prepareForCommit(keyTokenRecord, cursorTracer);
            keyTokenStore.updateRecord(keyTokenRecord, cursorTracer);
            keyTokenStore.setHighestPossibleIdInUse(keyTokenRecord.getId());
            return Math.toIntExact(tokenId);
        };
        DelegatingTokenHolder propertyKeyTokens = new DelegatingTokenHolder(propertyKeyTokenCreator, "PropertyKey");
        TokenHolders dstTokenHolders = new TokenHolders((TokenHolder)propertyKeyTokens, StoreTokens.createReadOnlyTokenHolder("Label"), StoreTokens.createReadOnlyTokenHolder("RelationshipType"));
        dstTokenHolders.propertyKeyTokens().setInitialTokens(stores.getPropertyKeyTokenStore().getTokens(cursorTracer));
        return new SchemaRuleMigrationAccessImpl(stores, new SchemaStorage(dstSchema, dstTokenHolders), cursorTracer, memoryTracker);
    }
}

