/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.Collection;
import java.util.Iterator;
import java.util.OptionalLong;
import java.util.function.Function;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.internal.recordstorage.RecordNodeCursor;
import org.neo4j.internal.recordstorage.RecordNodeScan;
import org.neo4j.internal.recordstorage.RecordPropertyCursor;
import org.neo4j.internal.recordstorage.RecordRelationshipScan;
import org.neo4j.internal.recordstorage.RecordRelationshipScanCursor;
import org.neo4j.internal.recordstorage.RecordRelationshipTraversalCursor;
import org.neo4j.internal.recordstorage.SchemaCache;
import org.neo4j.internal.recordstorage.StorageSchemaReaderSnapshot;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.AllNodeScan;
import org.neo4j.storageengine.api.AllRelationshipsScan;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.token.TokenHolders;

public class RecordStorageReader
implements StorageReader {
    private final TokenHolders tokenHolders;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final RelationshipGroupStore relationshipGroupStore;
    private final PropertyStore propertyStore;
    private final CountsAccessor counts;
    private final SchemaCache schemaCache;
    private boolean closed;

    RecordStorageReader(TokenHolders tokenHolders, NeoStores neoStores, CountsAccessor counts, SchemaCache schemaCache) {
        this.tokenHolders = tokenHolders;
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.relationshipGroupStore = neoStores.getRelationshipGroupStore();
        this.propertyStore = neoStores.getPropertyStore();
        this.counts = counts;
        this.schemaCache = schemaCache;
    }

    public RecordStorageReader(NeoStores stores) {
        this(null, stores, null, null);
    }

    public Iterator<IndexDescriptor> indexGetForSchema(SchemaDescriptor descriptor) {
        return this.schemaCache.indexesForSchema(descriptor);
    }

    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        return this.schemaCache.indexesForLabel(labelId);
    }

    public Iterator<IndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        return this.schemaCache.indexesForRelationshipType(relationshipType);
    }

    public IndexDescriptor indexGetForName(String name) {
        return this.schemaCache.indexForName(name);
    }

    public ConstraintDescriptor constraintGetForName(String name) {
        return this.schemaCache.constraintForName(name);
    }

    public boolean indexExists(IndexDescriptor index) {
        return this.schemaCache.hasIndex(index);
    }

    public Iterator<IndexDescriptor> indexesGetAll() {
        return this.schemaCache.indexes().iterator();
    }

    public Collection<IndexDescriptor> indexesGetRelated(long[] labels, int propertyKeyId, EntityType entityType) {
        return this.schemaCache.getIndexesRelatedTo(PrimitiveLongCollections.EMPTY_LONG_ARRAY, labels, new int[]{propertyKeyId}, false, entityType);
    }

    public Collection<IndexDescriptor> indexesGetRelated(long[] labels, int[] propertyKeyIds, EntityType entityType) {
        return this.schemaCache.getIndexesRelatedTo(labels, PrimitiveLongCollections.EMPTY_LONG_ARRAY, propertyKeyIds, true, entityType);
    }

    public Collection<IndexBackedConstraintDescriptor> uniquenessConstraintsGetRelated(long[] labels, int propertyKeyId, EntityType entityType) {
        return this.schemaCache.getUniquenessConstraintsRelatedTo(PrimitiveLongCollections.EMPTY_LONG_ARRAY, labels, new int[]{propertyKeyId}, false, entityType);
    }

    public Collection<IndexBackedConstraintDescriptor> uniquenessConstraintsGetRelated(long[] labels, int[] propertyKeyIds, EntityType entityType) {
        return this.schemaCache.getUniquenessConstraintsRelatedTo(labels, PrimitiveLongCollections.EMPTY_LONG_ARRAY, propertyKeyIds, true, entityType);
    }

    public boolean hasRelatedSchema(long[] labels, int propertyKey, EntityType entityType) {
        return this.schemaCache.hasRelatedSchema(labels, propertyKey, entityType);
    }

    public boolean hasRelatedSchema(int label, EntityType entityType) {
        return this.schemaCache.hasRelatedSchema(label, entityType);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
        return this.schemaCache.constraintsForSchema(descriptor);
    }

    public boolean constraintExists(ConstraintDescriptor descriptor) {
        return this.schemaCache.hasConstraintRule(descriptor);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        return this.schemaCache.constraintsForLabel(labelId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        return this.schemaCache.constraintsForRelationshipType(typeId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        return this.schemaCache.constraints().iterator();
    }

    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) {
        Long constraintId;
        if (index == null) {
            return null;
        }
        OptionalLong owningConstraintId = index.getOwningConstraintId();
        if (owningConstraintId.isPresent() && this.schemaCache.hasConstraintRule(constraintId = Long.valueOf(owningConstraintId.getAsLong()))) {
            return constraintId;
        }
        return null;
    }

    public long countsForNode(int labelId, PageCursorTracer cursorTracer) {
        return this.counts.nodeCount(labelId, cursorTracer);
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId, PageCursorTracer cursorTracer) {
        if (startLabelId != -1 && endLabelId != -1) {
            throw new UnsupportedOperationException("not implemented");
        }
        return this.counts.relationshipCount(startLabelId, typeId, endLabelId, cursorTracer);
    }

    public long nodesGetCount(PageCursorTracer cursorTracer) {
        if (this.counts != null) {
            try {
                return this.counts.nodeCount(-1, cursorTracer);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return this.nodeStore.getNumberOfIdsInUse();
    }

    public long relationshipsGetCount() {
        return this.relationshipStore.getNumberOfIdsInUse();
    }

    public int labelCount() {
        return this.tokenHolders.labelTokens().size();
    }

    public int propertyKeyCount() {
        return this.tokenHolders.propertyKeyTokens().size();
    }

    public int relationshipTypeCount() {
        return this.tokenHolders.relationshipTypeTokens().size();
    }

    public boolean nodeExists(long id, PageCursorTracer cursorTracer) {
        return this.nodeStore.isInUse(id, cursorTracer);
    }

    public boolean relationshipExists(long id, PageCursorTracer cursorTracer) {
        return this.relationshipStore.isInUse(id, cursorTracer);
    }

    public <T> T getOrCreateSchemaDependantState(Class<T> type, Function<StorageReader, T> factory) {
        return this.schemaCache.getOrCreateDependantState(type, factory, this);
    }

    public AllNodeScan allNodeScan() {
        return new RecordNodeScan();
    }

    public AllRelationshipsScan allRelationshipScan() {
        return new RecordRelationshipScan();
    }

    public void close() {
        assert (!this.closed);
        this.closed = true;
    }

    public RecordNodeCursor allocateNodeCursor(PageCursorTracer cursorTracer) {
        return new RecordNodeCursor(this.nodeStore, this.relationshipStore, this.relationshipGroupStore, cursorTracer);
    }

    public StorageRelationshipTraversalCursor allocateRelationshipTraversalCursor(PageCursorTracer cursorTracer) {
        return new RecordRelationshipTraversalCursor(this.relationshipStore, this.relationshipGroupStore, cursorTracer);
    }

    public RecordRelationshipScanCursor allocateRelationshipScanCursor(PageCursorTracer cursorTracer) {
        return new RecordRelationshipScanCursor(this.relationshipStore, cursorTracer);
    }

    public StorageSchemaReader schemaSnapshot() {
        return new StorageSchemaReaderSnapshot(this.schemaCache.snapshot());
    }

    public TokenNameLookup tokenNameLookup() {
        return this.tokenHolders;
    }

    public StoragePropertyCursor allocatePropertyCursor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        return new RecordPropertyCursor(this.propertyStore, cursorTracer, memoryTracker);
    }
}

