/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

public class RelationshipGroupGetter {
    private final IdSequence idGenerator;
    private final PageCursorTracer cursorTracer;

    public RelationshipGroupGetter(IdSequence idGenerator, PageCursorTracer cursorTracer) {
        this.idGenerator = idGenerator;
        this.cursorTracer = cursorTracer;
    }

    public RelationshipGroupPosition getRelationshipGroup(NodeRecord node, int type, RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords) {
        long groupId = node.getNextRel();
        long previousGroupId = Record.NO_NEXT_RELATIONSHIP.intValue();
        RecordAccess.RecordProxy<RelationshipGroupRecord, Object> previous = null;
        while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RecordAccess.RecordProxy<RelationshipGroupRecord, Object> current = relGroupRecords.getOrLoad(groupId, null, this.cursorTracer);
            RelationshipGroupRecord record = current.forReadingData();
            record.setPrev(previousGroupId);
            if (record.getType() == type) {
                return new RelationshipGroupPosition(previous, current);
            }
            if (record.getType() > type) {
                return new RelationshipGroupPosition(previous, null);
            }
            previousGroupId = groupId;
            groupId = record.getNext();
            previous = current;
        }
        return new RelationshipGroupPosition(previous, null);
    }

    public RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> getOrCreateRelationshipGroup(RecordAccess.RecordProxy<NodeRecord, Void> nodeChange, int type, RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords) {
        RelationshipGroupPosition existingGroup = this.getRelationshipGroup(nodeChange.forReadingLinkage(), type, relGroupRecords);
        RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> change = existingGroup.group();
        if (change == null) {
            NodeRecord node = nodeChange.forChangingLinkage();
            assert (node.isDense()) : "Node " + node + " should have been dense at this point";
            long id = this.idGenerator.nextId(this.cursorTracer);
            change = relGroupRecords.create(id, type, this.cursorTracer);
            RelationshipGroupRecord record = change.forChangingData();
            record.setInUse(true);
            record.setCreated();
            record.setOwningNode(node.getId());
            RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> closestPreviousChange = existingGroup.closestPrevious();
            if (closestPreviousChange != null) {
                RelationshipGroupRecord closestPrevious = closestPreviousChange.forChangingLinkage();
                record.setNext(closestPrevious.getNext());
                record.setPrev(closestPrevious.getId());
                closestPrevious.setNext(id);
            } else {
                long firstGroupId = node.getNextRel();
                if (firstGroupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                    RelationshipGroupRecord previousFirstRecord = relGroupRecords.getOrLoad(firstGroupId, type, this.cursorTracer).forReadingData();
                    record.setNext(previousFirstRecord.getId());
                    previousFirstRecord.setPrev(id);
                }
                node.setNextRel(id);
            }
        }
        return change;
    }

    public static class RelationshipGroupPosition {
        private final RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> closestPrevious;
        private final RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group;

        public RelationshipGroupPosition(RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> closestPrevious, RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group) {
            this.closestPrevious = closestPrevious;
            this.group = group;
        }

        public RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group() {
            return this.group;
        }

        public RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> closestPrevious() {
            return this.closestPrevious;
        }
    }
}

