/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.recordstorage.SchemaStorage;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccess;

public class SchemaRuleMigrationAccessImpl
implements SchemaRuleMigrationAccess {
    private final NeoStores neoStores;
    private final SchemaStorage schemaStorage;
    private final PageCursorTracer cursorTracer;
    private final MemoryTracker memoryTracker;

    SchemaRuleMigrationAccessImpl(NeoStores neoStores, SchemaStorage schemaStorage, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        this.neoStores = neoStores;
        this.schemaStorage = schemaStorage;
        this.cursorTracer = cursorTracer;
        this.memoryTracker = memoryTracker;
    }

    public Iterable<SchemaRule> getAll() {
        return this.schemaStorage.getAll(this.cursorTracer);
    }

    public void writeSchemaRule(SchemaRule rule) throws KernelException {
        this.schemaStorage.writeSchemaRule(rule, this.cursorTracer, this.memoryTracker);
    }

    public void close() throws IOException {
        this.neoStores.flush(IOLimiter.UNLIMITED, this.cursorTracer);
        this.neoStores.close();
    }
}

