/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.internal.recordstorage.PropertyBasedSchemaRecordChangeTranslator;
import org.neo4j.internal.recordstorage.SchemaRecordChangeTranslator;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class SchemaStorage
implements SchemaRuleAccess,
org.neo4j.kernel.impl.storemigration.SchemaStorage {
    private final SchemaStore schemaStore;
    private final TokenHolders tokenHolders;

    public SchemaStorage(SchemaStore schemaStore, TokenHolders tokenHolders) {
        this.schemaStore = schemaStore;
        this.tokenHolders = tokenHolders;
    }

    @Override
    public long newRuleId(PageCursorTracer cursorTracer) {
        return this.schemaStore.nextId(cursorTracer);
    }

    @Override
    public Iterable<SchemaRule> getAll(PageCursorTracer cursorTracer) {
        return this.streamAllSchemaRules(false, cursorTracer)::iterator;
    }

    @Override
    public SchemaRule loadSingleSchemaRule(long ruleId, PageCursorTracer cursorTracer) throws MalformedSchemaRuleException {
        SchemaRecord record = (SchemaRecord)this.schemaStore.newRecord();
        this.schemaStore.getRecord(ruleId, record, RecordLoad.NORMAL, cursorTracer);
        return this.readSchemaRule(record, cursorTracer);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(PageCursorTracer cursorTracer) {
        return this.indexRules(this.streamAllSchemaRules(false, cursorTracer)).iterator();
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAllIgnoreMalformed(PageCursorTracer cursorTracer) {
        return this.indexRules(this.streamAllSchemaRules(true, cursorTracer)).iterator();
    }

    @Override
    public IndexDescriptor[] indexGetForSchema(SchemaDescriptorSupplier supplier, PageCursorTracer cursorTracer) {
        SchemaDescriptor schema = supplier.schema();
        return (IndexDescriptor[])this.indexRules(this.streamAllSchemaRules(false, cursorTracer)).filter(rule -> rule.schema().equals(schema)).toArray(IndexDescriptor[]::new);
    }

    @Override
    public IndexDescriptor indexGetForName(String indexName, PageCursorTracer cursorTracer) {
        return this.indexRules(this.streamAllSchemaRules(false, cursorTracer)).filter(idx -> idx.getName().equals(indexName)).findAny().orElse(null);
    }

    @Override
    public ConstraintDescriptor constraintsGetSingle(ConstraintDescriptor descriptor, PageCursorTracer cursorTracer) throws SchemaRuleNotFoundException, DuplicateSchemaRuleException {
        ConstraintDescriptor[] rules = (ConstraintDescriptor[])this.constraintRules(this.streamAllSchemaRules(false, cursorTracer)).filter(descriptor::equals).toArray(ConstraintDescriptor[]::new);
        if (rules.length == 0) {
            throw new SchemaRuleNotFoundException((SchemaDescriptorSupplier)descriptor, (TokenNameLookup)this.tokenHolders);
        }
        if (rules.length > 1) {
            throw new DuplicateSchemaRuleException((SchemaDescriptorSupplier)descriptor, (TokenNameLookup)this.tokenHolders);
        }
        return rules[0];
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetAllIgnoreMalformed(PageCursorTracer cursorTracer) {
        return this.constraintRules(this.streamAllSchemaRules(true, cursorTracer)).iterator();
    }

    @Override
    public SchemaRecordChangeTranslator getSchemaRecordChangeTranslator() {
        return new PropertyBasedSchemaRecordChangeTranslator(){

            @Override
            protected IntObjectMap<Value> asMap(SchemaRule rule) throws KernelException {
                return SchemaStore.convertSchemaRuleToMap(rule, SchemaStorage.this.tokenHolders);
            }

            @Override
            protected void setConstraintIndexOwnerProperty(long constraintId, IntObjectProcedure<Value> proc) throws KernelException {
                int propertyId = SchemaStore.getOwningConstraintPropertyKeyId(SchemaStorage.this.tokenHolders);
                proc.value(propertyId, (Object)Values.longValue((long)constraintId));
            }
        };
    }

    @Override
    public void writeSchemaRule(SchemaRule rule, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) throws KernelException {
        IntObjectMap<Value> protoProperties = SchemaStore.convertSchemaRuleToMap(rule, this.tokenHolders);
        PropertyStore propertyStore = this.schemaStore.propertyStore();
        ArrayList blocks = new ArrayList();
        protoProperties.forEachKeyValue((IntObjectProcedure & Serializable)(keyId, value) -> {
            PropertyBlock block = new PropertyBlock();
            propertyStore.encodeValue(block, keyId, (Value)value, cursorTracer, memoryTracker);
            blocks.add(block);
        });
        assert (!blocks.isEmpty()) : "Property blocks should have been produced for schema rule: " + rule;
        long nextPropId = Record.NO_NEXT_PROPERTY.longValue();
        PropertyRecord currRecord = this.newInitialisedPropertyRecord(propertyStore, rule, cursorTracer);
        for (PropertyBlock block : blocks) {
            if (!currRecord.hasSpaceFor(block)) {
                PropertyRecord nextRecord = this.newInitialisedPropertyRecord(propertyStore, rule, cursorTracer);
                this.linkAndWritePropertyRecord(propertyStore, currRecord, nextRecord.getId(), nextPropId, cursorTracer);
                nextPropId = currRecord.getId();
                currRecord = nextRecord;
            }
            currRecord.addPropertyBlock(block);
        }
        this.linkAndWritePropertyRecord(propertyStore, currRecord, Record.NO_PREVIOUS_PROPERTY.longValue(), nextPropId, cursorTracer);
        nextPropId = currRecord.getId();
        SchemaRecord schemaRecord = (SchemaRecord)this.schemaStore.newRecord();
        schemaRecord.initialize(true, nextPropId);
        schemaRecord.setId(rule.getId());
        schemaRecord.setCreated();
        this.schemaStore.updateRecord(schemaRecord, cursorTracer);
        this.schemaStore.setHighestPossibleIdInUse(rule.getId());
    }

    private PropertyRecord newInitialisedPropertyRecord(PropertyStore propertyStore, SchemaRule rule, PageCursorTracer cursorTracer) {
        PropertyRecord record = propertyStore.newRecord();
        record.setId(propertyStore.nextId(cursorTracer));
        record.setSchemaRuleId(rule.getId());
        record.setCreated();
        return record;
    }

    private void linkAndWritePropertyRecord(PropertyStore propertyStore, PropertyRecord record, long prevPropId, long nextProp, PageCursorTracer cursorTracer) {
        record.setInUse(true);
        record.setPrevProp(prevPropId);
        record.setNextProp(nextProp);
        propertyStore.updateRecord(record, cursorTracer);
        propertyStore.setHighestPossibleIdInUse(record.getId());
    }

    @Override
    public void deleteSchemaRule(SchemaRule rule, PageCursorTracer cursorTracer) {
        SchemaRecord record = (SchemaRecord)this.schemaStore.newRecord();
        this.schemaStore.getRecord(rule.getId(), record, RecordLoad.CHECK, cursorTracer);
        if (record.inUse()) {
            long nextProp = record.getNextProp();
            record.setInUse(false);
            this.schemaStore.updateRecord(record, cursorTracer);
            PropertyStore propertyStore = this.schemaStore.propertyStore();
            PropertyRecord props = propertyStore.newRecord();
            while (nextProp != Record.NO_NEXT_PROPERTY.longValue() && propertyStore.getRecord(nextProp, props, RecordLoad.NORMAL, cursorTracer).inUse()) {
                nextProp = props.getNextProp();
                props.setInUse(false);
                propertyStore.updateRecord(props, cursorTracer);
            }
        }
    }

    @VisibleForTesting
    Stream<SchemaRule> streamAllSchemaRules(boolean ignoreMalformed, PageCursorTracer cursorTracer) {
        long startId = this.schemaStore.getNumberOfReservedLowIds();
        long endId = this.schemaStore.getHighId();
        return LongStream.range(startId, endId).mapToObj(id -> this.schemaStore.getRecord(id, (SchemaRecord)this.schemaStore.newRecord(), RecordLoad.LENIENT_ALWAYS, cursorTracer)).filter(AbstractBaseRecord::inUse).flatMap(record -> this.readSchemaRuleThrowingRuntimeException((SchemaRecord)record, ignoreMalformed, cursorTracer));
    }

    private Stream<IndexDescriptor> indexRules(Stream<SchemaRule> stream) {
        return stream.filter(rule -> rule instanceof IndexDescriptor).map(rule -> (IndexDescriptor)rule);
    }

    private Stream<ConstraintDescriptor> constraintRules(Stream<SchemaRule> stream) {
        return stream.filter(rule -> rule instanceof ConstraintDescriptor).map(rule -> (ConstraintDescriptor)rule);
    }

    private Stream<SchemaRule> readSchemaRuleThrowingRuntimeException(SchemaRecord record, boolean ignoreMalformed, PageCursorTracer cursorTracer) {
        try {
            return Stream.of(this.readSchemaRule(record, cursorTracer));
        }
        catch (MalformedSchemaRuleException e) {
            if (!ignoreMalformed && this.schemaStore.isInUse(record.getId(), cursorTracer)) {
                throw new RuntimeException(e);
            }
            return Stream.empty();
        }
    }

    private SchemaRule readSchemaRule(SchemaRecord record, PageCursorTracer cursorTracer) throws MalformedSchemaRuleException {
        return SchemaStore.readSchemaRule(record, this.schemaStore.propertyStore(), this.tokenHolders, cursorTracer);
    }
}

