/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.Iterator;
import org.neo4j.internal.recordstorage.SchemaCache;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.storageengine.api.StorageSchemaReader;

class StorageSchemaReaderSnapshot
implements StorageSchemaReader {
    private final SchemaCache schema;

    StorageSchemaReaderSnapshot(SchemaCache schema) {
        this.schema = schema;
    }

    public IndexDescriptor indexGetForName(String name) {
        return this.schema.indexForName(name);
    }

    public ConstraintDescriptor constraintGetForName(String name) {
        return this.schema.constraintForName(name);
    }

    public Iterator<IndexDescriptor> indexGetForSchema(SchemaDescriptor descriptor) {
        return this.schema.indexesForSchema(descriptor);
    }

    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        return this.schema.indexesForLabel(labelId);
    }

    public Iterator<IndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        return this.schema.indexesForRelationshipType(relationshipType);
    }

    public Iterator<IndexDescriptor> indexesGetAll() {
        return this.schema.indexes().iterator();
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        return this.schema.constraintsForLabel(labelId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        return this.schema.constraintsForRelationshipType(typeId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        return this.schema.constraints().iterator();
    }
}

