/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.List;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokensLoader;

public class StoreTokens {
    private StoreTokens() {
    }

    public static TokensLoader allReadableTokens(final NeoStores neoStores) {
        return new TokensLoader(){

            public List<NamedToken> getPropertyKeyTokens(PageCursorTracer cursorTracer) {
                return neoStores.getPropertyKeyTokenStore().getAllReadableTokens(cursorTracer);
            }

            public List<NamedToken> getLabelTokens(PageCursorTracer cursorTracer) {
                return neoStores.getLabelTokenStore().getAllReadableTokens(cursorTracer);
            }

            public List<NamedToken> getRelationshipTypeTokens(PageCursorTracer cursorTracer) {
                return neoStores.getRelationshipTypeTokenStore().getAllReadableTokens(cursorTracer);
            }
        };
    }

    public static TokensLoader allTokens(final NeoStores neoStores) {
        return new TokensLoader(){

            public List<NamedToken> getPropertyKeyTokens(PageCursorTracer cursorTracer) {
                return neoStores.getPropertyKeyTokenStore().getTokens(cursorTracer);
            }

            public List<NamedToken> getLabelTokens(PageCursorTracer cursorTracer) {
                return neoStores.getLabelTokenStore().getTokens(cursorTracer);
            }

            public List<NamedToken> getRelationshipTypeTokens(PageCursorTracer cursorTracer) {
                return neoStores.getRelationshipTypeTokenStore().getTokens(cursorTracer);
            }
        };
    }

    public static TokenHolders readOnlyTokenHolders(NeoStores neoStores, PageCursorTracer cursorTracer) {
        TokenHolder propertyKeyTokens = StoreTokens.createReadOnlyTokenHolder("PropertyKey");
        TokenHolder labelTokens = StoreTokens.createReadOnlyTokenHolder("Label");
        TokenHolder relationshipTypeTokens = StoreTokens.createReadOnlyTokenHolder("RelationshipType");
        TokenHolders tokenHolders = new TokenHolders(propertyKeyTokens, labelTokens, relationshipTypeTokens);
        tokenHolders.setInitialTokens(StoreTokens.allReadableTokens(neoStores), cursorTracer);
        return tokenHolders;
    }

    public static TokenHolder createReadOnlyTokenHolder(String tokenType) {
        return new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), tokenType);
    }
}

