/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.List;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityTokenUpdateListener;
import org.neo4j.util.concurrent.Work;

public class TokenUpdateWork
implements Work<EntityTokenUpdateListener, TokenUpdateWork> {
    private final List<EntityTokenUpdate> tokenUpdates;
    private final PageCursorTracer cursorTracer;

    TokenUpdateWork(List<EntityTokenUpdate> tokenUpdates, PageCursorTracer cursorTracer) {
        this.tokenUpdates = tokenUpdates;
        this.cursorTracer = cursorTracer;
    }

    public TokenUpdateWork combine(TokenUpdateWork work) {
        this.tokenUpdates.addAll(work.tokenUpdates);
        return this;
    }

    public void apply(EntityTokenUpdateListener listener) {
        this.tokenUpdates.sort(EntityTokenUpdate.SORT_BY_ENTITY_ID);
        listener.applyUpdates(this.tokenUpdates, this.cursorTracer);
    }
}

