/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFacade;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.kernel.impl.store.IdUpdateListener;
import org.neo4j.storageengine.api.CommandsToApply;

public class TransactionApplierFactoryChain
implements TransactionApplierFactory {
    private final Supplier<IdUpdateListener> idUpdateListenerSupplier;
    private final TransactionApplierFactory[] appliers;

    public TransactionApplierFactoryChain(Supplier<IdUpdateListener> idUpdateListenerSupplier, TransactionApplierFactory ... appliers) {
        this.idUpdateListenerSupplier = idUpdateListenerSupplier;
        this.appliers = appliers;
    }

    public Supplier<IdUpdateListener> getIdUpdateListenerSupplier() {
        return this.idUpdateListenerSupplier;
    }

    @Override
    public TransactionApplier startTx(CommandsToApply transaction, BatchContext batchContext) throws IOException {
        TransactionApplier[] txAppliers = new TransactionApplier[this.appliers.length];
        for (int i = 0; i < this.appliers.length; ++i) {
            txAppliers[i] = this.appliers[i].startTx(transaction, batchContext);
        }
        return new TransactionApplierFacade(txAppliers);
    }
}

