/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.IntegrityValidator;
import org.neo4j.internal.recordstorage.PropertyCreator;
import org.neo4j.internal.recordstorage.PropertyDeleter;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordAccessSet;
import org.neo4j.internal.recordstorage.RecordChangeSet;
import org.neo4j.internal.recordstorage.RecordState;
import org.neo4j.internal.recordstorage.RelationshipCreator;
import org.neo4j.internal.recordstorage.RelationshipDeleter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.values.storable.Value;

public class TransactionRecordState
implements RecordState {
    private static final CommandComparator COMMAND_COMPARATOR = new CommandComparator();
    private static final Command[] EMPTY_COMMANDS = new Command[0];
    private static final Function<Command.Mode, List<Command>> MODE_TO_ARRAY_LIST = mode -> new ArrayList();
    private final NeoStores neoStores;
    private final IntegrityValidator integrityValidator;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final PropertyStore propertyStore;
    private final RecordStore<RelationshipGroupRecord> relationshipGroupStore;
    private final RecordAccessSet recordChangeSet;
    private final long lastCommittedTxWhenTransactionStarted;
    private final ResourceLocker locks;
    private final RelationshipCreator relationshipCreator;
    private final RelationshipDeleter relationshipDeleter;
    private final PropertyCreator propertyCreator;
    private final PropertyDeleter propertyDeleter;
    private final PageCursorTracer cursorTracer;
    private final MemoryTracker memoryTracker;
    private boolean prepared;

    TransactionRecordState(NeoStores neoStores, IntegrityValidator integrityValidator, RecordChangeSet recordChangeSet, long lastCommittedTxWhenTransactionStarted, ResourceLocker locks, RelationshipCreator relationshipCreator, RelationshipDeleter relationshipDeleter, PropertyCreator propertyCreator, PropertyDeleter propertyDeleter, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        this.neoStores = neoStores;
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.propertyStore = neoStores.getPropertyStore();
        this.relationshipGroupStore = neoStores.getRelationshipGroupStore();
        this.integrityValidator = integrityValidator;
        this.recordChangeSet = recordChangeSet;
        this.lastCommittedTxWhenTransactionStarted = lastCommittedTxWhenTransactionStarted;
        this.locks = locks;
        this.relationshipCreator = relationshipCreator;
        this.relationshipDeleter = relationshipDeleter;
        this.propertyCreator = propertyCreator;
        this.propertyDeleter = propertyDeleter;
        this.cursorTracer = cursorTracer;
        this.memoryTracker = memoryTracker;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void extractCommands(Collection<StorageCommand> commands, MemoryTracker memoryTracker) throws TransactionFailureException {
        void var7_13;
        void var14_31;
        void var8_16;
        assert (!this.prepared) : "Transaction has already been prepared";
        this.integrityValidator.validateTransactionStartKnowledge(this.lastCommittedTxWhenTransactionStarted);
        int noOfCommands = this.recordChangeSet.changeSize();
        Collection<RecordAccess.RecordProxy<LabelTokenRecord, Void>> labelTokenChanges = this.recordChangeSet.getLabelTokenChanges().changes();
        memoryTracker.allocateHeap((long)labelTokenChanges.size() * Command.LabelTokenCommand.HEAP_SIZE);
        for (RecordAccess.RecordProxy<LabelTokenRecord, Void> recordProxy : labelTokenChanges) {
            commands.add(new Command.LabelTokenCommand(recordProxy.getBefore(), recordProxy.forReadingLinkage()));
        }
        Collection<RecordAccess.RecordProxy<RelationshipTypeTokenRecord, Void>> relationshipTypeTokenChanges = this.recordChangeSet.getRelationshipTypeTokenChanges().changes();
        memoryTracker.allocateHeap((long)relationshipTypeTokenChanges.size() * Command.RelationshipTypeTokenCommand.HEAP_SIZE);
        for (RecordAccess.RecordProxy<RelationshipTypeTokenRecord, Void> recordProxy : relationshipTypeTokenChanges) {
            commands.add(new Command.RelationshipTypeTokenCommand(recordProxy.getBefore(), recordProxy.forReadingLinkage()));
        }
        Collection<RecordAccess.RecordProxy<PropertyKeyTokenRecord, Void>> collection = this.recordChangeSet.getPropertyKeyTokenChanges().changes();
        memoryTracker.allocateHeap((long)collection.size() * Command.PropertyKeyTokenCommand.HEAP_SIZE);
        for (RecordAccess.RecordProxy<PropertyKeyTokenRecord, Void> recordProxy : collection) {
            commands.add(new Command.PropertyKeyTokenCommand(recordProxy.getBefore(), recordProxy.forReadingLinkage()));
        }
        Command[] commandArray = EMPTY_COMMANDS;
        boolean bl = false;
        Collection<RecordAccess.RecordProxy<NodeRecord, Void>> nodeChanges = this.recordChangeSet.getNodeRecords().changes();
        if (!nodeChanges.isEmpty()) {
            memoryTracker.allocateHeap((long)nodeChanges.size() * Command.NodeCommand.HEAP_SIZE);
            Command[] commandArray2 = new Command[nodeChanges.size()];
            int i = 0;
            for (RecordAccess.RecordProxy<NodeRecord, Void> change : nodeChanges) {
                NodeRecord record = this.prepared(change, this.nodeStore);
                this.integrityValidator.validateNodeRecord(record);
                commandArray2[i++] = new Command.NodeCommand(change.getBefore(), record);
            }
            Arrays.sort(commandArray2, COMMAND_COMPARATOR);
        }
        Command[] relCommands = EMPTY_COMMANDS;
        Collection<RecordAccess.RecordProxy<RelationshipRecord, Void>> relationshipChanges = this.recordChangeSet.getRelRecords().changes();
        if (!relationshipChanges.isEmpty()) {
            memoryTracker.allocateHeap((long)relationshipChanges.size() * Command.RelationshipCommand.HEAP_SIZE);
            relCommands = new Command[relationshipChanges.size()];
            int i = 0;
            for (RecordAccess.RecordProxy recordProxy : relationshipChanges) {
                relCommands[i++] = new Command.RelationshipCommand((RelationshipRecord)recordProxy.getBefore(), this.prepared(recordProxy, this.relationshipStore));
            }
            Arrays.sort(relCommands, COMMAND_COMPARATOR);
        }
        Command[] propCommands = EMPTY_COMMANDS;
        Collection<RecordAccess.RecordProxy<PropertyRecord, PrimitiveRecord>> propertyChanges = this.recordChangeSet.getPropertyRecords().changes();
        if (!propertyChanges.isEmpty()) {
            memoryTracker.allocateHeap((long)propertyChanges.size() * Command.PropertyCommand.HEAP_SIZE);
            propCommands = new Command[propertyChanges.size()];
            boolean bl2 = false;
            for (RecordAccess.RecordProxy<PropertyRecord, PrimitiveRecord> change : propertyChanges) {
                propCommands[++var14_27] = new Command.PropertyCommand(change.getBefore(), this.prepared(change, this.propertyStore));
            }
            Arrays.sort(propCommands, COMMAND_COMPARATOR);
        }
        Command[] commandArray3 = EMPTY_COMMANDS;
        Collection<RecordAccess.RecordProxy<RelationshipGroupRecord, Integer>> relationshipGroupChanges = this.recordChangeSet.getRelGroupRecords().changes();
        if (!relationshipGroupChanges.isEmpty()) {
            memoryTracker.allocateHeap((long)relationshipGroupChanges.size() * Command.RelationshipGroupCommand.HEAP_SIZE);
            Command[] commandArray4 = new Command[relationshipGroupChanges.size()];
            int i = 0;
            for (RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> change : relationshipGroupChanges) {
                if (change.isCreated() && !change.forReadingLinkage().inUse()) {
                    ++var8_16;
                    continue;
                }
                commandArray4[i++] = new Command.RelationshipGroupCommand(change.getBefore(), this.prepared(change, this.relationshipGroupStore));
            }
            Command[] commandArray5 = i < commandArray4.length ? Arrays.copyOf(commandArray4, i) : commandArray4;
            Arrays.sort(commandArray5, COMMAND_COMPARATOR);
        }
        this.addFiltered(commands, Command.Mode.CREATE, new Command[][]{propCommands, relCommands, var14_31, var7_13});
        this.addFiltered(commands, Command.Mode.UPDATE, new Command[][]{propCommands, relCommands, var14_31, var7_13});
        this.addFiltered(commands, Command.Mode.DELETE, new Command[][]{relCommands, var14_31, var7_13});
        EnumMap<Command.Mode, List<Command>> schemaChangeByMode = new EnumMap<Command.Mode, List<Command>>(Command.Mode.class);
        Collection<RecordAccess.RecordProxy<SchemaRecord, SchemaRule>> schemaRuleChange = this.recordChangeSet.getSchemaRuleChanges().changes();
        memoryTracker.allocateHeap((long)schemaRuleChange.size() * Command.SchemaRuleCommand.HEAP_SIZE);
        for (RecordAccess.RecordProxy<SchemaRecord, SchemaRule> change : schemaRuleChange) {
            SchemaRecord schemaRecord = change.forReadingLinkage();
            SchemaRule rule = change.getAdditionalData();
            if (schemaRecord.inUse()) {
                this.integrityValidator.validateSchemaRule(rule);
            }
            Command.SchemaRuleCommand cmd = new Command.SchemaRuleCommand(change.getBefore(), change.forChangingData(), rule);
            schemaChangeByMode.computeIfAbsent(cmd.getMode(), MODE_TO_ARRAY_LIST).add(cmd);
        }
        commands.addAll(schemaChangeByMode.getOrDefault((Object)Command.Mode.DELETE, Collections.emptyList()));
        commands.addAll(schemaChangeByMode.getOrDefault((Object)Command.Mode.CREATE, Collections.emptyList()));
        commands.addAll(schemaChangeByMode.getOrDefault((Object)Command.Mode.UPDATE, Collections.emptyList()));
        this.addFiltered(commands, Command.Mode.DELETE, new Command[][]{propCommands});
        assert (commands.size() == noOfCommands - var8_16) : String.format("Expected %d final commands, got %d instead, with %d skipped", noOfCommands, commands.size(), (int)var8_16);
        this.prepared = true;
    }

    private <RECORD extends AbstractBaseRecord> RECORD prepared(RecordAccess.RecordProxy<RECORD, ?> proxy, RecordStore<RECORD> store) {
        AbstractBaseRecord after = (AbstractBaseRecord)proxy.forReadingLinkage();
        store.prepareForCommit(after, this.cursorTracer);
        return (RECORD)after;
    }

    void relCreate(long id, int typeId, long startNodeId, long endNodeId) {
        this.relationshipCreator.relationshipCreate(id, typeId, startNodeId, endNodeId, this.recordChangeSet, this.locks);
    }

    void relDelete(long relId) {
        this.relationshipDeleter.relDelete(relId, this.recordChangeSet, this.locks);
    }

    private void addFiltered(Collection<StorageCommand> target, Command.Mode mode, Command[] ... commands) {
        Command[][] commandArray = commands;
        int n = commandArray.length;
        for (int i = 0; i < n; ++i) {
            Command[] c;
            for (Command command : c = commandArray[i]) {
                if (command.getMode() != mode) continue;
                target.add(command);
            }
        }
    }

    public void nodeDelete(long nodeId) {
        NodeRecord nodeRecord = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null, this.cursorTracer).forChangingData();
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Unable to delete Node[" + nodeId + "] since it has already been deleted.");
        }
        nodeRecord.setInUse(false);
        nodeRecord.setLabelField(Record.NO_LABELS_FIELD.intValue(), this.markNotInUse(nodeRecord.getDynamicLabelRecords()));
        this.getAndDeletePropertyChain(nodeRecord);
    }

    private Collection<DynamicRecord> markNotInUse(Collection<DynamicRecord> dynamicLabelRecords) {
        for (DynamicRecord record : dynamicLabelRecords) {
            record.setInUse(false);
        }
        return dynamicLabelRecords;
    }

    private void getAndDeletePropertyChain(PrimitiveRecord record) {
        this.propertyDeleter.deletePropertyChain(record, this.recordChangeSet.getPropertyRecords());
    }

    void relRemoveProperty(long relId, int propertyKey) {
        RecordAccess.RecordProxy<RelationshipRecord, Object> rel = this.recordChangeSet.getRelRecords().getOrLoad(relId, null, this.cursorTracer);
        this.propertyDeleter.removeProperty(rel, propertyKey, this.recordChangeSet.getPropertyRecords());
    }

    public void nodeRemoveProperty(long nodeId, int propertyKey) {
        RecordAccess.RecordProxy<NodeRecord, Object> node = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null, this.cursorTracer);
        this.propertyDeleter.removeProperty(node, propertyKey, this.recordChangeSet.getPropertyRecords());
    }

    void relChangeProperty(long relId, int propertyKey, Value value) {
        RecordAccess.RecordProxy<RelationshipRecord, Object> rel = this.recordChangeSet.getRelRecords().getOrLoad(relId, null, this.cursorTracer);
        this.propertyCreator.primitiveSetProperty(rel, propertyKey, value, this.recordChangeSet.getPropertyRecords());
    }

    void nodeChangeProperty(long nodeId, int propertyKey, Value value) {
        RecordAccess.RecordProxy<NodeRecord, Object> node = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null, this.cursorTracer);
        this.propertyCreator.primitiveSetProperty(node, propertyKey, value, this.recordChangeSet.getPropertyRecords());
    }

    void relAddProperty(long relId, int propertyKey, Value value) {
        RecordAccess.RecordProxy<RelationshipRecord, Object> rel = this.recordChangeSet.getRelRecords().getOrLoad(relId, null, this.cursorTracer);
        this.propertyCreator.primitiveSetProperty(rel, propertyKey, value, this.recordChangeSet.getPropertyRecords());
    }

    void nodeAddProperty(long nodeId, int propertyKey, Value value) {
        RecordAccess.RecordProxy<NodeRecord, Object> node = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null, this.cursorTracer);
        this.propertyCreator.primitiveSetProperty(node, propertyKey, value, this.recordChangeSet.getPropertyRecords());
    }

    void addLabelToNode(long labelId, long nodeId) {
        NodeRecord nodeRecord = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null, this.cursorTracer).forChangingData();
        NodeLabelsField.parseLabelsField(nodeRecord).add(labelId, this.nodeStore, this.nodeStore.getDynamicLabelStore(), this.cursorTracer, this.memoryTracker);
    }

    void removeLabelFromNode(long labelId, long nodeId) {
        NodeRecord nodeRecord = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null, this.cursorTracer).forChangingData();
        NodeLabelsField.parseLabelsField(nodeRecord).remove(labelId, this.nodeStore, this.cursorTracer, this.memoryTracker);
    }

    public void nodeCreate(long nodeId) {
        NodeRecord nodeRecord = this.recordChangeSet.getNodeRecords().create(nodeId, null, this.cursorTracer).forChangingData();
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
    }

    void createPropertyKeyToken(String key, long id, boolean internal) {
        TransactionRecordState.createToken(this.neoStores.getPropertyKeyTokenStore(), key, id, internal, this.recordChangeSet.getPropertyKeyTokenChanges(), this.cursorTracer, this.memoryTracker);
    }

    void createLabelToken(String name, long id, boolean internal) {
        TransactionRecordState.createToken(this.neoStores.getLabelTokenStore(), name, id, internal, this.recordChangeSet.getLabelTokenChanges(), this.cursorTracer, this.memoryTracker);
    }

    void createRelationshipTypeToken(String name, long id, boolean internal) {
        TransactionRecordState.createToken(this.neoStores.getRelationshipTypeTokenStore(), name, id, internal, this.recordChangeSet.getRelationshipTypeTokenChanges(), this.cursorTracer, this.memoryTracker);
    }

    private static <R extends TokenRecord> void createToken(TokenStore<R> store, String name, long id, boolean internal, RecordAccess<R, Void> recordAccess, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        TokenRecord record = (TokenRecord)recordAccess.create(id, null, cursorTracer).forChangingData();
        record.setInUse(true);
        record.setInternal(internal);
        record.setCreated();
        Collection<DynamicRecord> nameRecords = store.allocateNameRecords(PropertyStore.encodeString(name), cursorTracer, memoryTracker);
        record.setNameId((int)((DynamicRecord)Iterables.first(nameRecords)).getId());
        record.addNameRecords(nameRecords);
    }

    void schemaRuleCreate(long ruleId, boolean isConstraint, SchemaRule rule) {
        SchemaRecord record = this.recordChangeSet.getSchemaRuleChanges().create(ruleId, rule, this.cursorTracer).forChangingData();
        record.setInUse(true);
        record.setCreated();
        record.setConstraint(isConstraint);
    }

    void schemaRuleDelete(long ruleId, SchemaRule rule) {
        RecordAccess.RecordProxy<SchemaRecord, SchemaRule> proxy = this.recordChangeSet.getSchemaRuleChanges().getOrLoad(ruleId, rule, this.cursorTracer);
        SchemaRecord record = proxy.forReadingData();
        if (record.inUse()) {
            record = proxy.forChangingData();
            record.setInUse(false);
            this.getAndDeletePropertyChain(record);
        }
    }

    void schemaRuleSetProperty(long ruleId, int propertyKeyId, Value value, SchemaRule rule) {
        RecordAccess.RecordProxy<SchemaRecord, SchemaRule> record = this.recordChangeSet.getSchemaRuleChanges().getOrLoad(ruleId, rule, this.cursorTracer);
        this.propertyCreator.primitiveSetProperty(record, propertyKeyId, value, this.recordChangeSet.getPropertyRecords());
    }

    void schemaRuleSetIndexOwner(IndexDescriptor rule, long constraintId, int propertyKeyId, Value value) {
        long ruleId = rule.getId();
        rule = rule.withOwningConstraintId(constraintId);
        RecordAccess<SchemaRecord, SchemaRule> changes = this.recordChangeSet.getSchemaRuleChanges();
        RecordAccess.RecordProxy<SchemaRecord, SchemaRule> record = changes.getOrLoad(ruleId, (SchemaRule)rule, this.cursorTracer);
        changes.setRecord(ruleId, record.forReadingData(), (SchemaRule)rule, this.cursorTracer).forChangingData();
        this.propertyCreator.primitiveSetProperty(record, propertyKeyId, value, this.recordChangeSet.getPropertyRecords());
    }

    public static interface PropertyReceiver<P extends StorageProperty> {
        public void receive(P var1, long var2);
    }

    private static class CommandComparator
    implements Comparator<Command> {
        private CommandComparator() {
        }

        @Override
        public int compare(Command o1, Command o2) {
            long id1 = o1.getKey();
            long id2 = o2.getKey();
            return Long.compare(id1, id2);
        }
    }
}

