/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongPredicate;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.function.Predicates;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.id.FreeIds;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.internal.recordstorage.InconsistentDataReadException;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.IdUpdateListener;
import org.neo4j.kernel.impl.store.IntStoreHeader;
import org.neo4j.kernel.impl.store.RecordChainCycleDetectedException;
import org.neo4j.kernel.impl.store.RecordPageLocationCalculator;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RecordSubscriber;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.StoreHeaderFormat;
import org.neo4j.kernel.impl.store.StoreNotFoundException;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.util.concurrent.Runnables;

public abstract class CommonAbstractStore<RECORD extends AbstractBaseRecord, HEADER extends StoreHeader>
implements RecordStore<RECORD>,
AutoCloseable {
    static final String UNKNOWN_VERSION = "Unknown";
    protected final Config configuration;
    protected final PageCache pageCache;
    protected final IdType idType;
    protected final IdGeneratorFactory idGeneratorFactory;
    protected final Log log;
    protected final String storeVersion;
    protected final RecordFormat<RECORD> recordFormat;
    final Path storageFile;
    private final Path idFile;
    private final String typeDescriptor;
    protected PagedFile pagedFile;
    protected int recordSize;
    private int filePageSize;
    private int recordsPerPage;
    private int recordsEndOffset;
    private IdGenerator idGenerator;
    private boolean storeOk = true;
    private RuntimeException causeOfStoreNotOk;
    private final StoreHeaderFormat<HEADER> storeHeaderFormat;
    private HEADER storeHeader;
    private final ImmutableSet<OpenOption> openOptions;

    public CommonAbstractStore(Path path, Path idFile, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, String typeDescriptor, RecordFormat<RECORD> recordFormat, StoreHeaderFormat<HEADER> storeHeaderFormat, String storeVersion, ImmutableSet<OpenOption> openOptions) {
        this.storageFile = path;
        this.idFile = idFile;
        this.configuration = configuration;
        this.idGeneratorFactory = idGeneratorFactory;
        this.pageCache = pageCache;
        this.idType = idType;
        this.typeDescriptor = typeDescriptor;
        this.recordFormat = recordFormat;
        this.storeHeaderFormat = storeHeaderFormat;
        this.storeVersion = storeVersion;
        this.openOptions = openOptions;
        this.log = logProvider.getLog(this.getClass());
    }

    protected void initialise(boolean createIfNotExists, PageCursorTracer cursorTracer) {
        try {
            boolean created = this.checkAndLoadStorage(createIfNotExists, cursorTracer);
            if (!created) {
                this.openIdGenerator(cursorTracer);
            }
        }
        catch (Exception e) {
            this.closeAndThrow(e);
        }
    }

    private void closeAndThrow(Exception e) {
        this.closeStoreFile();
        Exceptions.throwIfUnchecked((Throwable)e);
        throw new RuntimeException(e);
    }

    public String getTypeDescriptor() {
        return this.typeDescriptor;
    }

    private boolean checkAndLoadStorage(boolean createIfNotExists, PageCursorTracer cursorTracer) {
        try {
            this.determineRecordSize(this.storeHeaderFormat.generateHeader());
            if (this.getNumberOfReservedLowIds() > 0) {
                HEADER defaultHeader = this.storeHeaderFormat.generateHeader();
                this.pagedFile = this.pageCache.map(this.storageFile, this.filePageSize, this.openOptions.newWith((Object)PageCacheOpenOptions.ANY_PAGE_SIZE));
                HEADER readHeader = this.readStoreHeaderAndDetermineRecordSize(this.pagedFile, cursorTracer);
                if (!defaultHeader.equals(readHeader)) {
                    this.pagedFile.close();
                    this.pagedFile = null;
                }
            }
            if (this.pagedFile == null) {
                this.pagedFile = this.pageCache.map(this.storageFile, this.filePageSize, this.openOptions);
            }
        }
        catch (NoSuchFileException | StoreNotFoundException e) {
            if (this.pagedFile != null) {
                this.pagedFile.close();
                this.pagedFile = null;
            }
            if (createIfNotExists) {
                try {
                    this.determineRecordSize(this.storeHeaderFormat.generateHeader());
                    boolean readOnly = (Boolean)this.configuration.get(GraphDatabaseSettings.read_only);
                    this.idGenerator = this.idGeneratorFactory.create(this.pageCache, this.idFile, this.idType, (long)this.getNumberOfReservedLowIds(), false, this.recordFormat.getMaxId(), readOnly, cursorTracer, this.openOptions);
                    this.pagedFile = this.pageCache.map(this.storageFile, this.filePageSize, this.openOptions.newWith((Object)StandardOpenOption.CREATE));
                    this.initialiseNewStoreFile(cursorTracer);
                    return true;
                }
                catch (IOException e1) {
                    ((Throwable)e).addSuppressed(e1);
                }
            }
            if (e instanceof StoreNotFoundException) {
                throw (StoreNotFoundException)((Object)e);
            }
            throw new StoreNotFoundException("Store file not found: " + this.storageFile, (Throwable)e);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to open store file: " + this.storageFile, (Throwable)e);
        }
        return false;
    }

    protected void initialiseNewStoreFile(PageCursorTracer cursorTracer) throws IOException {
        if (this.getNumberOfReservedLowIds() > 0) {
            try (PageCursor pageCursor = this.pagedFile.io(0L, 66, cursorTracer);){
                if (pageCursor.next()) {
                    pageCursor.setOffset(0);
                    this.storeHeaderFormat.writeHeader(pageCursor);
                    if (pageCursor.checkAndClearBoundsFlag()) {
                        throw new UnderlyingStorageException("Out of page bounds when writing header; page size too small: " + this.pageCache.pageSize() + " bytes.");
                    }
                }
            }
            this.pagedFile.flushAndForce();
        }
        this.recordSize = this.determineRecordSize();
    }

    private HEADER readStoreHeaderAndDetermineRecordSize(PagedFile pagedFile, PageCursorTracer cursorTracer) throws IOException {
        try (PageCursor pageCursor = pagedFile.io(0L, 1, cursorTracer);){
            if (pageCursor.next()) {
                HEADER readHeader;
                do {
                    pageCursor.setOffset(0);
                    readHeader = this.readStoreHeaderAndDetermineRecordSize(pageCursor);
                } while (pageCursor.shouldRetry());
                if (pageCursor.checkAndClearBoundsFlag()) {
                    throw new UnderlyingStorageException("Out of page bounds when reading header; page size too small: " + this.pageCache.pageSize() + " bytes.");
                }
                HEADER HEADER = readHeader;
                return HEADER;
            }
            throw new StoreNotFoundException("Fail to read header record of store file: " + this.storageFile);
        }
    }

    protected long pageIdForRecord(long id) {
        return RecordPageLocationCalculator.pageIdForRecord(id, this.recordsPerPage);
    }

    protected int offsetForId(long id) {
        return RecordPageLocationCalculator.offsetForId(id, this.recordSize, this.recordsPerPage);
    }

    @Override
    public int getRecordsPerPage() {
        return this.recordsPerPage;
    }

    public long getLastPageId() throws IOException {
        return this.pagedFile.getLastPageId();
    }

    public byte[] getRawRecordData(long id, PageCursorTracer cursorTracer) throws IOException {
        byte[] data = new byte[this.recordSize];
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        try (PageCursor cursor = this.pagedFile.io(pageId, 1, cursorTracer);){
            if (cursor.next()) {
                cursor.setOffset(offset);
                cursor.mark();
                do {
                    cursor.setOffsetToMark();
                    cursor.getBytes(data);
                } while (cursor.shouldRetry());
                this.checkForDecodingErrors(cursor, id, RecordLoad.FORCE);
            }
        }
        return data;
    }

    private HEADER readStoreHeaderAndDetermineRecordSize(PageCursor cursor) {
        HEADER header = this.storeHeaderFormat.readHeader(cursor);
        this.determineRecordSize(header);
        return header;
    }

    private void determineRecordSize(HEADER header) {
        this.storeHeader = header;
        this.recordSize = this.determineRecordSize();
        this.filePageSize = this.recordFormat.getPageSize(this.pageCache.pageSize(), this.recordSize);
        this.recordsPerPage = this.filePageSize / this.recordSize;
        this.recordsEndOffset = this.recordsPerPage * this.recordSize;
    }

    public boolean isInUse(long id, PageCursorTracer cursorTracer) {
        boolean bl;
        block10: {
            long pageId = this.pageIdForRecord(id);
            int offset = this.offsetForId(id);
            PageCursor cursor = this.pagedFile.io(pageId, 1, cursorTracer);
            try {
                boolean recordIsInUse = false;
                if (cursor.next()) {
                    cursor.setOffset(offset);
                    cursor.mark();
                    do {
                        cursor.setOffsetToMark();
                        recordIsInUse = this.isInUse(cursor);
                    } while (cursor.shouldRetry());
                    this.checkForDecodingErrors(cursor, id, RecordLoad.NORMAL);
                }
                bl = recordIsInUse;
                if (cursor == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException((Throwable)e);
                }
            }
            cursor.close();
        }
        return bl;
    }

    @Override
    public PageCursor openPageCursorForReadingWithPrefetching(long id, PageCursorTracer cursorTracer) {
        return this.openPageCursorForReading(0L, 8, cursorTracer);
    }

    @Override
    public PageCursor openPageCursorForReading(long id, PageCursorTracer cursorTracer) {
        return this.openPageCursorForReading(id, 0, cursorTracer);
    }

    private PageCursor openPageCursorForReading(long id, int additionalCursorFlags, PageCursorTracer cursorTracer) {
        try {
            long pageId = this.pageIdForRecord(id);
            return this.pagedFile.io(pageId, 1 | additionalCursorFlags, cursorTracer);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    private void checkIdScanCursorBounds(PageCursor cursor) {
        if (cursor.checkAndClearBoundsFlag()) {
            throw new UnderlyingStorageException("Out of bounds access on page " + cursor.getCurrentPageId() + " detected while scanning the " + this.storageFile + " file for deleted records");
        }
    }

    void setStoreNotOk(RuntimeException cause) {
        this.storeOk = false;
        this.causeOfStoreNotOk = cause;
    }

    void checkStoreOk() {
        if (!this.storeOk) {
            throw this.causeOfStoreNotOk;
        }
    }

    public long nextId(PageCursorTracer cursorTracer) {
        this.assertIdGeneratorInitialized();
        return this.idGenerator.nextId(cursorTracer);
    }

    private void assertIdGeneratorInitialized() {
        if (this.idGenerator == null) {
            throw new IllegalStateException("IdGenerator is not initialized");
        }
    }

    @Override
    public long getHighId() {
        return this.idGenerator.getHighId();
    }

    public void setHighId(long highId) {
        this.idGenerator.setHighId(highId);
    }

    void start(PageCursorTracer cursorTracer) throws IOException {
        if (!this.storeOk) {
            this.storeOk = true;
            this.causeOfStoreNotOk = null;
        }
        this.idGenerator.start(this.freeIds(cursorTracer), cursorTracer);
    }

    private FreeIds freeIds(PageCursorTracer cursorTracer) {
        return visitor -> {
            try (PageCursor cursor = this.pagedFile.io(0L, 9, cursorTracer);){
                int numberOfReservedLowIds;
                int startingId = numberOfReservedLowIds = this.getNumberOfReservedLowIds();
                int recordsPerPage = this.getRecordsPerPage();
                int blockSize = this.getRecordSize();
                long foundHighId = this.scanForHighId(cursorTracer);
                long[] foundIds = new long[recordsPerPage];
                boolean done = false;
                while (!done && cursor.next()) {
                    int foundIdsCursor;
                    block6: do {
                        foundIdsCursor = 0;
                        long idPageOffset = cursor.getCurrentPageId() * (long)recordsPerPage;
                        for (int i = startingId; i < recordsPerPage; ++i) {
                            int offset = i * blockSize;
                            cursor.setOffset(offset);
                            long recordId = idPageOffset + (long)i;
                            if (recordId >= foundHighId) {
                                done = true;
                                continue block6;
                            }
                            if (this.isInUse(cursor)) continue;
                            foundIds[foundIdsCursor++] = recordId;
                        }
                    } while (cursor.shouldRetry());
                    startingId = 0;
                    this.checkIdScanCursorBounds(cursor);
                    for (int i = 0; i < foundIdsCursor; ++i) {
                        visitor.accept(foundIds[i]);
                    }
                }
                long l = Long.max(numberOfReservedLowIds, foundHighId) - 1L;
                return l;
            }
        };
    }

    @Override
    public Path getStorageFile() {
        return this.storageFile;
    }

    private void openIdGenerator(PageCursorTracer cursorTracer) {
        boolean readOnly = (Boolean)this.configuration.get(GraphDatabaseSettings.read_only);
        this.idGenerator = this.idGeneratorFactory.open(this.pageCache, this.idFile, this.getIdType(), () -> this.scanForHighId(cursorTracer), this.recordFormat.getMaxId(), readOnly, cursorTracer, this.openOptions);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected long scanForHighId(PageCursorTracer cursorTracer) {
        try (PageCursor cursor = this.pagedFile.io(0L, 1, cursorTracer);){
            int recordsPerPage = this.getRecordsPerPage();
            int recordSize = this.getRecordSize();
            long highestId = this.getNumberOfReservedLowIds();
            long chunkSizeInPages = 256L;
            long chunkEndId = this.pagedFile.getLastPageId();
            while (chunkEndId >= 0L) {
                long chunkStartId = Math.max(chunkEndId - 256L, 0L);
                CommonAbstractStore.preFetchChunk(cursor, chunkStartId, chunkEndId);
                for (long currentId = chunkEndId; currentId >= chunkStartId && cursor.next(currentId); --currentId) {
                    boolean found;
                    do {
                        found = false;
                        long basePageId = cursor.getCurrentPageId() * (long)recordsPerPage;
                        for (int record = 0; record < recordsPerPage; ++record) {
                            cursor.setOffset(record * recordSize);
                            if (!this.isInUse(cursor)) continue;
                            highestId = basePageId + (long)record + 1L;
                            found = true;
                        }
                    } while (cursor.shouldRetry());
                    this.checkIdScanCursorBounds(cursor);
                    if (!found) continue;
                    long l = highestId;
                    return l;
                }
                chunkEndId = chunkStartId - 1L;
            }
            long l = this.getNumberOfReservedLowIds();
            return l;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to find high id by scanning backwards " + this.getStorageFile(), (Throwable)e);
        }
    }

    private static void preFetchChunk(PageCursor cursor, long pageIdStart, long pageIdEnd) throws IOException {
        for (long currentPageId = pageIdStart; currentPageId <= pageIdEnd; ++currentPageId) {
            cursor.next(currentPageId);
        }
    }

    protected int determineRecordSize() {
        return this.recordFormat.getRecordSize((StoreHeader)this.storeHeader);
    }

    @Override
    public final int getRecordSize() {
        return this.recordSize;
    }

    public long getStoreSize() throws IOException {
        return this.pagedFile.fileSize();
    }

    @Override
    public int getRecordDataSize() {
        return this.recordSize - this.recordFormat.getRecordHeaderSize();
    }

    private boolean isInUse(PageCursor cursor) {
        return this.recordFormat.isInUse(cursor);
    }

    @Override
    public void flush(PageCursorTracer cursorTracer) {
        try {
            this.pagedFile.flushAndForce();
            this.idGenerator.checkpoint(IOLimiter.UNLIMITED, cursorTracer);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to flush", (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.closeStoreFile();
        }
        catch (IllegalStateException e) {
            throw new UnderlyingStorageException("Failed to close store file: " + this.getStorageFile(), (Throwable)e);
        }
    }

    private void closeStoreFile() {
        Runnables.runAll((String)"Failure closing store and/or id generator", (Runnable[])new Runnable[]{() -> {
            if (this.pagedFile != null) {
                this.pagedFile.close();
                this.pagedFile = null;
            }
        }, () -> {
            if (this.idGenerator != null) {
                this.idGenerator.close();
                this.idGenerator = null;
            }
        }});
    }

    @Override
    public long getHighestPossibleIdInUse(PageCursorTracer cursorTracer) {
        return this.idGenerator != null ? this.idGenerator.getHighestPossibleIdInUse() : this.scanForHighId(cursorTracer) - 1L;
    }

    @Override
    public void setHighestPossibleIdInUse(long highId) {
        this.setHighId(highId + 1L);
    }

    public long getNumberOfIdsInUse() {
        this.assertIdGeneratorInitialized();
        return this.idGenerator.getNumberOfIdsInUse();
    }

    @Override
    public int getNumberOfReservedLowIds() {
        return this.storeHeaderFormat.numberOfReservedRecords();
    }

    public IdType getIdType() {
        return this.idType;
    }

    void logVersions(DiagnosticsLogger logger) {
        logger.log(String.format("%s[%s] %s", this.getTypeDescriptor(), this.getStorageFile().getFileName(), this.storeVersion));
    }

    void logIdUsage(DiagnosticsLogger logger, PageCursorTracer cursorTracer) {
        logger.log(String.format("%s[%s]: used=%s high=%s", this.getTypeDescriptor(), this.getStorageFile().getFileName(), this.getNumberOfIdsInUse(), this.getHighestPossibleIdInUse(cursorTracer)));
    }

    @Override
    public long getNextRecordReference(RECORD record) {
        return this.recordFormat.getNextRecordReference(record);
    }

    @Override
    public RECORD newRecord() {
        return this.recordFormat.newRecord();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RECORD getRecord(long id, RECORD record, RecordLoad mode, PageCursorTracer cursorTracer) {
        try (PageCursor cursor = this.pagedFile.io(0L, 1, cursorTracer);){
            this.readIntoRecord(id, record, mode, cursor);
            RECORD RECORD = record;
            return RECORD;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    @Override
    public void getRecordByCursor(long id, RECORD record, RecordLoad mode, PageCursor cursor) throws UnderlyingStorageException {
        try {
            this.readIntoRecord(id, record, mode, cursor);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    private void readIntoRecord(long id, RECORD record, RecordLoad mode, PageCursor cursor) throws IOException {
        ((AbstractBaseRecord)record).setId(id);
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        if (cursor.next(pageId)) {
            cursor.setOffset(offset);
            this.readRecordFromPage(id, record, mode, cursor);
        } else {
            this.verifyAfterNotRead(record, mode);
        }
    }

    @Override
    public void nextRecordByCursor(RECORD record, RecordLoad mode, PageCursor cursor) throws UnderlyingStorageException {
        if (cursor.getCurrentPageId() < -1L) {
            throw new IllegalArgumentException("Pages are assumed to be positive or -1 if not initialized");
        }
        try {
            long id = ((AbstractBaseRecord)record).getId() + 1L;
            ((AbstractBaseRecord)record).setId(id);
            long pageId = cursor.getCurrentPageId();
            if (!(cursor.getOffset() < this.recordsEndOffset && pageId >= 0L || cursor.next())) {
                this.verifyAfterNotRead(record, mode);
                return;
            }
            this.readRecordFromPage(id, record, mode, cursor);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    private void readRecordFromPage(long id, RECORD record, RecordLoad mode, PageCursor cursor) throws IOException {
        cursor.mark();
        do {
            this.prepareForReading(cursor, record);
            this.recordFormat.read(record, cursor, mode, this.recordSize, this.recordsPerPage);
        } while (cursor.shouldRetry());
        this.checkForDecodingErrors(cursor, id, mode);
        this.verifyAfterReading(record, mode);
    }

    @Override
    public void updateRecord(RECORD record, IdUpdateListener idUpdateListener, PageCursorTracer cursorTracer) {
        long id = ((AbstractBaseRecord)record).getId();
        IdValidator.assertValidId((IdType)this.getIdType(), (long)id, (long)this.recordFormat.getMaxId());
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        try (PageCursor cursor = this.pagedFile.io(pageId, 2, cursorTracer);){
            if (cursor.next()) {
                cursor.setOffset(offset);
                this.recordFormat.write(record, cursor, this.recordSize, this.recordsPerPage);
                this.checkForDecodingErrors(cursor, id, RecordLoad.NORMAL);
                if (!((AbstractBaseRecord)record).inUse()) {
                    idUpdateListener.markIdAsUnused(this.idType, this.idGenerator, id, cursorTracer);
                } else if (((AbstractBaseRecord)record).isCreated()) {
                    idUpdateListener.markIdAsUsed(this.idType, this.idGenerator, id, cursorTracer);
                }
                if (!(((AbstractBaseRecord)record).inUse() && ((AbstractBaseRecord)record).requiresSecondaryUnit() || !((AbstractBaseRecord)record).hasSecondaryUnitId())) {
                    idUpdateListener.markIdAsUnused(this.idType, this.idGenerator, ((AbstractBaseRecord)record).getSecondaryUnitId(), cursorTracer);
                }
                if (((AbstractBaseRecord)record).inUse() && ((AbstractBaseRecord)record).isSecondaryUnitCreated()) {
                    idUpdateListener.markIdAsUsed(this.idType, this.idGenerator, ((AbstractBaseRecord)record).getSecondaryUnitId(), cursorTracer);
                }
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    @Override
    public void prepareForCommit(RECORD record, PageCursorTracer cursorTracer) {
        this.prepareForCommit(record, this, cursorTracer);
    }

    @Override
    public void prepareForCommit(RECORD record, IdSequence idSequence, PageCursorTracer cursorTracer) {
        if (((AbstractBaseRecord)record).inUse()) {
            this.recordFormat.prepare(record, this.recordSize, idSequence, cursorTracer);
        }
    }

    @Override
    public <EXCEPTION extends Exception> void scanAllRecords(Visitor<RECORD, EXCEPTION> visitor, PageCursorTracer cursorTracer) throws EXCEPTION {
        try (PageCursor cursor = this.openPageCursorForReading(0L, cursorTracer);){
            RECORD record = this.newRecord();
            long highId = this.getHighId();
            for (long id = (long)this.getNumberOfReservedLowIds(); id < highId; ++id) {
                this.getRecordByCursor(id, record, RecordLoad.LENIENT_CHECK, cursor);
                if (!((AbstractBaseRecord)record).inUse()) continue;
                visitor.visit(record);
            }
        }
    }

    @Override
    public List<RECORD> getRecords(long firstId, RecordLoad mode, boolean guardForCycles, PageCursorTracer cursorTracer) {
        ArrayList list = new ArrayList();
        this.streamRecords(firstId, mode, guardForCycles, cursorTracer, list::add);
        return list;
    }

    @Override
    public void streamRecords(long firstId, RecordLoad mode, boolean guardForCycles, PageCursorTracer cursorTracer, RecordSubscriber<RECORD> subscriber) {
        if (Record.NULL_REFERENCE.is(firstId)) {
            return;
        }
        LongPredicate cycleGuard = guardForCycles ? this.createRecordCycleGuard() : Predicates.ALWAYS_FALSE_LONG;
        long id = firstId;
        MutableLongSet seenRecordIds = null;
        int count = 0;
        try (PageCursor cursor = this.openPageCursorForReading(firstId, cursorTracer);){
            do {
                RECORD record = this.newRecord();
                if (cycleGuard.test(id)) {
                    throw this.newCycleDetectedException(firstId, id, record);
                }
                this.getRecordByCursor(id, record, mode, cursor);
                if (!subscriber.onRecord(record)) {
                    return;
                }
                id = this.getNextRecordReference(record);
                if (++count < 100000) continue;
                if (seenRecordIds == null) {
                    seenRecordIds = LongSets.mutable.empty();
                }
                if (seenRecordIds.add(id)) continue;
                throw new InconsistentDataReadException("Chain cycle detected while reading chain in store %s starting at id:%d", this, firstId);
            } while (!Record.NULL_REFERENCE.is(id));
        }
    }

    private LongPredicate createRecordCycleGuard() {
        MutableLongSet observedSet = LongSets.mutable.empty();
        return id -> !observedSet.add(id);
    }

    private RecordChainCycleDetectedException newCycleDetectedException(long firstId, long conflictingId, RECORD record) {
        return new RecordChainCycleDetectedException("Cycle detected in " + record.getClass().getSimpleName() + " chain starting at id " + firstId + ", and finding id " + conflictingId + " twice in the chain.");
    }

    private void verifyAfterNotRead(RECORD record, RecordLoad mode) {
        ((AbstractBaseRecord)record).clear();
        mode.verify((AbstractBaseRecord)record);
    }

    final void checkForDecodingErrors(PageCursor cursor, long recordId, RecordLoad mode) {
        if (mode.checkForOutOfBounds(cursor)) {
            this.throwOutOfBoundsException(recordId);
        }
        mode.clearOrThrowCursorError(cursor);
    }

    private void throwOutOfBoundsException(long recordId) {
        RECORD record = this.newRecord();
        ((AbstractBaseRecord)record).setId(recordId);
        long pageId = this.pageIdForRecord(recordId);
        int offset = this.offsetForId(recordId);
        throw new UnderlyingStorageException(CommonAbstractStore.buildOutOfBoundsExceptionMessage(record, pageId, offset, this.recordSize, this.pagedFile.pageSize(), this.storageFile.toAbsolutePath().toString()));
    }

    static String buildOutOfBoundsExceptionMessage(AbstractBaseRecord record, long pageId, int offset, int recordSize, int pageSize, String filename) {
        return "Access to record " + record + " went out of bounds of the page. The record size is " + recordSize + " bytes, and the access was at offset " + offset + " bytes into page " + pageId + ", and the pages have a capacity of " + pageSize + " bytes. The mapped store file in question is " + filename;
    }

    private void verifyAfterReading(RECORD record, RecordLoad mode) {
        if (!mode.verify((AbstractBaseRecord)record)) {
            ((AbstractBaseRecord)record).clear();
        }
    }

    private void prepareForReading(PageCursor cursor, RECORD record) {
        ((AbstractBaseRecord)record).setInUse(false);
        cursor.setOffsetToMark();
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    @Override
    public void ensureHeavy(RECORD record, PageCursorTracer cursorTracer) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getStoreHeaderInt() {
        return ((IntStoreHeader)this.storeHeader).value();
    }
}

