/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.file.Path;
import org.neo4j.common.ProgressReporter;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.NodeCountsStage;
import org.neo4j.internal.batchimport.RelationshipCountsStage;
import org.neo4j.internal.batchimport.cache.NodeLabelsCache;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.staging.ExecutionSupervisors;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.logging.Log;
import org.neo4j.memory.MemoryTracker;

public class CountsComputer
implements CountsBuilder {
    private final NodeStore nodes;
    private final RelationshipStore relationships;
    private final int highLabelId;
    private final int highRelationshipTypeId;
    private final long lastCommittedTransactionId;
    private final DatabaseLayout databaseLayout;
    private final ProgressReporter progressMonitor;
    private final NumberArrayFactory numberArrayFactory;
    private final PageCacheTracer pageCacheTracer;
    private final MemoryTracker memoryTracker;

    public CountsComputer(NeoStores stores, PageCache pageCache, PageCacheTracer pageCacheTracer, DatabaseLayout databaseLayout, MemoryTracker memoryTracker, Log log) {
        this(stores.getMetaDataStore().getLastCommittedTransactionId(), stores.getNodeStore(), stores.getRelationshipStore(), (int)stores.getLabelTokenStore().getHighId(), (int)stores.getRelationshipTypeTokenStore().getHighId(), NumberArrayFactories.auto((PageCache)pageCache, (PageCacheTracer)pageCacheTracer, (Path)databaseLayout.databaseDirectory(), (boolean)true, (NumberArrayFactory.Monitor)NumberArrayFactories.NO_MONITOR, (Log)log), databaseLayout, pageCacheTracer, memoryTracker);
    }

    private CountsComputer(long lastCommittedTransactionId, NodeStore nodes, RelationshipStore relationships, int highLabelId, int highRelationshipTypeId, NumberArrayFactory numberArrayFactory, DatabaseLayout databaseLayout, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        this(lastCommittedTransactionId, nodes, relationships, highLabelId, highRelationshipTypeId, numberArrayFactory, databaseLayout, ProgressReporter.SILENT, pageCacheTracer, memoryTracker);
    }

    public CountsComputer(long lastCommittedTransactionId, NodeStore nodes, RelationshipStore relationships, int highLabelId, int highRelationshipTypeId, NumberArrayFactory numberArrayFactory, DatabaseLayout databaseLayout, ProgressReporter progressMonitor, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        this.lastCommittedTransactionId = lastCommittedTransactionId;
        this.nodes = nodes;
        this.relationships = relationships;
        this.highLabelId = highLabelId;
        this.highRelationshipTypeId = highRelationshipTypeId;
        this.numberArrayFactory = numberArrayFactory;
        this.databaseLayout = databaseLayout;
        this.progressMonitor = progressMonitor;
        this.pageCacheTracer = pageCacheTracer;
        this.memoryTracker = memoryTracker;
    }

    @Override
    public void initialize(CountsAccessor.Updater countsUpdater, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        if (this.hasNotEmptyNodesOrRelationshipsStores(cursorTracer)) {
            this.progressMonitor.start(this.nodes.getHighestPossibleIdInUse(cursorTracer) + this.relationships.getHighestPossibleIdInUse(cursorTracer));
            this.populateCountStore(countsUpdater);
        }
        this.progressMonitor.completed();
    }

    private boolean hasNotEmptyNodesOrRelationshipsStores(PageCursorTracer cursorTracer) {
        return this.nodes.getHighestPossibleIdInUse(cursorTracer) != -1L || this.relationships.getHighestPossibleIdInUse(cursorTracer) != -1L;
    }

    private void populateCountStore(CountsAccessor.Updater countsUpdater) {
        try (NodeLabelsCache cache = new NodeLabelsCache(this.numberArrayFactory, this.nodes.getHighId(), this.highLabelId, this.memoryTracker);){
            Configuration configuration = Configuration.defaultConfiguration((Path)this.databaseLayout.databaseDirectory());
            ExecutionSupervisors.superviseDynamicExecution(new NodeCountsStage(configuration, cache, this.nodes, this.highLabelId, countsUpdater, this.progressMonitor, this.pageCacheTracer, new StatsProvider[0]));
            ExecutionSupervisors.superviseDynamicExecution(new RelationshipCountsStage(configuration, cache, this.relationships, this.highLabelId, this.highRelationshipTypeId, countsUpdater, this.numberArrayFactory, this.progressMonitor, this.pageCacheTracer, this.memoryTracker));
        }
    }

    @Override
    public long lastCommittedTxId() {
        return this.lastCommittedTransactionId;
    }
}

