/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.HasLabelSubscriber;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.LabelIdArray;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsCompositeAllocator;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.memory.MemoryTracker;

public class DynamicNodeLabels
implements NodeLabels {
    private final NodeRecord node;

    public DynamicNodeLabels(NodeRecord node) {
        this.node = node;
    }

    @Override
    public long[] get(NodeStore nodeStore, PageCursorTracer cursorTracer) {
        return DynamicNodeLabels.get(this.node, nodeStore, cursorTracer);
    }

    public static long[] get(NodeRecord node, NodeStore nodeStore, PageCursorTracer cursorTracer) {
        if (node.isLight()) {
            nodeStore.ensureHeavy(node, NodeLabelsField.firstDynamicLabelRecordId(node.getLabelField()), cursorTracer);
        }
        return DynamicNodeLabels.getDynamicLabelsArray(node.getUsedDynamicLabelRecords(), nodeStore.getDynamicLabelStore(), cursorTracer);
    }

    public static boolean hasLabel(NodeRecord node, NodeStore nodeStore, PageCursorTracer cursorTracer, int label) {
        DynamicArrayStore dynamicLabelStore = nodeStore.getDynamicLabelStore();
        HasLabelSubscriber subscriber = new HasLabelSubscriber(label, dynamicLabelStore, cursorTracer);
        if (node.isLight()) {
            dynamicLabelStore.streamRecords(NodeLabelsField.firstDynamicLabelRecordId(node.getLabelField()), RecordLoad.NORMAL, false, cursorTracer, subscriber);
        } else {
            for (DynamicRecord record : node.getUsedDynamicLabelRecords()) {
                if (!subscriber.onRecord(record)) break;
            }
        }
        return subscriber.hasLabel();
    }

    @Override
    public long[] getIfLoaded() {
        if (this.node.isLight()) {
            return null;
        }
        return LabelIdArray.stripNodeId((long[])DynamicArrayStore.getRightArray(AbstractDynamicStore.readFullByteArrayFromHeavyRecords(this.node.getUsedDynamicLabelRecords(), PropertyType.ARRAY)).asObject());
    }

    @Override
    public Collection<DynamicRecord> put(long[] labelIds, NodeStore nodeStore, DynamicRecordAllocator allocator, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        Arrays.sort(labelIds);
        return DynamicNodeLabels.putSorted(this.node, labelIds, nodeStore, allocator, cursorTracer, memoryTracker);
    }

    static Collection<DynamicRecord> putSorted(NodeRecord node, long[] labelIds, NodeStore nodeStore, DynamicRecordAllocator allocator, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        long existingLabelsField = node.getLabelField();
        long existingLabelsBits = NodeLabelsField.parseLabelsBody(existingLabelsField);
        Collection<DynamicRecord> changedDynamicRecords = node.getDynamicLabelRecords();
        long labelField = node.getLabelField();
        if (NodeLabelsField.fieldPointsToDynamicRecordOfLabels(labelField)) {
            nodeStore.ensureHeavy(node, existingLabelsBits, cursorTracer);
            changedDynamicRecords = node.getDynamicLabelRecords();
            DynamicNodeLabels.setNotInUse(changedDynamicRecords);
        }
        if (!InlineNodeLabels.tryInlineInNodeRecord(node, labelIds, changedDynamicRecords)) {
            Iterator<DynamicRecord> recycledRecords = changedDynamicRecords.iterator();
            Collection<DynamicRecord> allocatedRecords = DynamicNodeLabels.allocateRecordsForDynamicLabels(node.getId(), labelIds, new ReusableRecordsCompositeAllocator(recycledRecords, allocator), cursorTracer, memoryTracker);
            while (recycledRecords.hasNext()) {
                DynamicRecord removedRecord = recycledRecords.next();
                removedRecord.setInUse(false);
                allocatedRecords.add(removedRecord);
            }
            node.setLabelField(DynamicNodeLabels.dynamicPointer(allocatedRecords), allocatedRecords);
            changedDynamicRecords = allocatedRecords;
        }
        return changedDynamicRecords;
    }

    @Override
    public Collection<DynamicRecord> add(long labelId, NodeStore nodeStore, DynamicRecordAllocator allocator, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        nodeStore.ensureHeavy(this.node, NodeLabelsField.firstDynamicLabelRecordId(this.node.getLabelField()), cursorTracer);
        long[] existingLabelIds = DynamicNodeLabels.getDynamicLabelsArray(this.node.getUsedDynamicLabelRecords(), nodeStore.getDynamicLabelStore(), cursorTracer);
        long[] newLabelIds = LabelIdArray.concatAndSort(existingLabelIds, labelId);
        Collection<DynamicRecord> existingRecords = this.node.getDynamicLabelRecords();
        Collection<DynamicRecord> changedDynamicRecords = DynamicNodeLabels.allocateRecordsForDynamicLabels(this.node.getId(), newLabelIds, new ReusableRecordsCompositeAllocator(existingRecords, allocator), cursorTracer, memoryTracker);
        this.node.setLabelField(DynamicNodeLabels.dynamicPointer(changedDynamicRecords), changedDynamicRecords);
        return changedDynamicRecords;
    }

    @Override
    public Collection<DynamicRecord> remove(long labelId, NodeStore nodeStore, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        nodeStore.ensureHeavy(this.node, NodeLabelsField.firstDynamicLabelRecordId(this.node.getLabelField()), cursorTracer);
        long[] existingLabelIds = DynamicNodeLabels.getDynamicLabelsArray(this.node.getUsedDynamicLabelRecords(), nodeStore.getDynamicLabelStore(), cursorTracer);
        long[] newLabelIds = LabelIdArray.filter(existingLabelIds, labelId);
        Collection<DynamicRecord> existingRecords = this.node.getDynamicLabelRecords();
        if (InlineNodeLabels.tryInlineInNodeRecord(this.node, newLabelIds, existingRecords)) {
            DynamicNodeLabels.setNotInUse(existingRecords);
        } else {
            Collection<DynamicRecord> newRecords = DynamicNodeLabels.allocateRecordsForDynamicLabels(this.node.getId(), newLabelIds, new ReusableRecordsCompositeAllocator(existingRecords, (DynamicRecordAllocator)nodeStore.getDynamicLabelStore()), cursorTracer, memoryTracker);
            this.node.setLabelField(DynamicNodeLabels.dynamicPointer(newRecords), existingRecords);
            if (!newRecords.equals(existingRecords)) {
                for (DynamicRecord record : existingRecords) {
                    if (newRecords.contains(record)) continue;
                    record.setInUse(false);
                }
            }
        }
        return existingRecords;
    }

    public long getFirstDynamicRecordId() {
        return NodeLabelsField.firstDynamicLabelRecordId(this.node.getLabelField());
    }

    public static long dynamicPointer(Collection<DynamicRecord> newRecords) {
        return DynamicNodeLabels.dynamicPointer(((DynamicRecord)Iterables.first(newRecords)).getId());
    }

    public static long dynamicPointer(long dynamicRecordId) {
        return 0x8000000000L | dynamicRecordId;
    }

    private static void setNotInUse(Collection<DynamicRecord> changedDynamicRecords) {
        for (DynamicRecord record : changedDynamicRecords) {
            record.setInUse(false);
        }
    }

    @Override
    public boolean isInlined() {
        return false;
    }

    public String toString() {
        if (this.node.isLight()) {
            return String.format("Dynamic(id:%d)", NodeLabelsField.firstDynamicLabelRecordId(this.node.getLabelField()));
        }
        return String.format("Dynamic(id:%d,[%s])", NodeLabelsField.firstDynamicLabelRecordId(this.node.getLabelField()), Arrays.toString(DynamicNodeLabels.getDynamicLabelsArrayFromHeavyRecords(this.node.getUsedDynamicLabelRecords())));
    }

    public static Collection<DynamicRecord> allocateRecordsForDynamicLabels(long nodeId, long[] labels, AbstractDynamicStore dynamicLabelStore, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        return DynamicNodeLabels.allocateRecordsForDynamicLabels(nodeId, labels, (DynamicRecordAllocator)dynamicLabelStore, cursorTracer, memoryTracker);
    }

    public static Collection<DynamicRecord> allocateRecordsForDynamicLabels(long nodeId, long[] labels, DynamicRecordAllocator allocator, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        long[] storedLongs = LabelIdArray.prependNodeId(nodeId, labels);
        ArrayList<DynamicRecord> records = new ArrayList<DynamicRecord>();
        DynamicArrayStore.allocateRecords(records, storedLongs, allocator, false, cursorTracer, memoryTracker);
        return records;
    }

    public static long[] getDynamicLabelsArray(Iterable<DynamicRecord> records, AbstractDynamicStore dynamicLabelStore, PageCursorTracer cursorTracer) {
        long[] storedLongs = (long[])DynamicArrayStore.getRightArray(dynamicLabelStore.readFullByteArray(records, PropertyType.ARRAY, cursorTracer)).asObject();
        return LabelIdArray.stripNodeId(storedLongs);
    }

    public static long[] getDynamicLabelsArrayFromHeavyRecords(Iterable<DynamicRecord> records) {
        long[] storedLongs = (long[])DynamicArrayStore.getRightArray(AbstractDynamicStore.readFullByteArrayFromHeavyRecords(records, PropertyType.ARRAY)).asObject();
        return LabelIdArray.stripNodeId(storedLongs);
    }

    public static Pair<Long, long[]> getDynamicLabelsArrayAndOwner(Iterable<DynamicRecord> records, AbstractDynamicStore dynamicLabelStore, PageCursorTracer cursorTracer) {
        long[] storedLongs = (long[])DynamicArrayStore.getRightArray(dynamicLabelStore.readFullByteArray(records, PropertyType.ARRAY, cursorTracer)).asObject();
        return Pair.of((Object)storedLongs[0], (Object)LabelIdArray.stripNodeId(storedLongs));
    }
}

