/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.RecordSubscriber;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.util.Bits;

class HasLabelSubscriber
implements RecordSubscriber<DynamicRecord> {
    private int requiredBits;
    private int remainingBits;
    private Bits bits;
    private boolean firstRecord = true;
    private boolean found;
    private final int label;
    private final DynamicArrayStore labelStore;
    private final PageCursorTracer cursorTracer;
    private int bitsUsedInLastByte;

    HasLabelSubscriber(int label, DynamicArrayStore labelStore, PageCursorTracer cursorTracer) {
        this.label = label;
        this.labelStore = labelStore;
        this.cursorTracer = cursorTracer;
    }

    boolean hasLabel() {
        return this.found;
    }

    @Override
    public boolean onRecord(DynamicRecord record) {
        if (!record.inUse()) {
            return true;
        }
        this.labelStore.ensureHeavy(record, this.cursorTracer);
        boolean lastRecord = Record.NO_NEXT_BLOCK.is(record.getNextBlock());
        if (this.firstRecord) {
            this.firstRecord = false;
            return this.processFirstRecord(record.getData(), lastRecord);
        }
        return this.processRecord(record.getData(), lastRecord);
    }

    private boolean processFirstRecord(byte[] data, boolean lastRecord) {
        assert (ShortArray.typeOf(data[0]) == ShortArray.LONG);
        this.bitsUsedInLastByte = data[1];
        this.requiredBits = data[2];
        this.bits = Bits.bitsFromBytes((byte[])data, (int)3);
        int numberOfUsedBitsInRecord = this.numberOfUsedBitsInRecord((data.length - 3) * 8, lastRecord);
        int numberOfCompleteLabels = numberOfUsedBitsInRecord / this.requiredBits;
        this.remainingBits = numberOfUsedBitsInRecord - numberOfCompleteLabels * this.requiredBits;
        return this.findLabel(numberOfCompleteLabels, true);
    }

    private boolean processRecord(byte[] data, boolean lastRecord) {
        int numberOfBitsInRecord = this.remainingBits + data.length * 8;
        int numberOfUsedBitsInRecord = this.numberOfUsedBitsInRecord(numberOfBitsInRecord, lastRecord);
        int numberOfCompleteLabels = numberOfUsedBitsInRecord / this.requiredBits;
        this.computeBits(data, numberOfBitsInRecord, numberOfCompleteLabels);
        return this.findLabel(numberOfCompleteLabels, false);
    }

    private int numberOfUsedBitsInRecord(int numberOfBitsInRecord, boolean lastRecord) {
        int bitsUsedInLastByteInThisRecord = lastRecord ? this.bitsUsedInLastByte : 8;
        return numberOfBitsInRecord - (8 - bitsUsedInLastByteInThisRecord);
    }

    private void computeBits(byte[] data, int totalNumberOfBits, int numberOfCompleteLabels) {
        if (this.remainingBits > 0) {
            Bits newBits = Bits.bits((int)((int)Math.ceil((double)(totalNumberOfBits + this.remainingBits) / 8.0)));
            newBits.put(this.bits.getLong(this.remainingBits), this.remainingBits);
            newBits.put(data, 0, data.length);
            this.bits = newBits;
        } else {
            this.bits = Bits.bitsFromBytes((byte[])data);
        }
        this.remainingBits = totalNumberOfBits - numberOfCompleteLabels * this.requiredBits;
    }

    private boolean findLabel(int numberOfCompleteLabels, boolean skipFirst) {
        for (int i = 0; i < numberOfCompleteLabels; ++i) {
            long foundLabel = this.bits.getLong(this.requiredBits);
            if (skipFirst && i == 0 || foundLabel != (long)this.label) continue;
            this.found = true;
            return false;
        }
        return true;
    }
}

