/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public interface IdUpdateListener
extends AutoCloseable {
    public static final IdUpdateListener DIRECT = new IdUpdateListener(){

        @Override
        public void close() {
        }

        @Override
        public void markIdAsUsed(IdType idType, IdGenerator idGenerator, long id, PageCursorTracer cursorTracer) {
            try (IdGenerator.Marker marker = idGenerator.marker(cursorTracer);){
                marker.markUsed(id);
            }
        }

        @Override
        public void markIdAsUnused(IdType idType, IdGenerator idGenerator, long id, PageCursorTracer cursorTracer) {
            try (IdGenerator.Marker marker = idGenerator.marker(cursorTracer);){
                marker.markDeleted(id);
            }
        }
    };
    public static final IdUpdateListener IGNORE = new IdUpdateListener(){

        @Override
        public void close() {
        }

        @Override
        public void markIdAsUsed(IdType idType, IdGenerator idGenerator, long id, PageCursorTracer cursorTracer) {
        }

        @Override
        public void markIdAsUnused(IdType idType, IdGenerator idGenerator, long id, PageCursorTracer cursorTracer) {
        }
    };

    public void markIdAsUsed(IdType var1, IdGenerator var2, long var3, PageCursorTracer var5);

    public void markIdAsUnused(IdType var1, IdGenerator var2, long var3, PageCursorTracer var5);
}

