/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.HighestTransactionId;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFileClosedException;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.standard.MetaDataRecordFormat;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.util.Bits;
import org.neo4j.util.concurrent.ArrayQueueOutOfOrderSequence;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public class MetaDataStore
extends CommonAbstractStore<MetaDataRecord, NoStoreHeader>
implements MetadataProvider {
    public static final String TYPE_DESCRIPTOR = "NeoStore";
    public static final long FIELD_NOT_INITIALIZED = Long.MIN_VALUE;
    private static final String METADATA_REFRESH_TAG = "metadataRefresh";
    private static final UUID NOT_INITIALISED_EXTERNAL_STORE_UUID = new UUID(Long.MIN_VALUE, Long.MIN_VALUE);
    private volatile long creationTimeField = Long.MIN_VALUE;
    private volatile long randomNumberField = Long.MIN_VALUE;
    private volatile long versionField = Long.MIN_VALUE;
    private volatile long checkpointLogVersionField = Long.MIN_VALUE;
    private final AtomicLong lastCommittingTxField = new AtomicLong(Long.MIN_VALUE);
    private volatile long storeVersionField = Long.MIN_VALUE;
    private volatile long latestConstraintIntroducingTxField = Long.MIN_VALUE;
    private volatile long upgradeTxIdField = Long.MIN_VALUE;
    private volatile int upgradeTxChecksumField = 0;
    private volatile long upgradeTimeField = Long.MIN_VALUE;
    private volatile long upgradeCommitTimestampField = Long.MIN_VALUE;
    private volatile UUID externalStoreUUID = NOT_INITIALISED_EXTERNAL_STORE_UUID;
    private final PageCacheTracer pageCacheTracer;
    private volatile TransactionId upgradeTransaction = new TransactionId(Long.MIN_VALUE, 0, Long.MIN_VALUE);
    private final HighestTransactionId highestCommittedTransaction = new HighestTransactionId(Long.MIN_VALUE, 0, Long.MIN_VALUE);
    private final OutOfOrderSequence lastClosedTx = new ArrayQueueOutOfOrderSequence(-1L, 200, new long[2]);
    private final Object upgradeTimeLock = new Object();
    private final Object creationTimeLock = new Object();
    private final Object randomNumberLock = new Object();
    private final Object upgradeTransactionLock = new Object();
    private final Object logVersionLock = new Object();
    private final Object checkpointLogVersionLock = new Object();
    private final Object storeVersionLock = new Object();
    private final Object lastConstraintIntroducingTxLock = new Object();
    private final Object transactionCommittedLock = new Object();
    private final Object transactionClosedLock = new Object();
    private volatile boolean closed;

    MetaDataStore(Path file, Path idFile, Config conf, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, RecordFormat<MetaDataRecord> recordFormat, String storeVersion, PageCacheTracer pageCacheTracer, ImmutableSet<OpenOption> openOptions) {
        super(file, idFile, conf, IdType.NEOSTORE_BLOCK, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, recordFormat, NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, storeVersion, openOptions);
        this.pageCacheTracer = pageCacheTracer;
    }

    @Override
    protected void initialiseNewStoreFile(PageCursorTracer cursorTracer) throws IOException {
        super.initialiseNewStoreFile(cursorTracer);
        long storeVersionAsLong = MetaDataStore.versionStringToLong(this.storeVersion);
        StoreId storeId = new StoreId(storeVersionAsLong);
        this.setCreationTime(storeId.getCreationTime(), cursorTracer);
        this.setRandomNumber(storeId.getRandomId(), cursorTracer);
        this.setUpgradeTime(storeId.getCreationTime(), cursorTracer);
        this.setUpgradeTransaction(1L, -559063315, 0L, cursorTracer);
        this.setCurrentLogVersion(0L, cursorTracer);
        this.setLastCommittedAndClosedTransactionId(1L, -559063315, 0L, 64L, 0L, cursorTracer);
        this.setStoreVersion(storeVersionAsLong, cursorTracer);
        this.setLatestConstraintIntroducingTx(0L, cursorTracer);
        this.setExternalStoreUUID(UUID.randomUUID(), cursorTracer);
        this.setCheckpointLogVersion(0L, cursorTracer);
        this.initHighId();
        this.flush(cursorTracer);
    }

    public long getCheckpointLogVersion() {
        this.assertNotClosed();
        this.checkInitialized(this.checkpointLogVersionField);
        return this.checkpointLogVersionField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckpointLogVersion(long version, PageCursorTracer cursorTracer) {
        Object object = this.checkpointLogVersionLock;
        synchronized (object) {
            this.setRecord(Position.CHECKPOINT_LOG_VERSION, version, cursorTracer);
            this.checkpointLogVersionField = version;
        }
    }

    public long incrementAndGetCheckpointLogVersion(PageCursorTracer cursorTracer) {
        long checkPointVersion;
        this.checkpointLogVersionField = checkPointVersion = this.incrementAndGetVersion(cursorTracer, this.checkpointLogVersionLock, Position.CHECKPOINT_LOG_VERSION);
        return checkPointVersion;
    }

    private void setExternalStoreUUID(UUID uuid, PageCursorTracer cursorTracer) {
        this.assertNotClosed();
        this.setRecord(Position.EXTERNAL_STORE_UUID_MOST_SIGN_BITS, uuid.getMostSignificantBits(), cursorTracer);
        this.setRecord(Position.EXTERNAL_STORE_UUID_LEAST_SIGN_BITS, uuid.getLeastSignificantBits(), cursorTracer);
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, int checksum, long commitTimestamp, long byteOffset, long logVersion, PageCursorTracer cursorTracer) {
        this.assertNotClosed();
        this.setRecord(Position.LAST_TRANSACTION_ID, transactionId, cursorTracer);
        this.setRecord(Position.LAST_TRANSACTION_CHECKSUM, checksum, cursorTracer);
        this.setRecord(Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, logVersion, cursorTracer);
        this.setRecord(Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, byteOffset, cursorTracer);
        this.setRecord(Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, commitTimestamp, cursorTracer);
        this.checkInitialized(this.lastCommittingTxField.get());
        this.lastCommittingTxField.set(transactionId);
        this.lastClosedTx.set(transactionId, new long[]{logVersion, byteOffset});
        this.highestCommittedTransaction.set(transactionId, checksum, commitTimestamp);
    }

    public static long setRecord(PageCache pageCache, Path neoStore, Position position, long value, PageCursorTracer cursorTracer) throws IOException {
        long previousValue = Long.MIN_VALUE;
        int pageSize = pageCache.pageSize();
        try (PagedFile pagedFile = pageCache.map(neoStore, EmptyVersionContextSupplier.EMPTY, pageSize, Sets.immutable.empty());){
            int offset = MetaDataStore.offset(position);
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorTracer);){
                if (cursor.next()) {
                    cursor.setOffset(offset);
                    byte inUse = cursor.getByte();
                    long record = cursor.getLong();
                    if (inUse == Record.IN_USE.byteValue()) {
                        previousValue = record;
                    }
                    cursor.setOffset(offset);
                    cursor.putByte(Record.IN_USE.byteValue());
                    cursor.putLong(value);
                    if (cursor.checkAndClearBoundsFlag()) {
                        MetaDataRecord neoStoreRecord = new MetaDataRecord();
                        neoStoreRecord.setId(position.id);
                        throw new UnderlyingStorageException(MetaDataStore.buildOutOfBoundsExceptionMessage(neoStoreRecord, 0L, offset, 9, pageSize, neoStore.toAbsolutePath().toString()));
                    }
                }
            }
        }
        return previousValue;
    }

    private void initHighId() {
        Position[] values = Position.values();
        long highestPossibleId = values[values.length - 1].id;
        this.setHighestPossibleIdInUse(highestPossibleId);
    }

    private static int offset(Position position) {
        return 9 * position.id;
    }

    public static long getRecord(PageCache pageCache, Path neoStore, Position position, PageCursorTracer cursorTracer) throws IOException {
        long value;
        block15: {
            MetaDataRecordFormat recordFormat = new MetaDataRecordFormat();
            int pageSize = pageCache.pageSize();
            value = -1L;
            try (PagedFile pagedFile = pageCache.map(neoStore, EmptyVersionContextSupplier.EMPTY, pageSize, Sets.immutable.empty());){
                if (pagedFile.getLastPageId() < 0L) break block15;
                try (PageCursor cursor = pagedFile.io(0L, 1, cursorTracer);){
                    if (cursor.next()) {
                        MetaDataRecord record = new MetaDataRecord();
                        record.setId(position.id);
                        do {
                            recordFormat.read(record, cursor, RecordLoad.CHECK, 9, pageSize / 9);
                            value = record.inUse() ? record.getValue() : -1L;
                        } while (cursor.shouldRetry());
                        if (cursor.checkAndClearBoundsFlag()) {
                            int offset = MetaDataStore.offset(position);
                            throw new UnderlyingStorageException(MetaDataStore.buildOutOfBoundsExceptionMessage(record, 0L, offset, 9, pageSize, neoStore.toAbsolutePath().toString()));
                        }
                    }
                }
            }
        }
        return value;
    }

    public static void setStoreId(PageCache pageCache, Path neoStore, StoreId storeId, long upgradeTxChecksum, long upgradeTxCommitTimestamp, PageCursorTracer cursorTracer) throws IOException {
        MetaDataStore.setRecord(pageCache, neoStore, Position.TIME, storeId.getCreationTime(), cursorTracer);
        MetaDataStore.setRecord(pageCache, neoStore, Position.RANDOM_NUMBER, storeId.getRandomId(), cursorTracer);
        MetaDataStore.setRecord(pageCache, neoStore, Position.STORE_VERSION, storeId.getStoreVersion(), cursorTracer);
        MetaDataStore.setRecord(pageCache, neoStore, Position.UPGRADE_TIME, storeId.getUpgradeTime(), cursorTracer);
        MetaDataStore.setRecord(pageCache, neoStore, Position.UPGRADE_TRANSACTION_ID, storeId.getUpgradeTxId(), cursorTracer);
        MetaDataStore.setRecord(pageCache, neoStore, Position.UPGRADE_TRANSACTION_CHECKSUM, upgradeTxChecksum, cursorTracer);
        MetaDataStore.setRecord(pageCache, neoStore, Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, upgradeTxCommitTimestamp, cursorTracer);
    }

    public static void setExternalStoreUUID(PageCache pageCache, Path neoStore, UUID externalStoreId, PageCursorTracer cursorTracer) throws IOException {
        MetaDataStore.setRecord(pageCache, neoStore, Position.EXTERNAL_STORE_UUID_MOST_SIGN_BITS, externalStoreId.getMostSignificantBits(), cursorTracer);
        MetaDataStore.setRecord(pageCache, neoStore, Position.EXTERNAL_STORE_UUID_LEAST_SIGN_BITS, externalStoreId.getLeastSignificantBits(), cursorTracer);
    }

    public StoreId getStoreId() {
        return new StoreId(this.getCreationTime(), this.getRandomNumber(), this.getStoreVersion(), this.getUpgradeTime(), this.upgradeTxIdField);
    }

    public Optional<ExternalStoreId> getExternalStoreId() {
        this.assertNotClosed();
        UUID externalStoreUUID = this.getExternalStoreUUID();
        return this.isNotInitialisedExternalUUID(externalStoreUUID) ? Optional.empty() : Optional.of(new ExternalStoreId(externalStoreUUID));
    }

    public static StoreId getStoreId(PageCache pageCache, Path neoStore, PageCursorTracer cursorTracer) throws IOException {
        return new StoreId(MetaDataStore.getRecord(pageCache, neoStore, Position.TIME, cursorTracer), MetaDataStore.getRecord(pageCache, neoStore, Position.RANDOM_NUMBER, cursorTracer), MetaDataStore.getRecord(pageCache, neoStore, Position.STORE_VERSION, cursorTracer), MetaDataStore.getRecord(pageCache, neoStore, Position.UPGRADE_TIME, cursorTracer), MetaDataStore.getRecord(pageCache, neoStore, Position.UPGRADE_TRANSACTION_ID, cursorTracer));
    }

    public long getUpgradeTime() {
        this.assertNotClosed();
        this.checkInitialized(this.upgradeTimeField);
        return this.upgradeTimeField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpgradeTime(long time, PageCursorTracer cursorTracer) {
        Object object = this.upgradeTimeLock;
        synchronized (object) {
            this.setRecord(Position.UPGRADE_TIME, time, cursorTracer);
            this.upgradeTimeField = time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpgradeTransaction(long id, int checksum, long timestamp, PageCursorTracer cursorTracer) {
        long pageId = this.pageIdForRecord(Position.UPGRADE_TRANSACTION_ID.id);
        assert (pageId == this.pageIdForRecord(Position.UPGRADE_TRANSACTION_CHECKSUM.id));
        Object object = this.upgradeTransactionLock;
        synchronized (object) {
            try (PageCursor cursor = this.pagedFile.io(pageId, 2, cursorTracer);){
                if (!cursor.next()) {
                    throw new UnderlyingStorageException("Could not access MetaDataStore page " + pageId);
                }
                this.setRecord(cursor, Position.UPGRADE_TRANSACTION_ID, id);
                this.setRecord(cursor, Position.UPGRADE_TRANSACTION_CHECKSUM, checksum);
                this.setRecord(cursor, Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, timestamp);
                this.upgradeTxIdField = id;
                this.upgradeTxChecksumField = checksum;
                this.upgradeCommitTimestampField = timestamp;
                this.upgradeTransaction = new TransactionId(id, checksum, timestamp);
            }
            catch (IOException e) {
                throw new UnderlyingStorageException((Throwable)e);
            }
        }
    }

    private UUID getExternalStoreUUID() {
        this.assertNotClosed();
        if (this.isNotInitialisedExternalUUID(this.externalStoreUUID)) {
            this.refreshFields();
        }
        return this.externalStoreUUID;
    }

    private boolean isNotInitialisedExternalUUID(UUID uuid) {
        return NOT_INITIALISED_EXTERNAL_STORE_UUID.equals(uuid);
    }

    public long getCreationTime() {
        this.assertNotClosed();
        this.checkInitialized(this.creationTimeField);
        return this.creationTimeField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCreationTime(long time, PageCursorTracer cursorTracer) {
        Object object = this.creationTimeLock;
        synchronized (object) {
            this.setRecord(Position.TIME, time, cursorTracer);
            this.creationTimeField = time;
        }
    }

    public long getRandomNumber() {
        this.assertNotClosed();
        this.checkInitialized(this.randomNumberField);
        return this.randomNumberField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRandomNumber(long random, PageCursorTracer cursorTracer) {
        Object object = this.randomNumberLock;
        synchronized (object) {
            this.setRecord(Position.RANDOM_NUMBER, random, cursorTracer);
            this.randomNumberField = random;
        }
    }

    public long getCurrentLogVersion() {
        this.assertNotClosed();
        this.checkInitialized(this.versionField);
        return this.versionField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentLogVersion(long version, PageCursorTracer cursorTracer) {
        Object object = this.logVersionLock;
        synchronized (object) {
            this.setRecord(Position.LOG_VERSION, version, cursorTracer);
            this.versionField = version;
        }
    }

    public long incrementAndGetVersion(PageCursorTracer cursorTracer) {
        long version;
        this.versionField = version = this.incrementAndGetVersion(cursorTracer, this.logVersionLock, Position.LOG_VERSION);
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incrementAndGetVersion(PageCursorTracer cursorTracer, Object lock, Position position) {
        long version;
        long pageId = this.pageIdForRecord(position.id);
        Object object = lock;
        synchronized (object) {
            block12: {
                try (PageCursor cursor = this.pagedFile.io(pageId, 2, cursorTracer);){
                    if (cursor.next()) {
                        version = this.incrementVersion(cursor, position);
                        break block12;
                    }
                    throw new IllegalStateException("Filed " + position + "missing in metadata store. Page " + pageId + "not found.");
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException((Throwable)e);
                }
            }
        }
        this.flush(cursorTracer);
        return version;
    }

    private long incrementVersion(PageCursor cursor, Position position) {
        if (!cursor.isWriteLocked()) {
            throw new IllegalArgumentException("Cannot increment log version on page cursor that is not write-locked");
        }
        int offset = position.id * this.getRecordSize() + 1;
        long value = cursor.getLong(offset) + 1L;
        cursor.putLong(offset, value);
        this.checkForDecodingErrors(cursor, position.id, RecordLoad.NORMAL);
        return value;
    }

    public long getStoreVersion() {
        this.assertNotClosed();
        this.checkInitialized(this.storeVersionField);
        return this.storeVersionField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoreVersion(long version, PageCursorTracer cursorTracer) {
        Object object = this.storeVersionLock;
        synchronized (object) {
            this.setRecord(Position.STORE_VERSION, version, cursorTracer);
            this.storeVersionField = version;
        }
    }

    public long getLatestConstraintIntroducingTx() {
        this.assertNotClosed();
        this.checkInitialized(this.latestConstraintIntroducingTxField);
        return this.latestConstraintIntroducingTxField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLatestConstraintIntroducingTx(long latestConstraintIntroducingTx, PageCursorTracer cursorTracer) {
        Object object = this.lastConstraintIntroducingTxLock;
        synchronized (object) {
            this.setRecord(Position.LAST_CONSTRAINT_TRANSACTION, latestConstraintIntroducingTx, cursorTracer);
            this.latestConstraintIntroducingTxField = latestConstraintIntroducingTx;
        }
    }

    private void readAllFields(PageCursor cursor) throws IOException {
        do {
            this.creationTimeField = this.getRecordValue(cursor, Position.TIME);
            this.randomNumberField = this.getRecordValue(cursor, Position.RANDOM_NUMBER);
            this.versionField = this.getRecordValue(cursor, Position.LOG_VERSION);
            long lastCommittedTxId = this.getRecordValue(cursor, Position.LAST_TRANSACTION_ID);
            this.lastCommittingTxField.set(lastCommittedTxId);
            this.storeVersionField = this.getRecordValue(cursor, Position.STORE_VERSION);
            this.getRecordValue(cursor, Position.FIRST_GRAPH_PROPERTY);
            this.latestConstraintIntroducingTxField = this.getRecordValue(cursor, Position.LAST_CONSTRAINT_TRANSACTION);
            this.upgradeTxIdField = this.getRecordValue(cursor, Position.UPGRADE_TRANSACTION_ID);
            this.upgradeTxChecksumField = (int)this.getRecordValue(cursor, Position.UPGRADE_TRANSACTION_CHECKSUM);
            this.upgradeTimeField = this.getRecordValue(cursor, Position.UPGRADE_TIME);
            long lastClosedTransactionLogVersion = this.getRecordValue(cursor, Position.LAST_CLOSED_TRANSACTION_LOG_VERSION);
            long lastClosedTransactionLogByteOffset = this.getRecordValue(cursor, Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET);
            this.lastClosedTx.set(lastCommittedTxId, new long[]{lastClosedTransactionLogVersion, lastClosedTransactionLogByteOffset});
            this.highestCommittedTransaction.set(lastCommittedTxId, (int)this.getRecordValue(cursor, Position.LAST_TRANSACTION_CHECKSUM), this.getRecordValue(cursor, Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, 1L));
            this.upgradeCommitTimestampField = this.getRecordValue(cursor, Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, 0L);
            this.externalStoreUUID = this.readExternalStoreUUID(cursor);
            this.upgradeTransaction = new TransactionId(this.upgradeTxIdField, this.upgradeTxChecksumField, this.upgradeCommitTimestampField);
            this.checkpointLogVersionField = this.getRecordValue(cursor, Position.CHECKPOINT_LOG_VERSION, 0L);
        } while (cursor.shouldRetry());
        if (cursor.checkAndClearBoundsFlag()) {
            throw new UnderlyingStorageException("Out of page bounds when reading all meta-data fields. The page in question is page " + cursor.getCurrentPageId() + " of file " + this.storageFile.toAbsolutePath() + ", which is " + cursor.getCurrentPageSize() + " bytes in size");
        }
    }

    private UUID readExternalStoreUUID(PageCursor cursor) {
        long mostSignificantBits = this.getRecordValue(cursor, Position.EXTERNAL_STORE_UUID_MOST_SIGN_BITS, Long.MIN_VALUE);
        long leastSignificantBits = this.getRecordValue(cursor, Position.EXTERNAL_STORE_UUID_LEAST_SIGN_BITS, Long.MIN_VALUE);
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    long getRecordValue(PageCursor cursor, Position position) {
        return this.getRecordValue(cursor, position, -1L);
    }

    private long getRecordValue(PageCursor cursor, Position position, long defaultValue) {
        MetaDataRecord record = this.newRecord();
        try {
            record.setId(position.id);
            this.recordFormat.read(record, cursor, RecordLoad.ALWAYS, 9, this.getRecordsPerPage());
            if (record.inUse()) {
                return record.getValue();
            }
            return defaultValue;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    private void refreshFields() {
        this.scanAllFields(1, (Visitor<PageCursor, IOException>)((Visitor)element -> {
            this.readAllFields((PageCursor)element);
            return false;
        }));
    }

    private void scanAllFields(int pf_flags, Visitor<PageCursor, IOException> visitor) {
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer(METADATA_REFRESH_TAG);
             PageCursor cursor = this.pagedFile.io(0L, pf_flags, cursorTracer);){
            if (cursor.next()) {
                visitor.visit((Object)cursor);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    private void setRecord(Position position, long value, PageCursorTracer cursorTracer) {
        MetaDataRecord record = new MetaDataRecord();
        record.initialize(true, value);
        record.setId(position.id);
        this.updateRecord(record, cursorTracer);
    }

    private void setRecord(PageCursor cursor, Position position, long value) {
        if (!cursor.isWriteLocked()) {
            throw new IllegalArgumentException("Cannot write record without a page cursor that is write-locked");
        }
        int offset = this.offsetForId(position.id);
        cursor.setOffset(offset);
        cursor.putByte(Record.IN_USE.byteValue());
        cursor.putLong(value);
        this.checkForDecodingErrors(cursor, position.id, RecordLoad.NORMAL);
    }

    public static long versionStringToLong(String storeVersion) {
        if ("Unknown".equals(storeVersion)) {
            return -1L;
        }
        Bits bits = Bits.bits((int)8);
        int length = storeVersion.length();
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format("The given string %s is not of proper size for a store version string", storeVersion));
        }
        bits.put(length, 8);
        for (int i = 0; i < length; ++i) {
            char c = storeVersion.charAt(i);
            if (c >= '\u0100') {
                throw new IllegalArgumentException(String.format("Store version strings should be encode-able as Latin1 - %s is not", storeVersion));
            }
            bits.put((int)c, 8);
        }
        return bits.getLong();
    }

    public static String versionLongToString(long storeVersion) {
        if (storeVersion == -1L) {
            return "Unknown";
        }
        Bits bits = Bits.bitsFromLongs((long[])new long[]{storeVersion});
        int length = bits.getShort(8);
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format("The read version string length %d is not proper.", length));
        }
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (char)bits.getShort(8);
        }
        return new String(result);
    }

    public long nextCommittingTransactionId() {
        this.assertNotClosed();
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.lastCommittingTxField.incrementAndGet();
    }

    public long committingTransactionId() {
        this.assertNotClosed();
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.lastCommittingTxField.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionCommitted(long transactionId, int checksum, long commitTimestamp, PageCursorTracer cursorTracer) {
        this.assertNotClosed();
        this.checkInitialized(this.lastCommittingTxField.get());
        if (this.highestCommittedTransaction.offer(transactionId, checksum, commitTimestamp)) {
            Object object = this.transactionCommittedLock;
            synchronized (object) {
                if (this.highestCommittedTransaction.get().transactionId() == transactionId) {
                    long pageId = this.pageIdForRecord(Position.LAST_TRANSACTION_ID.id);
                    assert (pageId == this.pageIdForRecord(Position.LAST_TRANSACTION_CHECKSUM.id));
                    try (PageCursor cursor = this.pagedFile.io(pageId, 2, cursorTracer);){
                        if (cursor.next()) {
                            this.setRecord(cursor, Position.LAST_TRANSACTION_ID, transactionId);
                            this.setRecord(cursor, Position.LAST_TRANSACTION_CHECKSUM, checksum);
                            this.setRecord(cursor, Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, commitTimestamp);
                        }
                    }
                    catch (IOException e) {
                        throw new UnderlyingStorageException((Throwable)e);
                    }
                }
            }
        }
    }

    public long getLastCommittedTransactionId() {
        this.assertNotClosed();
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.highestCommittedTransaction.get().transactionId();
    }

    public TransactionId getLastCommittedTransaction() {
        this.assertNotClosed();
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.highestCommittedTransaction.get();
    }

    public TransactionId getUpgradeTransaction() {
        this.assertNotClosed();
        this.checkInitialized(this.upgradeTxIdField);
        return this.upgradeTransaction;
    }

    public long getLastClosedTransactionId() {
        this.assertNotClosed();
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.lastClosedTx.getHighestGapFreeNumber();
    }

    public long[] getLastClosedTransaction() {
        this.assertNotClosed();
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.lastClosedTx.get();
    }

    private void checkInitialized(long field) {
        if (field == Long.MIN_VALUE) {
            this.refreshFields();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionClosed(long transactionId, long logVersion, long byteOffset, PageCursorTracer cursorTracer) {
        if (this.lastClosedTx.offer(transactionId, new long[]{logVersion, byteOffset})) {
            long pageId = this.pageIdForRecord(Position.LAST_CLOSED_TRANSACTION_LOG_VERSION.id);
            assert (pageId == this.pageIdForRecord(Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET.id));
            Object object = this.transactionClosedLock;
            synchronized (object) {
                try (PageCursor cursor = this.pagedFile.io(pageId, 2, cursorTracer);){
                    if (cursor.next()) {
                        long[] lastClosedTransactionData = this.lastClosedTx.get();
                        this.setRecord(cursor, Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, lastClosedTransactionData[1]);
                        this.setRecord(cursor, Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, lastClosedTransactionData[2]);
                    }
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException((Throwable)e);
                }
            }
        }
    }

    public void resetLastClosedTransaction(long transactionId, long logVersion, long byteOffset, boolean missingLogs, PageCursorTracer cursorTracer) {
        this.assertNotClosed();
        this.setRecord(Position.LAST_TRANSACTION_ID, transactionId, cursorTracer);
        this.setRecord(Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, logVersion, cursorTracer);
        this.setRecord(Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, byteOffset, cursorTracer);
        if (missingLogs) {
            this.setRecord(Position.LAST_MISSING_STORE_FILES_RECOVERY_TIMESTAMP, System.currentTimeMillis(), cursorTracer);
        }
        this.lastClosedTx.set(transactionId, new long[]{logVersion, byteOffset});
    }

    public void logRecords(DiagnosticsLogger logger) {
        this.scanAllFields(1, (Visitor<PageCursor, IOException>)((Visitor)cursor -> {
            for (Position position : Position.values()) {
                long value;
                do {
                    value = this.getRecordValue((PageCursor)cursor, position);
                } while (cursor.shouldRetry());
                boolean bounds = cursor.checkAndClearBoundsFlag();
                logger.log(position.name() + " (" + position.description() + "): " + value + (bounds ? " (out-of-bounds detected; value cannot be trusted)" : ""));
            }
            return false;
        }));
    }

    @Override
    public MetaDataRecord newRecord() {
        return new MetaDataRecord();
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, MetaDataRecord record, PageCursorTracer cursorTracer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void prepareForCommit(MetaDataRecord record, PageCursorTracer cursorTracer) {
    }

    @Override
    public void prepareForCommit(MetaDataRecord record, IdSequence idSequence, PageCursorTracer cursorTracer) {
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.closed = true;
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new StoreFileClosedException(this, this.storageFile);
        }
    }

    public static enum Position {
        TIME(0, "Creation time"),
        RANDOM_NUMBER(1, "Random number for store id"),
        LOG_VERSION(2, "Current log version"),
        LAST_TRANSACTION_ID(3, "Last committed transaction"),
        STORE_VERSION(4, "Store format version"),
        FIRST_GRAPH_PROPERTY(5, "First property record containing graph properties"),
        LAST_CONSTRAINT_TRANSACTION(6, "Last committed transaction containing constraint changes"),
        UPGRADE_TRANSACTION_ID(7, "Transaction id most recent upgrade was performed at"),
        UPGRADE_TIME(8, "Time of last upgrade"),
        LAST_TRANSACTION_CHECKSUM(9, "Checksum of last committed transaction"),
        UPGRADE_TRANSACTION_CHECKSUM(10, "Checksum of transaction id the most recent upgrade was performed at"),
        LAST_CLOSED_TRANSACTION_LOG_VERSION(11, "Log version where the last transaction commit entry has been written into"),
        LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET(12, "Byte offset in the log file where the last transaction commit entry has been written into"),
        LAST_TRANSACTION_COMMIT_TIMESTAMP(13, "Commit time timestamp for last committed transaction"),
        UPGRADE_TRANSACTION_COMMIT_TIMESTAMP(14, "Commit timestamp of transaction the most recent upgrade was performed at"),
        LAST_MISSING_STORE_FILES_RECOVERY_TIMESTAMP(15, "Timestamp of last attempt to perform a recovery on the store with missing files."),
        EXTERNAL_STORE_UUID_MOST_SIGN_BITS(16, "Database identifier exposed as external store identity. Generated on creation and never updated. Most significant bits."),
        EXTERNAL_STORE_UUID_LEAST_SIGN_BITS(17, "Database identifier exposed as external store identity. Generated on creation and never updated. Least significant bits"),
        CHECKPOINT_LOG_VERSION(18, "Current checkpoint log version");

        private final int id;
        private final String description;

        private Position(int id, String description) {
            this.id = id;
            this.description = description;
        }

        public int id() {
            return this.id;
        }

        public String description() {
            return this.description;
        }
    }
}

