/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.UnexpectedStoreVersionException;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.format.CapabilityType;

public class NeoStores
implements AutoCloseable {
    private static final String ID_USAGE_LOGGER_TAG = "idUsageLogger";
    private static final String STORE_ALREADY_CLOSED_MESSAGE = "Specified store was already closed.";
    private static final String STORE_NOT_INITIALIZED_TEMPLATE = "Specified store was not initialized. Please specify %s as one of the stores types that should be open to be able to use it.";
    private static final String OPEN_ALL_STORES_TAG = "openAllStores";
    private static final StoreType[] STORE_TYPES = StoreType.values();
    private final FileSystemAbstraction fileSystem;
    private final DatabaseLayout layout;
    private final Config config;
    private final IdGeneratorFactory idGeneratorFactory;
    private final PageCache pageCache;
    private final LogProvider logProvider;
    private final boolean createIfNotExist;
    private final StoreType[] initializedStores;
    private final RecordFormats recordFormats;
    private final CommonAbstractStore[] stores;
    private final PageCacheTracer pageCacheTracer;
    private final ImmutableSet<OpenOption> openOptions;

    NeoStores(FileSystemAbstraction fileSystem, DatabaseLayout layout, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, RecordFormats recordFormats, boolean createIfNotExist, PageCacheTracer pageCacheTracer, StoreType[] storeTypes, ImmutableSet<OpenOption> openOptions) {
        this.fileSystem = fileSystem;
        this.layout = layout;
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.pageCache = pageCache;
        this.logProvider = logProvider;
        this.recordFormats = recordFormats;
        this.createIfNotExist = createIfNotExist;
        this.pageCacheTracer = pageCacheTracer;
        this.openOptions = openOptions;
        this.stores = new CommonAbstractStore[StoreType.values().length];
        try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer(OPEN_ALL_STORES_TAG);){
            this.verifyRecordFormat(storeTypes, cursorTracer);
            try {
                for (StoreType type : storeTypes) {
                    this.getOrOpenStore(type, cursorTracer);
                }
            }
            catch (RuntimeException initException) {
                try {
                    this.close();
                }
                catch (RuntimeException closeException) {
                    initException.addSuppressed(closeException);
                }
                throw initException;
            }
        }
        this.initializedStores = storeTypes;
    }

    @Override
    public void close() {
        RuntimeException ex = null;
        for (StoreType type : STORE_TYPES) {
            try {
                this.closeStore(type);
            }
            catch (RuntimeException t) {
                ex = (RuntimeException)Exceptions.chain(ex, (Throwable)t);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private void verifyRecordFormat(StoreType[] storeTypes, PageCursorTracer cursorTracer) {
        String actualStoreVersion;
        RecordFormats actualStoreFormat;
        long existingFormat;
        String expectedStoreVersion = this.recordFormats.storeVersion();
        if (!this.fileSystem.fileExists(this.layout.metadataStore())) {
            return;
        }
        if (ArrayUtils.contains((Object[])storeTypes, (Object)((Object)StoreType.META_DATA))) {
            MetaDataStore metaDataStore = (MetaDataStore)this.getOrOpenStore(StoreType.META_DATA, cursorTracer);
            existingFormat = metaDataStore.getRecord(MetaDataStore.Position.STORE_VERSION.id(), metaDataStore.newRecord(), RecordLoad.CHECK, cursorTracer).getValue();
        } else {
            try {
                existingFormat = MetaDataStore.getRecord(this.pageCache, this.layout.metadataStore(), MetaDataStore.Position.STORE_VERSION, cursorTracer);
            }
            catch (NoSuchFileException e) {
                return;
            }
            catch (IOException e) {
                throw new UnderlyingStorageException((Throwable)e);
            }
        }
        if (existingFormat != -1L && !this.isCompatibleFormats(actualStoreFormat = RecordFormatSelector.selectForVersion(actualStoreVersion = MetaDataStore.versionLongToString(existingFormat)))) {
            throw new UnexpectedStoreVersionException(actualStoreVersion, expectedStoreVersion);
        }
    }

    private boolean isCompatibleFormats(RecordFormats storeFormat) {
        return FormatFamily.isSameFamily(this.recordFormats, storeFormat) && this.recordFormats.hasCompatibleCapabilities(storeFormat, CapabilityType.FORMAT) && this.recordFormats.generation() >= storeFormat.generation();
    }

    private void closeStore(StoreType type) {
        int i = type.ordinal();
        if (this.stores[i] != null) {
            try {
                this.stores[i].close();
            }
            finally {
                this.stores[i] = null;
            }
        }
    }

    public void flush(IOLimiter limiter, PageCursorTracer cursorTracer) throws IOException {
        this.pageCache.flushAndForce(limiter);
        this.visitStores(store -> store.getIdGenerator().checkpoint(limiter, cursorTracer));
    }

    private CommonAbstractStore openStore(StoreType type, PageCursorTracer cursorTracer) {
        CommonAbstractStore store;
        int storeIndex = type.ordinal();
        this.stores[storeIndex] = store = type.open(this, cursorTracer);
        return store;
    }

    private <T extends CommonAbstractStore> T initialize(T store, PageCursorTracer cursorTracer) {
        store.initialise(this.createIfNotExist, cursorTracer);
        return store;
    }

    private CommonAbstractStore getStore(StoreType storeType) {
        CommonAbstractStore store = this.stores[storeType.ordinal()];
        if (store == null) {
            String message = ArrayUtils.contains((Object[])this.initializedStores, (Object)((Object)storeType)) ? STORE_ALREADY_CLOSED_MESSAGE : String.format(STORE_NOT_INITIALIZED_TEMPLATE, storeType.name());
            throw new IllegalStateException(message);
        }
        return store;
    }

    private CommonAbstractStore getOrOpenStore(StoreType storeType, PageCursorTracer cursorTracer) {
        CommonAbstractStore store = this.stores[storeType.ordinal()];
        if (store == null) {
            store = this.openStore(storeType, cursorTracer);
        }
        return store;
    }

    public MetaDataStore getMetaDataStore() {
        return (MetaDataStore)this.getStore(StoreType.META_DATA);
    }

    public NodeStore getNodeStore() {
        return (NodeStore)this.getStore(StoreType.NODE);
    }

    public RelationshipStore getRelationshipStore() {
        return (RelationshipStore)this.getStore(StoreType.RELATIONSHIP);
    }

    public RelationshipTypeTokenStore getRelationshipTypeTokenStore() {
        return (RelationshipTypeTokenStore)this.getStore(StoreType.RELATIONSHIP_TYPE_TOKEN);
    }

    public LabelTokenStore getLabelTokenStore() {
        return (LabelTokenStore)this.getStore(StoreType.LABEL_TOKEN);
    }

    public PropertyStore getPropertyStore() {
        return (PropertyStore)this.getStore(StoreType.PROPERTY);
    }

    public PropertyKeyTokenStore getPropertyKeyTokenStore() {
        return (PropertyKeyTokenStore)this.getStore(StoreType.PROPERTY_KEY_TOKEN);
    }

    public RelationshipGroupStore getRelationshipGroupStore() {
        return (RelationshipGroupStore)this.getStore(StoreType.RELATIONSHIP_GROUP);
    }

    public SchemaStore getSchemaStore() {
        return (SchemaStore)this.getStore(StoreType.SCHEMA);
    }

    public void start(PageCursorTracer cursorTracer) throws IOException {
        this.start(store -> {}, cursorTracer);
    }

    public void start(Consumer<CommonAbstractStore<?, ?>> listener, PageCursorTracer cursorTracer) throws IOException {
        this.visitStores(store -> {
            store.start(cursorTracer);
            listener.accept((CommonAbstractStore<?, ?>)store);
        });
    }

    public void verifyStoreOk() {
        this.visitStores(CommonAbstractStore::checkStoreOk);
    }

    public void logVersions(DiagnosticsLogger msgLog) {
        this.visitStores(store -> store.logVersions(msgLog));
    }

    public void logIdUsage(DiagnosticsLogger msgLog) {
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer(ID_USAGE_LOGGER_TAG);){
            this.visitStores(store -> store.logIdUsage(msgLog, cursorTracer));
        }
    }

    private <E extends Exception> void visitStores(ThrowingConsumer<CommonAbstractStore, E> visitor) throws E {
        for (CommonAbstractStore store : this.stores) {
            if (store == null) continue;
            visitor.accept((Object)store);
        }
    }

    CommonAbstractStore createNodeStore(PageCursorTracer cursorTracer) {
        return this.initialize(new NodeStore(this.layout.nodeStore(), this.layout.idNodeStore(), this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, (DynamicArrayStore)this.getOrOpenStore(StoreType.NODE_LABEL, cursorTracer), this.recordFormats, this.openOptions), cursorTracer);
    }

    CommonAbstractStore createNodeLabelStore(PageCursorTracer cursorTracer) {
        return this.createDynamicArrayStore(this.layout.nodeLabelStore(), this.layout.idNodeLabelStore(), IdType.NODE_LABELS, (Setting<Integer>)GraphDatabaseInternalSettings.label_block_size, cursorTracer);
    }

    CommonAbstractStore createPropertyKeyTokenStore(PageCursorTracer cursorTracer) {
        return this.initialize(new PropertyKeyTokenStore(this.layout.propertyKeyTokenStore(), this.layout.idPropertyKeyTokenStore(), this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, (DynamicStringStore)this.getOrOpenStore(StoreType.PROPERTY_KEY_TOKEN_NAME, cursorTracer), this.recordFormats, this.openOptions), cursorTracer);
    }

    CommonAbstractStore createPropertyKeyTokenNamesStore(PageCursorTracer cursorTracer) {
        return this.createDynamicStringStore(this.layout.propertyKeyTokenNamesStore(), this.layout.idPropertyKeyTokenNamesStore(), IdType.PROPERTY_KEY_TOKEN_NAME, 30, cursorTracer);
    }

    CommonAbstractStore createPropertyStore(PageCursorTracer cursorTracer) {
        return this.initialize(new PropertyStore(this.layout.propertyStore(), this.layout.idPropertyStore(), this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, (DynamicStringStore)this.getOrOpenStore(StoreType.PROPERTY_STRING, cursorTracer), (PropertyKeyTokenStore)this.getOrOpenStore(StoreType.PROPERTY_KEY_TOKEN, cursorTracer), (DynamicArrayStore)this.getOrOpenStore(StoreType.PROPERTY_ARRAY, cursorTracer), this.recordFormats, this.openOptions), cursorTracer);
    }

    CommonAbstractStore createPropertyStringStore(PageCursorTracer cursorTracer) {
        return this.createDynamicStringStore(this.layout.propertyStringStore(), this.layout.idPropertyStringStore(), cursorTracer);
    }

    CommonAbstractStore createPropertyArrayStore(PageCursorTracer cursorTracer) {
        return this.createDynamicArrayStore(this.layout.propertyArrayStore(), this.layout.idPropertyArrayStore(), IdType.ARRAY_BLOCK, (Setting<Integer>)GraphDatabaseInternalSettings.array_block_size, cursorTracer);
    }

    CommonAbstractStore createRelationshipStore(PageCursorTracer cursorTracer) {
        return this.initialize(new RelationshipStore(this.layout.relationshipStore(), this.layout.idRelationshipStore(), this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, this.recordFormats, this.openOptions), cursorTracer);
    }

    CommonAbstractStore createRelationshipTypeTokenStore(PageCursorTracer cursorTracer) {
        return this.initialize(new RelationshipTypeTokenStore(this.layout.relationshipTypeTokenStore(), this.layout.idRelationshipTypeTokenStore(), this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, (DynamicStringStore)this.getOrOpenStore(StoreType.RELATIONSHIP_TYPE_TOKEN_NAME, cursorTracer), this.recordFormats, this.openOptions), cursorTracer);
    }

    CommonAbstractStore createRelationshipTypeTokenNamesStore(PageCursorTracer cursorTracer) {
        return this.createDynamicStringStore(this.layout.relationshipTypeTokenNamesStore(), this.layout.idRelationshipTypeTokenNamesStore(), IdType.RELATIONSHIP_TYPE_TOKEN_NAME, 30, cursorTracer);
    }

    CommonAbstractStore createLabelTokenStore(PageCursorTracer cursorTracer) {
        return this.initialize(new LabelTokenStore(this.layout.labelTokenStore(), this.layout.idLabelTokenStore(), this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, (DynamicStringStore)this.getOrOpenStore(StoreType.LABEL_TOKEN_NAME, cursorTracer), this.recordFormats, this.openOptions), cursorTracer);
    }

    CommonAbstractStore createSchemaStore(PageCursorTracer cursorTracer) {
        return this.initialize(new SchemaStore(this.layout.schemaStore(), this.layout.idSchemaStore(), this.config, IdType.SCHEMA, this.idGeneratorFactory, this.pageCache, this.logProvider, (PropertyStore)this.getOrOpenStore(StoreType.PROPERTY, cursorTracer), this.recordFormats, this.openOptions), cursorTracer);
    }

    CommonAbstractStore createRelationshipGroupStore(PageCursorTracer cursorTracer) {
        return this.initialize(new RelationshipGroupStore(this.layout.relationshipGroupStore(), this.layout.idRelationshipGroupStore(), this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, this.recordFormats, this.openOptions), cursorTracer);
    }

    CommonAbstractStore createLabelTokenNamesStore(PageCursorTracer cursorTracer) {
        return this.createDynamicStringStore(this.layout.labelTokenNamesStore(), this.layout.idLabelTokenNamesStore(), IdType.LABEL_TOKEN_NAME, 30, cursorTracer);
    }

    CommonAbstractStore createMetadataStore(PageCursorTracer cursorTracer) {
        return this.initialize(new MetaDataStore(this.layout.metadataStore(), this.layout.idMetadataStore(), this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, this.recordFormats.metaData(), this.recordFormats.storeVersion(), this.pageCacheTracer, this.openOptions), cursorTracer);
    }

    private CommonAbstractStore createDynamicStringStore(Path storeFile, Path idFile, PageCursorTracer cursorTracer) {
        return this.createDynamicStringStore(storeFile, idFile, IdType.STRING_BLOCK, (Integer)this.config.get(GraphDatabaseInternalSettings.string_block_size), cursorTracer);
    }

    private CommonAbstractStore createDynamicStringStore(Path storeFile, Path idFile, IdType idType, int blockSize, PageCursorTracer cursorTracer) {
        return this.initialize(new DynamicStringStore(storeFile, idFile, this.config, idType, this.idGeneratorFactory, this.pageCache, this.logProvider, blockSize, this.recordFormats.dynamic(), this.recordFormats.storeVersion(), this.openOptions), cursorTracer);
    }

    private CommonAbstractStore createDynamicArrayStore(Path storeFile, Path idFile, IdType idType, Setting<Integer> blockSizeProperty, PageCursorTracer cursorTracer) {
        return this.createDynamicArrayStore(storeFile, idFile, idType, (Integer)this.config.get(blockSizeProperty), cursorTracer);
    }

    CommonAbstractStore createDynamicArrayStore(Path storeFile, Path idFile, IdType idType, int blockSize, PageCursorTracer cursorTracer) {
        if (blockSize <= 0) {
            throw new IllegalArgumentException("Block size of dynamic array store should be positive integer.");
        }
        return this.initialize(new DynamicArrayStore(storeFile, idFile, this.config, idType, this.idGeneratorFactory, this.pageCache, this.logProvider, blockSize, this.recordFormats, this.openOptions), cursorTracer);
    }

    public <RECORD extends AbstractBaseRecord> RecordStore<RECORD> getRecordStore(StoreType type) {
        return this.getStore(type);
    }

    public RecordFormats getRecordFormats() {
        return this.recordFormats;
    }

    public static boolean isStorePresent(FileSystemAbstraction fs, DatabaseLayout databaseLayout) {
        return fs.fileExists(databaseLayout.metadataStore());
    }
}

