/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.configuration.Config;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.recordstorage.InconsistentDataReadException;
import org.neo4j.internal.recordstorage.RecordPropertyCursor;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.GeometryType;
import org.neo4j.kernel.impl.store.IdUpdateListener;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.LongerShortString;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.PropertyValueRecordSizeCalculator;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.TemporalType;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.RecordStorageCapability;
import org.neo4j.kernel.impl.store.format.UnsupportedFormatCapabilityException;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.string.UTF8;
import org.neo4j.util.Bits;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.TemporalValueWriterAdapter;

public class PropertyStore
extends CommonAbstractStore<PropertyRecord, NoStoreHeader> {
    public static final String TYPE_DESCRIPTOR = "PropertyStore";
    private final DynamicStringStore stringStore;
    private final PropertyKeyTokenStore propertyKeyTokenStore;
    private final DynamicArrayStore arrayStore;
    private final boolean allowStorePointsAndTemporal;

    public PropertyStore(Path path, Path idFile, Config configuration, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, DynamicStringStore stringPropertyStore, PropertyKeyTokenStore propertyKeyTokenStore, DynamicArrayStore arrayPropertyStore, RecordFormats recordFormats, ImmutableSet<OpenOption> openOptions) {
        super(path, idFile, configuration, IdType.PROPERTY, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, recordFormats.property(), NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, recordFormats.storeVersion(), openOptions);
        this.stringStore = stringPropertyStore;
        this.propertyKeyTokenStore = propertyKeyTokenStore;
        this.arrayStore = arrayPropertyStore;
        this.allowStorePointsAndTemporal = recordFormats.hasCapability(RecordStorageCapability.POINT_PROPERTIES) && recordFormats.hasCapability(RecordStorageCapability.TEMPORAL_PROPERTIES);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, PropertyRecord record, PageCursorTracer cursorTracer) throws FAILURE {
        processor.processProperty(this, record, cursorTracer);
    }

    public DynamicStringStore getStringStore() {
        return this.stringStore;
    }

    public DynamicArrayStore getArrayStore() {
        return this.arrayStore;
    }

    public PropertyKeyTokenStore getPropertyKeyTokenStore() {
        return this.propertyKeyTokenStore;
    }

    @Override
    public void updateRecord(PropertyRecord record, IdUpdateListener idUpdateListener, PageCursorTracer cursorTracer) {
        this.updatePropertyBlocks(record, idUpdateListener, cursorTracer);
        super.updateRecord(record, idUpdateListener, cursorTracer);
    }

    private void updatePropertyBlocks(PropertyRecord record, IdUpdateListener idUpdateListener, PageCursorTracer cursorTracer) {
        if (record.inUse()) {
            for (PropertyBlock block : record) {
                if (block.isLight() || !block.getValueRecords().get(0).isCreated()) continue;
                this.updateDynamicRecords(block.getValueRecords(), idUpdateListener, cursorTracer);
            }
        }
        this.updateDynamicRecords(record.getDeletedRecords(), idUpdateListener, cursorTracer);
    }

    private void updateDynamicRecords(List<DynamicRecord> records, IdUpdateListener idUpdateListener, PageCursorTracer cursorTracer) {
        for (DynamicRecord valueRecord : records) {
            PropertyType recordType = valueRecord.getType();
            if (recordType == PropertyType.STRING) {
                this.stringStore.updateRecord(valueRecord, idUpdateListener, cursorTracer);
                continue;
            }
            if (recordType == PropertyType.ARRAY) {
                this.arrayStore.updateRecord(valueRecord, idUpdateListener, cursorTracer);
                continue;
            }
            throw new InvalidRecordException("Unknown dynamic record" + valueRecord);
        }
    }

    @Override
    public void ensureHeavy(PropertyRecord record, PageCursorTracer cursorTracer) {
        for (PropertyBlock block : record) {
            this.ensureHeavy(block, cursorTracer);
        }
    }

    @Override
    public void ensureHeavy(PropertyBlock block, PageCursorTracer cursorTracer) {
        if (!block.isLight()) {
            return;
        }
        PropertyType type = block.getType();
        RecordStore<DynamicRecord> dynamicStore = this.dynamicStoreForValueType(type);
        if (dynamicStore != null) {
            List<DynamicRecord> dynamicRecords = dynamicStore.getRecords(block.getSingleValueLong(), RecordLoad.NORMAL, false, cursorTracer);
            for (DynamicRecord dynamicRecord : dynamicRecords) {
                dynamicRecord.setType(type.intValue());
            }
            block.setValueRecords(dynamicRecords);
        }
    }

    private RecordStore<DynamicRecord> dynamicStoreForValueType(PropertyType type) {
        switch (type) {
            case ARRAY: {
                return this.arrayStore;
            }
            case STRING: {
                return this.stringStore;
            }
        }
        return null;
    }

    public Value getValue(PropertyBlock propertyBlock, PageCursorTracer cursorTracer) {
        return propertyBlock.getType().value(propertyBlock, this, cursorTracer);
    }

    private static void allocateStringRecords(Collection<DynamicRecord> target, byte[] chars, DynamicRecordAllocator allocator, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        AbstractDynamicStore.allocateRecordsFromBytes(target, chars, allocator, cursorTracer, memoryTracker);
    }

    private static void allocateArrayRecords(Collection<DynamicRecord> target, Object array, DynamicRecordAllocator allocator, boolean allowStorePoints, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        DynamicArrayStore.allocateRecords(target, array, allocator, allowStorePoints, cursorTracer, memoryTracker);
    }

    public void encodeValue(PropertyBlock block, int keyId, Value value, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        PropertyStore.encodeValue(block, keyId, value, this.stringStore, this.arrayStore, this.allowStorePointsAndTemporal, cursorTracer, memoryTracker);
    }

    public static void encodeValue(PropertyBlock block, int keyId, Value value, DynamicRecordAllocator stringAllocator, DynamicRecordAllocator arrayAllocator, boolean allowStorePointsAndTemporal, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        if (value instanceof ArrayValue) {
            Object asObject = value.asObject();
            if (ShortArray.encode(keyId, asObject, block, PropertyType.getPayloadSize())) {
                return;
            }
            HeapTrackingArrayList arrayRecords = HeapTrackingCollections.newArrayList((MemoryTracker)memoryTracker);
            PropertyStore.allocateArrayRecords((Collection<DynamicRecord>)arrayRecords, asObject, arrayAllocator, allowStorePointsAndTemporal, cursorTracer, memoryTracker);
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.ARRAY, ((DynamicRecord)Iterables.first((Iterable)arrayRecords)).getId());
            for (DynamicRecord valueRecord : arrayRecords) {
                valueRecord.setType(PropertyType.ARRAY.intValue());
            }
            block.setValueRecords((List<DynamicRecord>)arrayRecords);
        } else {
            value.writeTo((ValueWriter)new PropertyBlockValueWriter(block, keyId, stringAllocator, allowStorePointsAndTemporal, cursorTracer, memoryTracker));
        }
    }

    public PageCursor openStringPageCursor(long reference, PageCursorTracer cursorTracer) {
        return this.stringStore.openPageCursorForReading(reference, cursorTracer);
    }

    public PageCursor openArrayPageCursor(long reference, PageCursorTracer cursorTracer) {
        return this.arrayStore.openPageCursorForReading(reference, cursorTracer);
    }

    public void loadString(long reference, RecordPropertyCursor propertyCursor, PageCursor page, RecordLoad loadMode) {
        PropertyStore.readDynamic(this.stringStore, reference, propertyCursor, page, loadMode);
    }

    public void loadArray(long reference, RecordPropertyCursor propertyCursor, PageCursor page, RecordLoad loadMode) {
        PropertyStore.readDynamic(this.arrayStore, reference, propertyCursor, page, loadMode);
    }

    private static void readDynamic(AbstractDynamicStore store, long reference, RecordPropertyCursor propertyCursor, PageCursor page, RecordLoad loadMode) {
        ByteBuffer buffer = propertyCursor.getOrCreateClearBuffer();
        DynamicRecord record = (DynamicRecord)store.newRecord();
        MutableLongSet seenDynamicIds = null;
        long firstReference = reference;
        int count = 0;
        do {
            store.getRecordByCursor(reference, record, loadMode, page);
            reference = record.getNextBlock();
            byte[] data = record.getData();
            if (buffer.remaining() < data.length) {
                buffer = propertyCursor.growBuffer(data.length);
            }
            buffer.put(data, 0, data.length);
            if (++count < 100000) continue;
            if (seenDynamicIds == null) {
                seenDynamicIds = LongSets.mutable.empty();
            }
            if (seenDynamicIds.add(reference)) continue;
            throw new InconsistentDataReadException("Chain cycle detected in dynamic property value store %s starting at id:%d", store, firstReference);
        } while (reference != -1L);
    }

    public static void setSingleBlockValue(PropertyBlock block, int keyId, PropertyType type, long longValue) {
        block.setSingleBlock(PropertyStore.singleBlockLongValue(keyId, type, longValue));
    }

    public static long singleBlockLongValue(int keyId, PropertyType type, long longValue) {
        return (long)keyId | (long)type.intValue() << 24 | longValue << 28;
    }

    public static byte[] encodeString(String string) {
        return UTF8.encode((String)string);
    }

    public static String decodeString(byte[] byteArray) {
        return UTF8.decode((byte[])byteArray);
    }

    TextValue getTextValueFor(PropertyBlock propertyBlock, PageCursorTracer cursorTracer) {
        this.ensureHeavy(propertyBlock, cursorTracer);
        return this.getTextValueFor(propertyBlock.getValueRecords(), cursorTracer);
    }

    public TextValue getTextValueFor(Collection<DynamicRecord> dynamicRecords, PageCursorTracer cursorTracer) {
        Pair<byte[], byte[]> source = this.stringStore.readFullByteArray(dynamicRecords, PropertyType.STRING, cursorTracer);
        return Values.utf8Value((byte[])((byte[])source.other()));
    }

    Value getArrayFor(PropertyBlock propertyBlock, PageCursorTracer cursorTracer) {
        this.ensureHeavy(propertyBlock, cursorTracer);
        return this.getArrayFor(propertyBlock.getValueRecords(), cursorTracer);
    }

    public Value getArrayFor(Iterable<DynamicRecord> records, PageCursorTracer cursorTracer) {
        return DynamicArrayStore.getRightArray(this.arrayStore.readFullByteArray(records, PropertyType.ARRAY, cursorTracer));
    }

    @Override
    public String toString() {
        return super.toString() + "[blocksPerRecord:" + PropertyType.getPayloadSizeLongs() + "]";
    }

    @Override
    public PropertyRecord newRecord() {
        return new PropertyRecord(-1L);
    }

    public boolean allowStorePointsAndTemporal() {
        return this.allowStorePointsAndTemporal;
    }

    public PropertyValueRecordSizeCalculator newValueEncodedSizeCalculator() {
        return new PropertyValueRecordSizeCalculator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayValue readArrayFromBuffer(ByteBuffer buffer) {
        if (buffer.limit() <= 0) {
            throw new IllegalStateException("Given buffer is empty");
        }
        byte typeId = buffer.get();
        buffer.order(ByteOrder.BIG_ENDIAN);
        try {
            if (typeId == PropertyType.STRING.intValue()) {
                int arrayLength = buffer.getInt();
                String[] result = new String[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    int byteLength = buffer.getInt();
                    result[i] = UTF8.decode((byte[])buffer.array(), (int)buffer.position(), (int)byteLength);
                    buffer.position(buffer.position() + byteLength);
                }
                TextArray i = Values.stringArray((String[])result);
                return i;
            }
            if (typeId == PropertyType.GEOMETRY.intValue()) {
                GeometryType.GeometryHeader header = GeometryType.GeometryHeader.fromArrayHeaderByteBuffer(buffer);
                byte[] byteArray = new byte[buffer.limit() - buffer.position()];
                buffer.get(byteArray);
                ArrayValue i = GeometryType.decodeGeometryArray(header, byteArray);
                return i;
            }
            if (typeId == PropertyType.TEMPORAL.intValue()) {
                TemporalType.TemporalHeader header = TemporalType.TemporalHeader.fromArrayHeaderByteBuffer(buffer);
                byte[] byteArray = new byte[buffer.limit() - buffer.position()];
                buffer.get(byteArray);
                ArrayValue i = TemporalType.decodeTemporalArray(header, byteArray);
                return i;
            }
            ShortArray type = ShortArray.typeOf(typeId);
            byte bitsUsedInLastByte = buffer.get();
            byte requiredBits = buffer.get();
            if (requiredBits == 0) {
                ArrayValue byteLength = type.createEmptyArray();
                return byteLength;
            }
            if (type == ShortArray.BYTE && requiredBits == 8) {
                byte[] byteArray = new byte[buffer.limit() - buffer.position()];
                buffer.get(byteArray);
                ByteArray byteArray2 = Values.byteArray((byte[])byteArray);
                return byteArray2;
            }
            Bits bits = Bits.bitsFromBytes((byte[])buffer.array(), (int)buffer.position());
            int length = ((buffer.limit() - buffer.position()) * 8 - (8 - bitsUsedInLastByte)) / requiredBits;
            ArrayValue arrayValue = type.createArray(length, bits, requiredBits);
            return arrayValue;
        }
        finally {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    private static class PropertyBlockValueWriter
    extends TemporalValueWriterAdapter<IllegalArgumentException> {
        private final PropertyBlock block;
        private final int keyId;
        private final DynamicRecordAllocator stringAllocator;
        private final boolean allowStorePointsAndTemporal;
        private final PageCursorTracer cursorTracer;
        private final MemoryTracker memoryTracker;

        PropertyBlockValueWriter(PropertyBlock block, int keyId, DynamicRecordAllocator stringAllocator, boolean allowStorePointsAndTemporal, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
            this.block = block;
            this.keyId = keyId;
            this.stringAllocator = stringAllocator;
            this.allowStorePointsAndTemporal = allowStorePointsAndTemporal;
            this.cursorTracer = cursorTracer;
            this.memoryTracker = memoryTracker;
        }

        public void writeNull() throws IllegalArgumentException {
            throw new IllegalArgumentException("Cannot write null values to the property store");
        }

        public void writeBoolean(boolean value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.BOOL, value ? 1L : 0L);
        }

        public void writeInteger(byte value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.BYTE, value);
        }

        public void writeInteger(short value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.SHORT, value);
        }

        public void writeInteger(int value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.INT, value);
        }

        public void writeInteger(long value) throws IllegalArgumentException {
            long keyAndType = (long)this.keyId | (long)PropertyType.LONG.intValue() << 24;
            if (ShortArray.LONG.getRequiredBits(value) <= 35) {
                this.block.setSingleBlock(keyAndType | 0x10000000L | value << 29);
            } else {
                this.block.setValueBlocks(new long[]{keyAndType, value});
            }
        }

        public void writeFloatingPoint(float value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.FLOAT, Float.floatToRawIntBits(value));
        }

        public void writeFloatingPoint(double value) throws IllegalArgumentException {
            this.block.setValueBlocks(new long[]{(long)this.keyId | (long)PropertyType.DOUBLE.intValue() << 24, Double.doubleToRawLongBits(value)});
        }

        public void writeString(String value) throws IllegalArgumentException {
            if (LongerShortString.encode(this.keyId, value, this.block, PropertyType.getPayloadSize())) {
                return;
            }
            byte[] encodedString = PropertyStore.encodeString(value);
            HeapTrackingArrayList valueRecords = HeapTrackingCollections.newArrayList((MemoryTracker)this.memoryTracker);
            PropertyStore.allocateStringRecords((Collection<DynamicRecord>)valueRecords, encodedString, this.stringAllocator, this.cursorTracer, this.memoryTracker);
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.STRING, ((DynamicRecord)Iterables.first((Iterable)valueRecords)).getId());
            for (DynamicRecord valueRecord : valueRecords) {
                valueRecord.setType(PropertyType.STRING.intValue());
            }
            this.block.setValueRecords((List<DynamicRecord>)valueRecords);
        }

        public void writeString(char value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.CHAR, value);
        }

        public void beginArray(int size, ValueWriter.ArrayType arrayType) throws IllegalArgumentException {
            throw new IllegalArgumentException("Cannot persist arrays to property store using ValueWriter");
        }

        public void endArray() throws IllegalArgumentException {
            throw new IllegalArgumentException("Cannot persist arrays to property store using ValueWriter");
        }

        public void writeByteArray(byte[] value) throws IllegalArgumentException {
            throw new IllegalArgumentException("Cannot persist arrays to property store using ValueWriter");
        }

        public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(RecordStorageCapability.POINT_PROPERTIES);
            }
            this.block.setValueBlocks(GeometryType.encodePoint(this.keyId, crs, coordinate));
        }

        public void writeDuration(long months, long days, long seconds, int nanos) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(RecordStorageCapability.TEMPORAL_PROPERTIES);
            }
            this.block.setValueBlocks(TemporalType.encodeDuration(this.keyId, months, days, seconds, nanos));
        }

        public void writeDate(long epochDay) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(RecordStorageCapability.TEMPORAL_PROPERTIES);
            }
            this.block.setValueBlocks(TemporalType.encodeDate(this.keyId, epochDay));
        }

        public void writeLocalTime(long nanoOfDay) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(RecordStorageCapability.TEMPORAL_PROPERTIES);
            }
            this.block.setValueBlocks(TemporalType.encodeLocalTime(this.keyId, nanoOfDay));
        }

        public void writeTime(long nanosOfDayUTC, int offsetSeconds) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(RecordStorageCapability.TEMPORAL_PROPERTIES);
            }
            this.block.setValueBlocks(TemporalType.encodeTime(this.keyId, nanosOfDayUTC, offsetSeconds));
        }

        public void writeLocalDateTime(long epochSecond, int nano) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(RecordStorageCapability.TEMPORAL_PROPERTIES);
            }
            this.block.setValueBlocks(TemporalType.encodeLocalDateTime(this.keyId, epochSecond, nano));
        }

        public void writeDateTime(long epochSecondUTC, int nano, int offsetSeconds) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(RecordStorageCapability.TEMPORAL_PROPERTIES);
            }
            this.block.setValueBlocks(TemporalType.encodeDateTime(this.keyId, epochSecondUTC, (long)nano, offsetSeconds));
        }

        public void writeDateTime(long epochSecondUTC, int nano, String zoneId) throws IllegalArgumentException {
            if (!this.allowStorePointsAndTemporal) {
                throw new UnsupportedFormatCapabilityException(RecordStorageCapability.TEMPORAL_PROPERTIES);
            }
            this.block.setValueBlocks(TemporalType.encodeDateTime(this.keyId, epochSecondUTC, (long)nano, zoneId));
        }
    }
}

