/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.neo4j.internal.batchimport.input.PropertySizeCalculator;
import org.neo4j.internal.id.BatchingIdSequence;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StandardDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.Value;

public class PropertyValueRecordSizeCalculator
implements PropertySizeCalculator {
    private final BatchingIdSequence stringRecordIds = new BatchingIdSequence();
    private final DynamicRecordAllocator stringRecordCounter;
    private final BatchingIdSequence arrayRecordIds = new BatchingIdSequence();
    private final DynamicRecordAllocator arrayRecordCounter;
    private final int propertyRecordSize;
    private final int stringRecordSize;
    private final int arrayRecordSize;

    public PropertyValueRecordSizeCalculator(PropertyStore propertyStore) {
        this(propertyStore.getRecordSize(), propertyStore.getStringStore().getRecordSize(), propertyStore.getStringStore().getRecordDataSize(), propertyStore.getArrayStore().getRecordSize(), propertyStore.getArrayStore().getRecordDataSize());
    }

    public PropertyValueRecordSizeCalculator(int propertyRecordSize, int stringRecordSize, int stringRecordDataSize, int arrayRecordSize, int arrayRecordDataSize) {
        this.propertyRecordSize = propertyRecordSize;
        this.stringRecordSize = stringRecordSize;
        this.arrayRecordSize = arrayRecordSize;
        this.stringRecordCounter = new StandardDynamicRecordAllocator((IdSequence)this.stringRecordIds, stringRecordDataSize);
        this.arrayRecordCounter = new StandardDynamicRecordAllocator((IdSequence)this.arrayRecordIds, arrayRecordDataSize);
    }

    public int calculateSize(Value[] values, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        this.stringRecordIds.reset();
        this.arrayRecordIds.reset();
        int propertyRecordsUsed = 0;
        int freeBlocksInCurrentRecord = 0;
        for (Value value : values) {
            PropertyBlock block = new PropertyBlock();
            PropertyStore.encodeValue(block, 0, value, this.stringRecordCounter, this.arrayRecordCounter, true, cursorTracer, memoryTracker);
            if (block.getValueBlocks().length > freeBlocksInCurrentRecord) {
                ++propertyRecordsUsed;
                freeBlocksInCurrentRecord = PropertyType.getPayloadSizeLongs();
            }
            freeBlocksInCurrentRecord -= block.getValueBlocks().length;
        }
        int size = propertyRecordsUsed * this.propertyRecordSize;
        size += Math.toIntExact(this.stringRecordIds.peek()) * this.stringRecordSize;
        return size += Math.toIntExact(this.arrayRecordIds.peek()) * this.arrayRecordSize;
    }
}

