/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.IdUpdateListener;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordSubscriber;
import org.neo4j.kernel.impl.store.Scanner;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;

public interface RecordStore<RECORD extends AbstractBaseRecord>
extends IdSequence {
    public Path getStorageFile();

    public long getHighId();

    public long getHighestPossibleIdInUse(PageCursorTracer var1);

    public void setHighestPossibleIdInUse(long var1);

    public RECORD newRecord();

    public RECORD getRecord(long var1, RECORD var3, RecordLoad var4, PageCursorTracer var5) throws InvalidRecordException;

    public PageCursor openPageCursorForReading(long var1, PageCursorTracer var3);

    public PageCursor openPageCursorForReadingWithPrefetching(long var1, PageCursorTracer var3);

    public void getRecordByCursor(long var1, RECORD var3, RecordLoad var4, PageCursor var5) throws InvalidRecordException;

    public void nextRecordByCursor(RECORD var1, RecordLoad var2, PageCursor var3) throws InvalidRecordException;

    public void ensureHeavy(RECORD var1, PageCursorTracer var2);

    public List<RECORD> getRecords(long var1, RecordLoad var3, boolean var4, PageCursorTracer var5) throws InvalidRecordException;

    public void streamRecords(long var1, RecordLoad var3, boolean var4, PageCursorTracer var5, RecordSubscriber<RECORD> var6);

    public long getNextRecordReference(RECORD var1);

    public void updateRecord(RECORD var1, IdUpdateListener var2, PageCursorTracer var3);

    default public void updateRecord(RECORD record, PageCursorTracer cursorTracer) {
        this.updateRecord(record, IdUpdateListener.DIRECT, cursorTracer);
    }

    public <FAILURE extends Exception> void accept(Processor<FAILURE> var1, RECORD var2, PageCursorTracer var3) throws FAILURE;

    public int getRecordSize();

    @Deprecated
    public int getRecordDataSize();

    public int getRecordsPerPage();

    public void close();

    public void flush(PageCursorTracer var1);

    public int getNumberOfReservedLowIds();

    public int getStoreHeaderInt();

    public void prepareForCommit(RECORD var1, PageCursorTracer var2);

    public void prepareForCommit(RECORD var1, IdSequence var2, PageCursorTracer var3);

    public <EXCEPTION extends Exception> void scanAllRecords(Visitor<RECORD, EXCEPTION> var1, PageCursorTracer var2) throws EXCEPTION;

    public static abstract class Processor<FAILURE extends Exception> {
        private static final String RECORD_PROCESSOR_APPLIER_TAG = "recordProcessorApplier";
        private volatile boolean shouldStop;

        public void stop() {
            this.shouldStop = true;
        }

        public abstract void processSchema(RecordStore<SchemaRecord> var1, SchemaRecord var2, PageCursorTracer var3) throws FAILURE;

        public abstract void processNode(RecordStore<NodeRecord> var1, NodeRecord var2, PageCursorTracer var3) throws FAILURE;

        public abstract void processRelationship(RecordStore<RelationshipRecord> var1, RelationshipRecord var2, PageCursorTracer var3) throws FAILURE;

        public abstract void processProperty(RecordStore<PropertyRecord> var1, PropertyRecord var2, PageCursorTracer var3) throws FAILURE;

        public abstract void processString(RecordStore<DynamicRecord> var1, DynamicRecord var2, IdType var3, PageCursorTracer var4) throws FAILURE;

        public abstract void processArray(RecordStore<DynamicRecord> var1, DynamicRecord var2, PageCursorTracer var3) throws FAILURE;

        public abstract void processLabelArrayWithOwner(RecordStore<DynamicRecord> var1, DynamicRecord var2, PageCursorTracer var3) throws FAILURE;

        public abstract void processRelationshipTypeToken(RecordStore<RelationshipTypeTokenRecord> var1, RelationshipTypeTokenRecord var2, PageCursorTracer var3) throws FAILURE;

        public abstract void processPropertyKeyToken(RecordStore<PropertyKeyTokenRecord> var1, PropertyKeyTokenRecord var2, PageCursorTracer var3) throws FAILURE;

        public abstract void processLabelToken(RecordStore<LabelTokenRecord> var1, LabelTokenRecord var2, PageCursorTracer var3) throws FAILURE;

        public abstract void processRelationshipGroup(RecordStore<RelationshipGroupRecord> var1, RelationshipGroupRecord var2, PageCursorTracer var3) throws FAILURE;

        public <R extends AbstractBaseRecord> void applyFiltered(RecordStore<R> store, ProgressListener progressListener, PageCacheTracer pageCacheTracer, Predicate<? super R> ... filters) throws FAILURE {
            this.apply(store, progressListener, pageCacheTracer, filters);
        }

        private <R extends AbstractBaseRecord> void apply(RecordStore<R> store, ProgressListener progressListener, PageCacheTracer pageCacheTracer, Predicate<? super R> ... filters) throws FAILURE {
            ResourceIterable<? super R> iterable = Scanner.scan(store, true, pageCacheTracer, filters);
            long lastReported = -1L;
            try (PageCursorTracer cursorTracer = pageCacheTracer.createPageCursorTracer(RECORD_PROCESSOR_APPLIER_TAG);
                 ResourceIterator scan = iterable.iterator();){
                while (scan.hasNext()) {
                    AbstractBaseRecord record = (AbstractBaseRecord)scan.next();
                    if (this.shouldStop) break;
                    store.accept(this, record, cursorTracer);
                    long diff = record.getId() - lastReported;
                    progressListener.add(diff);
                    lastReported = record.getId();
                }
                progressListener.done();
            }
        }
    }

    public static class Delegator<R extends AbstractBaseRecord>
    implements RecordStore<R> {
        private final RecordStore<R> actual;

        @Override
        public void setHighestPossibleIdInUse(long highestIdInUse) {
            this.actual.setHighestPossibleIdInUse(highestIdInUse);
        }

        @Override
        public R newRecord() {
            return this.actual.newRecord();
        }

        @Override
        public R getRecord(long id, R target, RecordLoad mode, PageCursorTracer cursorTracer) throws InvalidRecordException {
            return this.actual.getRecord(id, target, mode, cursorTracer);
        }

        @Override
        public PageCursor openPageCursorForReading(long id, PageCursorTracer cursorTracer) {
            return this.actual.openPageCursorForReading(id, cursorTracer);
        }

        @Override
        public PageCursor openPageCursorForReadingWithPrefetching(long id, PageCursorTracer cursorTracer) {
            return this.actual.openPageCursorForReadingWithPrefetching(id, cursorTracer);
        }

        @Override
        public void getRecordByCursor(long id, R target, RecordLoad mode, PageCursor cursor) throws InvalidRecordException {
            this.actual.getRecordByCursor(id, target, mode, cursor);
        }

        @Override
        public void nextRecordByCursor(R target, RecordLoad mode, PageCursor cursor) throws InvalidRecordException {
            this.actual.nextRecordByCursor(target, mode, cursor);
        }

        @Override
        public List<R> getRecords(long firstId, RecordLoad mode, boolean guardForCycles, PageCursorTracer cursorTracer) throws InvalidRecordException {
            return this.actual.getRecords(firstId, mode, guardForCycles, cursorTracer);
        }

        @Override
        public void streamRecords(long firstId, RecordLoad mode, boolean guardForCycles, PageCursorTracer cursorTracer, RecordSubscriber<R> subscriber) {
            this.actual.streamRecords(firstId, mode, guardForCycles, cursorTracer, subscriber);
        }

        @Override
        public long getNextRecordReference(R record) {
            return this.actual.getNextRecordReference(record);
        }

        public Delegator(RecordStore<R> actual) {
            this.actual = actual;
        }

        public long nextId(PageCursorTracer cursorTracer) {
            return this.actual.nextId(cursorTracer);
        }

        @Override
        public Path getStorageFile() {
            return this.actual.getStorageFile();
        }

        @Override
        public long getHighId() {
            return this.actual.getHighId();
        }

        @Override
        public long getHighestPossibleIdInUse(PageCursorTracer cursorTracer) {
            return this.actual.getHighestPossibleIdInUse(cursorTracer);
        }

        @Override
        public void updateRecord(R record, IdUpdateListener idUpdateListener, PageCursorTracer cursorTracer) {
            this.actual.updateRecord(record, idUpdateListener, cursorTracer);
        }

        @Override
        public <FAILURE extends Exception> void accept(Processor<FAILURE> processor, R record, PageCursorTracer cursorTracer) throws FAILURE {
            this.actual.accept(processor, record, cursorTracer);
        }

        @Override
        public int getRecordSize() {
            return this.actual.getRecordSize();
        }

        @Override
        public int getRecordDataSize() {
            return this.actual.getRecordDataSize();
        }

        @Override
        public int getRecordsPerPage() {
            return this.actual.getRecordsPerPage();
        }

        @Override
        public int getStoreHeaderInt() {
            return this.actual.getStoreHeaderInt();
        }

        @Override
        public void close() {
            this.actual.close();
        }

        @Override
        public int getNumberOfReservedLowIds() {
            return this.actual.getNumberOfReservedLowIds();
        }

        @Override
        public void flush(PageCursorTracer cursorTracer) {
            this.actual.flush(cursorTracer);
        }

        @Override
        public void ensureHeavy(R record, PageCursorTracer cursorTracer) {
            this.actual.ensureHeavy(record, cursorTracer);
        }

        @Override
        public void prepareForCommit(R record, PageCursorTracer cursorTracer) {
            this.actual.prepareForCommit(record, cursorTracer);
        }

        @Override
        public void prepareForCommit(R record, IdSequence idSequence, PageCursorTracer cursorTracer) {
            this.actual.prepareForCommit(record, idSequence, cursorTracer);
        }

        @Override
        public <EXCEPTION extends Exception> void scanAllRecords(Visitor<R, EXCEPTION> visitor, PageCursorTracer cursorTracer) throws EXCEPTION {
            this.actual.scanAllRecords(visitor, cursorTracer);
        }
    }
}

