/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.logging.LogProvider;

public class RelationshipStore
extends CommonAbstractStore<RelationshipRecord, NoStoreHeader> {
    public static final String TYPE_DESCRIPTOR = "RelationshipStore";

    public RelationshipStore(Path path, Path idFile, Config configuration, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, RecordFormats recordFormats, ImmutableSet<OpenOption> openOptions) {
        super(path, idFile, configuration, IdType.RELATIONSHIP, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, recordFormats.relationship(), NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, recordFormats.storeVersion(), openOptions);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, RelationshipRecord record, PageCursorTracer cursorTracer) throws FAILURE {
        processor.processRelationship(this, record, cursorTracer);
    }
}

