/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.function.Predicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.internal.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreIdIterator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class Scanner {
    private static final String RECORD_STORE_SCANNER_TAG = "recordStoreScanner";

    private Scanner() {
    }

    @SafeVarargs
    public static <R extends AbstractBaseRecord> ResourceIterable<R> scan(RecordStore<R> store, PageCacheTracer pageCacheTracer, Predicate<? super R> ... filters) {
        return Scanner.scan(store, true, pageCacheTracer, filters);
    }

    @SafeVarargs
    public static <R extends AbstractBaseRecord> ResourceIterable<R> scan(RecordStore<R> store, boolean forward, PageCacheTracer pageCacheTracer, Predicate<? super R> ... filters) {
        return () -> new Scan(store, forward, pageCacheTracer, filters);
    }

    private static class Scan<R extends AbstractBaseRecord>
    extends PrefetchingResourceIterator<R> {
        private final LongIterator ids;
        private final RecordStore<R> store;
        private final PageCursor cursor;
        private final R record;
        private final Predicate<? super R>[] filters;
        private final PageCursorTracer cursorTracer;

        @SafeVarargs
        Scan(RecordStore<R> store, boolean forward, PageCacheTracer pageCacheTracer, Predicate<? super R> ... filters) {
            this.filters = filters;
            this.cursorTracer = pageCacheTracer.createPageCursorTracer(Scanner.RECORD_STORE_SCANNER_TAG);
            this.ids = new StoreIdIterator(store, forward, this.cursorTracer);
            this.store = store;
            this.cursor = store.openPageCursorForReading(0L, this.cursorTracer);
            this.record = store.newRecord();
        }

        protected R fetchNextOrNull() {
            while (this.ids.hasNext()) {
                this.store.getRecordByCursor(this.ids.next(), this.record, RecordLoad.FORCE, this.cursor);
                if (!((AbstractBaseRecord)this.record).inUse() || !this.passesFilters(this.record)) continue;
                return this.record;
            }
            return null;
        }

        private boolean passesFilters(R record) {
            for (Predicate<R> predicate : this.filters) {
                if (predicate.test(record)) continue;
                return false;
            }
            return true;
        }

        public void close() {
            this.cursor.close();
            this.cursorTracer.close();
        }
    }
}

