/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.OptionalLong;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorImplementation;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.ConstantIntStoreHeaderFormat;
import org.neo4j.kernel.impl.store.IntStoreHeader;
import org.neo4j.kernel.impl.store.IntStoreHeaderFormat;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.RecordStorageCapability;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.PropertyKeyValue;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class SchemaStore
extends CommonAbstractStore<SchemaRecord, IntStoreHeader> {
    private static final IntStoreHeaderFormat VALID_STORE_HEADER = new IntStoreHeaderFormat(0);
    private static final IntStoreHeaderFormat DISABLED_STORE_HEADER = new ConstantIntStoreHeaderFormat(0);
    public static final String TYPE_DESCRIPTOR = "SchemaStore";
    private final PropertyStore propertyStore;
    private static final String PROP_SCHEMA_RULE_PREFIX = "__org.neo4j.SchemaRule.";
    private static final String PROP_SCHEMA_RULE_TYPE = "__org.neo4j.SchemaRule.schemaRuleType";
    private static final String PROP_INDEX_RULE_TYPE = "__org.neo4j.SchemaRule.indexRuleType";
    private static final String PROP_CONSTRAINT_RULE_TYPE = "__org.neo4j.SchemaRule.constraintRuleType";
    private static final String PROP_SCHEMA_RULE_NAME = "__org.neo4j.SchemaRule.name";
    private static final String PROP_OWNED_INDEX = "__org.neo4j.SchemaRule.ownedIndex";
    private static final String PROP_OWNING_CONSTRAINT = "__org.neo4j.SchemaRule.owningConstraint";
    private static final String PROP_INDEX_PROVIDER_NAME = "__org.neo4j.SchemaRule.indexProviderName";
    private static final String PROP_INDEX_PROVIDER_VERSION = "__org.neo4j.SchemaRule.indexProviderVersion";
    private static final String PROP_SCHEMA_DESCRIPTOR_ENTITY_TYPE = "__org.neo4j.SchemaRule.schemaEntityType";
    private static final String PROP_SCHEMA_DESCRIPTOR_ENTITY_IDS = "__org.neo4j.SchemaRule.schemaEntityIds";
    private static final String PROP_SCHEMA_DESCRIPTOR_PROPERTY_IDS = "__org.neo4j.SchemaRule.schemaPropertyIds";
    private static final String PROP_SCHEMA_DESCRIPTOR_PROPERTY_SCHEMA_TYPE = "__org.neo4j.SchemaRule.schemaPropertySchemaType";
    private static final String PROP_INDEX_TYPE = "__org.neo4j.SchemaRule.indexType";
    private static final String PROP_INDEX_CONFIG_PREFIX = "__org.neo4j.SchemaRule.IndexConfig.";

    public SchemaStore(Path path, Path idFile, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, PropertyStore propertyStore, RecordFormats recordFormats, ImmutableSet<OpenOption> openOptions) {
        super(path, idFile, conf, idType, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, recordFormats.schema(), SchemaStore.getStoreHeaderFormat(recordFormats), recordFormats.storeVersion(), openOptions);
        this.propertyStore = propertyStore;
    }

    private static IntStoreHeaderFormat getStoreHeaderFormat(RecordFormats recordFormats) {
        return recordFormats.hasCapability(RecordStorageCapability.FLEXIBLE_SCHEMA_STORE) ? VALID_STORE_HEADER : DISABLED_STORE_HEADER;
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, SchemaRecord record, PageCursorTracer cursorTracer) throws FAILURE {
        processor.processSchema(this, record, cursorTracer);
    }

    public PropertyStore propertyStore() {
        return this.propertyStore;
    }

    public static int getOwningConstraintPropertyKeyId(TokenHolders tokenHolders) throws KernelException {
        int[] ids = new int[1];
        tokenHolders.propertyKeyTokens().getOrCreateInternalIds(new String[]{PROP_OWNING_CONSTRAINT}, ids);
        return ids[0];
    }

    public static Map<String, Value> mapifySchemaRule(SchemaRule rule) {
        HashMap<String, Value> map = new HashMap<String, Value>();
        SchemaStore.putStringProperty(map, PROP_SCHEMA_RULE_NAME, rule.getName());
        SchemaStore.schemaDescriptorToMap(rule.schema(), map);
        if (rule instanceof IndexDescriptor) {
            SchemaStore.schemaIndexToMap((IndexDescriptor)rule, map);
        } else if (rule instanceof ConstraintDescriptor) {
            SchemaStore.schemaConstraintToMap((ConstraintDescriptor)rule, map);
        }
        return map;
    }

    public static IntObjectMap<Value> convertSchemaRuleToMap(SchemaRule rule, TokenHolders tokenHolders) throws KernelException {
        Map<String, Value> stringlyMap = SchemaStore.mapifySchemaRule(rule);
        int size = stringlyMap.size();
        String[] keys = new String[size];
        int[] keyIds = new int[size];
        Value[] values = new Value[size];
        Iterator<Map.Entry<String, Value>> itr = stringlyMap.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            Map.Entry<String, Value> entry = itr.next();
            keys[i] = entry.getKey();
            values[i] = entry.getValue();
        }
        tokenHolders.propertyKeyTokens().getOrCreateInternalIds(keys, keyIds);
        IntObjectHashMap tokenisedMap = new IntObjectHashMap();
        for (int i = 0; i < size; ++i) {
            tokenisedMap.put(keyIds[i], (Object)values[i]);
        }
        return tokenisedMap;
    }

    private static void schemaDescriptorToMap(SchemaDescriptor schemaDescriptor, Map<String, Value> map) {
        EntityType entityType = schemaDescriptor.entityType();
        PropertySchemaType propertySchemaType = schemaDescriptor.propertySchemaType();
        int[] entityTokenIds = schemaDescriptor.getEntityTokenIds();
        int[] propertyIds = schemaDescriptor.getPropertyIds();
        SchemaStore.putStringProperty(map, PROP_SCHEMA_DESCRIPTOR_ENTITY_TYPE, entityType.name());
        SchemaStore.putStringProperty(map, PROP_SCHEMA_DESCRIPTOR_PROPERTY_SCHEMA_TYPE, propertySchemaType.name());
        SchemaStore.putIntArrayProperty(map, PROP_SCHEMA_DESCRIPTOR_ENTITY_IDS, entityTokenIds);
        SchemaStore.putIntArrayProperty(map, PROP_SCHEMA_DESCRIPTOR_PROPERTY_IDS, propertyIds);
    }

    private static void indexConfigToMap(IndexConfig indexConfig, Map<String, Value> map) {
        RichIterable entries = indexConfig.entries();
        for (Pair entry : entries) {
            SchemaStore.putIndexConfigProperty(map, (String)entry.getOne(), (Value)entry.getTwo());
        }
    }

    private static void schemaIndexToMap(IndexDescriptor rule, Map<String, Value> map) {
        SchemaStore.putStringProperty(map, PROP_SCHEMA_RULE_TYPE, "INDEX");
        IndexType indexType = rule.getIndexType();
        SchemaStore.putStringProperty(map, PROP_INDEX_TYPE, indexType.name());
        if (rule.isUnique()) {
            SchemaStore.putStringProperty(map, PROP_INDEX_RULE_TYPE, "UNIQUE");
            if (rule.getOwningConstraintId().isPresent()) {
                map.put(PROP_OWNING_CONSTRAINT, (Value)Values.longValue((long)rule.getOwningConstraintId().getAsLong()));
            }
        } else {
            SchemaStore.putStringProperty(map, PROP_INDEX_RULE_TYPE, "NON_UNIQUE");
        }
        SchemaStore.indexProviderToMap(rule, map);
        IndexConfig indexConfig = rule.getIndexConfig();
        SchemaStore.indexConfigToMap(indexConfig, map);
    }

    private static void indexProviderToMap(IndexDescriptor rule, Map<String, Value> map) {
        IndexProviderDescriptor provider = rule.getIndexProvider();
        String name = provider.getKey();
        String version = provider.getVersion();
        SchemaStore.putStringProperty(map, PROP_INDEX_PROVIDER_NAME, name);
        SchemaStore.putStringProperty(map, PROP_INDEX_PROVIDER_VERSION, version);
    }

    private static void schemaConstraintToMap(ConstraintDescriptor rule, Map<String, Value> map) {
        SchemaStore.putStringProperty(map, PROP_SCHEMA_RULE_TYPE, "CONSTRAINT");
        ConstraintType type = rule.type();
        switch (type) {
            case UNIQUE: {
                SchemaStore.putStringProperty(map, PROP_CONSTRAINT_RULE_TYPE, "UNIQUE");
                if (!rule.asIndexBackedConstraint().hasOwnedIndexId()) break;
                SchemaStore.putLongProperty(map, PROP_OWNED_INDEX, rule.asIndexBackedConstraint().ownedIndexId());
                break;
            }
            case EXISTS: {
                SchemaStore.putStringProperty(map, PROP_CONSTRAINT_RULE_TYPE, "EXISTS");
                break;
            }
            case UNIQUE_EXISTS: {
                SchemaStore.putStringProperty(map, PROP_CONSTRAINT_RULE_TYPE, "UNIQUE_EXISTS");
                if (!rule.asIndexBackedConstraint().hasOwnedIndexId()) break;
                SchemaStore.putLongProperty(map, PROP_OWNED_INDEX, rule.asIndexBackedConstraint().ownedIndexId());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized constraint type: " + type);
            }
        }
    }

    public static SchemaRule readSchemaRule(SchemaRecord record, PropertyStore propertyStore, TokenHolders tokenHolders, PageCursorTracer cursorTracer) throws MalformedSchemaRuleException {
        Map<String, Value> map = SchemaStore.schemaRecordToMap(record, propertyStore, tokenHolders, cursorTracer);
        return SchemaStore.unmapifySchemaRule(record.getId(), map);
    }

    public static SchemaRule unmapifySchemaRule(long ruleId, Map<String, Value> map) throws MalformedSchemaRuleException {
        String schemaRuleType;
        switch (schemaRuleType = SchemaStore.getString(PROP_SCHEMA_RULE_TYPE, map)) {
            case "INDEX": {
                return SchemaStore.buildIndexRule(ruleId, map);
            }
            case "CONSTRAINT": {
                return SchemaStore.buildConstraintRule(ruleId, map);
            }
        }
        throw new MalformedSchemaRuleException("Can not create a schema rule of type: " + schemaRuleType);
    }

    private static SchemaRule buildIndexRule(long schemaRuleId, Map<String, Value> props) throws MalformedSchemaRuleException {
        SchemaDescriptor schema = SchemaStore.buildSchemaDescriptor(props);
        String indexRuleType = SchemaStore.getString(PROP_INDEX_RULE_TYPE, props);
        boolean unique = SchemaStore.parseIndexType(indexRuleType);
        IndexPrototype prototype = unique ? IndexPrototype.uniqueForSchema((SchemaDescriptor)schema) : IndexPrototype.forSchema((SchemaDescriptor)schema);
        prototype = prototype.withName(SchemaStore.getString(PROP_SCHEMA_RULE_NAME, props));
        prototype = prototype.withIndexType(SchemaStore.getIndexType(SchemaStore.getString(PROP_INDEX_TYPE, props)));
        String providerKey = SchemaStore.getString(PROP_INDEX_PROVIDER_NAME, props);
        String providerVersion = SchemaStore.getString(PROP_INDEX_PROVIDER_VERSION, props);
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor(providerKey, providerVersion);
        prototype = prototype.withIndexProvider(providerDescriptor);
        IndexDescriptor index = prototype.materialise(schemaRuleId);
        IndexConfig indexConfig = SchemaStore.extractIndexConfig(props);
        index = index.withIndexConfig(indexConfig);
        if (props.containsKey(PROP_OWNING_CONSTRAINT)) {
            index = index.withOwningConstraintId(SchemaStore.getLong(PROP_OWNING_CONSTRAINT, props));
        }
        return index;
    }

    private static boolean parseIndexType(String indexRuleType) throws MalformedSchemaRuleException {
        switch (indexRuleType) {
            case "NON_UNIQUE": {
                return false;
            }
            case "UNIQUE": {
                return true;
            }
        }
        throw new MalformedSchemaRuleException("Did not recognize index rule type: " + indexRuleType);
    }

    private static SchemaRule buildConstraintRule(long id, Map<String, Value> props) throws MalformedSchemaRuleException {
        SchemaDescriptor schema = SchemaStore.buildSchemaDescriptor(props);
        String constraintRuleType = SchemaStore.getString(PROP_CONSTRAINT_RULE_TYPE, props);
        String name = SchemaStore.getString(PROP_SCHEMA_RULE_NAME, props);
        OptionalLong ownedIndex = SchemaStore.getOptionalLong(PROP_OWNED_INDEX, props);
        switch (constraintRuleType) {
            case "UNIQUE": {
                UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema);
                if (ownedIndex.isPresent()) {
                    constraint = constraint.withOwnedIndexId(ownedIndex.getAsLong());
                }
                return constraint.withId(id).withName(name);
            }
            case "EXISTS": {
                ConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)schema);
                return constraint.withId(id).withName(name);
            }
            case "UNIQUE_EXISTS": {
                NodeKeyConstraintDescriptor constraint = ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)schema);
                if (ownedIndex.isPresent()) {
                    constraint = constraint.withOwnedIndexId(ownedIndex.getAsLong());
                }
                return constraint.withId(id).withName(name);
            }
        }
        throw new MalformedSchemaRuleException("Did not recognize constraint rule type: " + constraintRuleType);
    }

    private static Map<String, Value> schemaRecordToMap(SchemaRecord record, PropertyStore propertyStore, TokenHolders tokenHolders, PageCursorTracer cursorTracer) throws MalformedSchemaRuleException {
        HashMap<String, Value> props = new HashMap<String, Value>();
        PropertyRecord propRecord = propertyStore.newRecord();
        long nextProp = record.getNextProp();
        while (nextProp != Record.NO_NEXT_PROPERTY.longValue()) {
            try {
                propertyStore.getRecord(nextProp, propRecord, RecordLoad.NORMAL, cursorTracer);
            }
            catch (InvalidRecordException e) {
                throw new MalformedSchemaRuleException("Cannot read schema rule because it is referencing a property record (id " + nextProp + ") that is invalid: " + propRecord, (Throwable)((Object)e));
            }
            for (PropertyBlock propertyBlock : propRecord) {
                PropertyKeyValue propertyKeyValue = propertyBlock.newPropertyKeyValue(propertyStore, cursorTracer);
                SchemaStore.insertPropertyIntoMap(propertyKeyValue, props, tokenHolders);
            }
            nextProp = propRecord.getNextProp();
        }
        return props;
    }

    private static void insertPropertyIntoMap(PropertyKeyValue propertyKeyValue, Map<String, Value> props, TokenHolders tokenHolders) throws MalformedSchemaRuleException {
        try {
            NamedToken propertyKeyTokenName = tokenHolders.propertyKeyTokens().getInternalTokenById(propertyKeyValue.propertyKeyId());
            props.put(propertyKeyTokenName.name(), propertyKeyValue.value());
        }
        catch (InvalidRecordException | TokenNotFoundException e) {
            int id = propertyKeyValue.propertyKeyId();
            throw new MalformedSchemaRuleException("Cannot read schema rule because it is referring to a property key token (id " + id + ") that does not exist.", (Throwable)e);
        }
    }

    private static SchemaDescriptor buildSchemaDescriptor(Map<String, Value> props) throws MalformedSchemaRuleException {
        EntityType entityType = SchemaStore.getEntityType(SchemaStore.getString(PROP_SCHEMA_DESCRIPTOR_ENTITY_TYPE, props));
        PropertySchemaType propertySchemaType = SchemaStore.getPropertySchemaType(SchemaStore.getString(PROP_SCHEMA_DESCRIPTOR_PROPERTY_SCHEMA_TYPE, props));
        int[] entityIds = SchemaStore.getIntArray(PROP_SCHEMA_DESCRIPTOR_ENTITY_IDS, props);
        int[] propertyIds = SchemaStore.getIntArray(PROP_SCHEMA_DESCRIPTOR_PROPERTY_IDS, props);
        return new SchemaDescriptorImplementation(entityType, propertySchemaType, entityIds, propertyIds);
    }

    private static IndexConfig extractIndexConfig(Map<String, Value> props) {
        HashMap<String, Value> configMap = new HashMap<String, Value>();
        for (Map.Entry<String, Value> entry : props.entrySet()) {
            if (!entry.getKey().startsWith(PROP_INDEX_CONFIG_PREFIX)) continue;
            configMap.put(entry.getKey().substring(PROP_INDEX_CONFIG_PREFIX.length()), entry.getValue());
        }
        return IndexConfig.with(configMap);
    }

    private static IndexType getIndexType(String indexType) throws MalformedSchemaRuleException {
        try {
            return IndexType.valueOf((String)indexType);
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException("Did not recognize index type: " + indexType, (Throwable)e);
        }
    }

    private static PropertySchemaType getPropertySchemaType(String propertySchemaType) throws MalformedSchemaRuleException {
        try {
            return PropertySchemaType.valueOf((String)propertySchemaType);
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException("Did not recognize property schema type: " + propertySchemaType, (Throwable)e);
        }
    }

    private static EntityType getEntityType(String entityType) throws MalformedSchemaRuleException {
        try {
            return EntityType.valueOf((String)entityType);
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException("Did not recognize entity type: " + entityType, (Throwable)e);
        }
    }

    private static int[] getIntArray(String property, Map<String, Value> props) throws MalformedSchemaRuleException {
        Value value = props.get(property);
        if (value instanceof IntArray) {
            return (int[])value.asObject();
        }
        throw new MalformedSchemaRuleException("Expected property " + property + " to be a IntArray but was " + value);
    }

    private static long getLong(String property, Map<String, Value> props) throws MalformedSchemaRuleException {
        Value value = props.get(property);
        if (value instanceof LongValue) {
            return ((LongValue)value).value();
        }
        throw new MalformedSchemaRuleException("Expected property " + property + " to be a LongValue but was " + value);
    }

    private static OptionalLong getOptionalLong(String property, Map<String, Value> props) {
        Value value = props.get(property);
        if (value instanceof LongValue) {
            return OptionalLong.of(((LongValue)value).value());
        }
        return OptionalLong.empty();
    }

    private static String getString(String property, Map<String, Value> map) throws MalformedSchemaRuleException {
        Value value = map.get(property);
        if (value instanceof TextValue) {
            return ((TextValue)value).stringValue();
        }
        throw new MalformedSchemaRuleException("Expected property " + property + " to be a TextValue but was " + value);
    }

    private static void putLongProperty(Map<String, Value> map, String property, long value) {
        map.put(property, (Value)Values.longValue((long)value));
    }

    private static void putIntArrayProperty(Map<String, Value> map, String property, int[] value) {
        map.put(property, (Value)Values.intArray((int[])value));
    }

    private static void putStringProperty(Map<String, Value> map, String property, String value) {
        map.put(property, (Value)Values.utf8Value((String)value));
    }

    private static void putIndexConfigProperty(Map<String, Value> map, String key, Value value) {
        map.put(PROP_INDEX_CONFIG_PREFIX + key, value);
    }
}

