/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class StoreAccess {
    public static final StoreType[] ACCESSIBLE_STORE_TYPES;
    private static final Map<StoreType, Function<StoreAccess, RecordStore<?>>> STORE_MAPPINGS;
    private SchemaStore schemaStore;
    private RecordStore<NodeRecord> nodeStore;
    private RecordStore<RelationshipRecord> relStore;
    private RecordStore<RelationshipTypeTokenRecord> relationshipTypeTokenStore;
    private RecordStore<LabelTokenRecord> labelTokenStore;
    private RecordStore<DynamicRecord> nodeDynamicLabelStore;
    private RecordStore<PropertyRecord> propStore;
    private RecordStore<DynamicRecord> stringStore;
    private RecordStore<DynamicRecord> arrayStore;
    private RecordStore<PropertyKeyTokenRecord> propertyKeyTokenStore;
    private RecordStore<DynamicRecord> relationshipTypeNameStore;
    private RecordStore<DynamicRecord> labelNameStore;
    private RecordStore<DynamicRecord> propertyKeyNameStore;
    private RecordStore<RelationshipGroupRecord> relGroupStore;
    private boolean closeable;
    private final NeoStores neoStores;

    public StoreAccess(NeoStores store) {
        this.neoStores = store;
    }

    public StoreAccess(FileSystemAbstraction fileSystem, PageCache pageCache, DatabaseLayout directoryStructure, Config config, PageCacheTracer cacheTracer) {
        this(new StoreFactory(directoryStructure, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fileSystem, RecoveryCleanupWorkCollector.immediate()), pageCache, fileSystem, (LogProvider)NullLogProvider.getInstance(), cacheTracer).openAllNeoStores());
        this.closeable = true;
    }

    public StoreAccess initialize() {
        this.schemaStore = this.neoStores.getSchemaStore();
        this.nodeStore = this.wrapStore(this.neoStores.getNodeStore());
        this.relStore = this.wrapStore(this.neoStores.getRelationshipStore());
        this.propStore = this.wrapStore(this.neoStores.getPropertyStore());
        this.stringStore = this.wrapStore(this.neoStores.getPropertyStore().getStringStore());
        this.arrayStore = this.wrapStore(this.neoStores.getPropertyStore().getArrayStore());
        this.relationshipTypeTokenStore = this.wrapStore(this.neoStores.getRelationshipTypeTokenStore());
        this.labelTokenStore = this.wrapStore(this.neoStores.getLabelTokenStore());
        this.nodeDynamicLabelStore = this.wrapStore(StoreAccess.wrapNodeDynamicLabelStore(this.neoStores.getNodeStore().getDynamicLabelStore()));
        this.propertyKeyTokenStore = this.wrapStore(this.neoStores.getPropertyStore().getPropertyKeyTokenStore());
        this.relationshipTypeNameStore = this.wrapStore(this.neoStores.getRelationshipTypeTokenStore().getNameStore());
        this.labelNameStore = this.wrapStore(this.neoStores.getLabelTokenStore().getNameStore());
        this.propertyKeyNameStore = this.wrapStore(this.neoStores.getPropertyStore().getPropertyKeyTokenStore().getNameStore());
        this.relGroupStore = this.wrapStore(this.neoStores.getRelationshipGroupStore());
        return this;
    }

    public NeoStores getRawNeoStores() {
        return this.neoStores;
    }

    public SchemaStore getSchemaStore() {
        return this.schemaStore;
    }

    public RecordStore<NodeRecord> getNodeStore() {
        return this.nodeStore;
    }

    public RecordStore<RelationshipRecord> getRelationshipStore() {
        return this.relStore;
    }

    public RecordStore<RelationshipGroupRecord> getRelationshipGroupStore() {
        return this.relGroupStore;
    }

    public RecordStore<PropertyRecord> getPropertyStore() {
        return this.propStore;
    }

    public RecordStore<DynamicRecord> getStringStore() {
        return this.stringStore;
    }

    public RecordStore<DynamicRecord> getArrayStore() {
        return this.arrayStore;
    }

    public RecordStore<RelationshipTypeTokenRecord> getRelationshipTypeTokenStore() {
        return this.relationshipTypeTokenStore;
    }

    public RecordStore<LabelTokenRecord> getLabelTokenStore() {
        return this.labelTokenStore;
    }

    public RecordStore<DynamicRecord> getNodeDynamicLabelStore() {
        return this.nodeDynamicLabelStore;
    }

    public RecordStore<PropertyKeyTokenRecord> getPropertyKeyTokenStore() {
        return this.propertyKeyTokenStore;
    }

    public RecordStore<DynamicRecord> getRelationshipTypeNameStore() {
        return this.relationshipTypeNameStore;
    }

    public RecordStore<DynamicRecord> getLabelNameStore() {
        return this.labelNameStore;
    }

    public RecordStore<DynamicRecord> getPropertyKeyNameStore() {
        return this.propertyKeyNameStore;
    }

    public <T extends AbstractBaseRecord> RecordStore<T> getStore(StoreType type) {
        return STORE_MAPPINGS.get((Object)type).apply(this);
    }

    private static RecordStore<DynamicRecord> wrapNodeDynamicLabelStore(RecordStore<DynamicRecord> store) {
        return new RecordStore.Delegator<DynamicRecord>(store){

            @Override
            public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, DynamicRecord record, PageCursorTracer cursorTracer) throws FAILURE {
                processor.processLabelArrayWithOwner(this, record, cursorTracer);
            }
        };
    }

    protected <R extends AbstractBaseRecord> RecordStore<R> wrapStore(RecordStore<R> store) {
        return store;
    }

    public synchronized void close() {
        if (this.closeable) {
            this.closeable = false;
            this.neoStores.close();
        }
    }

    static {
        STORE_MAPPINGS = new HashMap();
        STORE_MAPPINGS.put(StoreType.SCHEMA, StoreAccess::getSchemaStore);
        STORE_MAPPINGS.put(StoreType.NODE, StoreAccess::getNodeStore);
        STORE_MAPPINGS.put(StoreType.LABEL_TOKEN, StoreAccess::getLabelTokenStore);
        STORE_MAPPINGS.put(StoreType.NODE_LABEL, StoreAccess::getNodeDynamicLabelStore);
        STORE_MAPPINGS.put(StoreType.RELATIONSHIP, StoreAccess::getRelationshipStore);
        STORE_MAPPINGS.put(StoreType.RELATIONSHIP_GROUP, StoreAccess::getRelationshipGroupStore);
        STORE_MAPPINGS.put(StoreType.PROPERTY, StoreAccess::getPropertyStore);
        STORE_MAPPINGS.put(StoreType.PROPERTY_STRING, StoreAccess::getStringStore);
        STORE_MAPPINGS.put(StoreType.PROPERTY_ARRAY, StoreAccess::getArrayStore);
        STORE_MAPPINGS.put(StoreType.RELATIONSHIP_TYPE_TOKEN, StoreAccess::getRelationshipTypeTokenStore);
        STORE_MAPPINGS.put(StoreType.PROPERTY_KEY_TOKEN, StoreAccess::getPropertyKeyTokenStore);
        ACCESSIBLE_STORE_TYPES = STORE_MAPPINGS.keySet().toArray(new StoreType[0]);
    }
}

