/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Objects;
import java.util.Optional;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;

public enum StoreType {
    NODE_LABEL(DatabaseFile.NODE_LABEL_STORE, IdType.NODE_LABELS){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, PageCursorTracer cursorTracer) {
            return neoStores.createNodeLabelStore(cursorTracer);
        }
    }
    ,
    NODE(DatabaseFile.NODE_STORE, IdType.NODE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, PageCursorTracer cursorTracer) {
            return neoStores.createNodeStore(cursorTracer);
        }
    }
    ,
    PROPERTY_KEY_TOKEN_NAME(DatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, IdType.PROPERTY_KEY_TOKEN_NAME){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, PageCursorTracer cursorTracer) {
            return neoStores.createPropertyKeyTokenNamesStore(cursorTracer);
        }
    }
    ,
    PROPERTY_KEY_TOKEN(DatabaseFile.PROPERTY_KEY_TOKEN_STORE, IdType.PROPERTY_KEY_TOKEN){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, PageCursorTracer cursorTracer) {
            return neoStores.createPropertyKeyTokenStore(cursorTracer);
        }
    }
    ,
    PROPERTY_STRING(DatabaseFile.PROPERTY_STRING_STORE, IdType.STRING_BLOCK){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, PageCursorTracer cursorTracer) {
            return neoStores.createPropertyStringStore(cursorTracer);
        }
    }
    ,
    PROPERTY_ARRAY(DatabaseFile.PROPERTY_ARRAY_STORE, IdType.ARRAY_BLOCK){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, PageCursorTracer cursorTracer) {
            return neoStores.createPropertyArrayStore(cursorTracer);
        }
    }
    ,
    PROPERTY(DatabaseFile.PROPERTY_STORE, IdType.PROPERTY){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, PageCursorTracer cursorTracer) {
            return neoStores.createPropertyStore(cursorTracer);
        }
    }
    ,
    RELATIONSHIP(DatabaseFile.RELATIONSHIP_STORE, IdType.RELATIONSHIP){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, PageCursorTracer cursorTracer) {
            return neoStores.createRelationshipStore(cursorTracer);
        }
    }
    ,
    RELATIONSHIP_TYPE_TOKEN_NAME(DatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, IdType.RELATIONSHIP_TYPE_TOKEN_NAME){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, PageCursorTracer cursorTracer) {
            return neoStores.createRelationshipTypeTokenNamesStore(cursorTracer);
        }
    }
    ,
    RELATIONSHIP_TYPE_TOKEN(DatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, IdType.RELATIONSHIP_TYPE_TOKEN){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, PageCursorTracer cursorTracer) {
            return neoStores.createRelationshipTypeTokenStore(cursorTracer);
        }
    }
    ,
    LABEL_TOKEN_NAME(DatabaseFile.LABEL_TOKEN_NAMES_STORE, IdType.LABEL_TOKEN_NAME){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, PageCursorTracer cursorTracer) {
            return neoStores.createLabelTokenNamesStore(cursorTracer);
        }
    }
    ,
    LABEL_TOKEN(DatabaseFile.LABEL_TOKEN_STORE, IdType.LABEL_TOKEN){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, PageCursorTracer cursorTracer) {
            return neoStores.createLabelTokenStore(cursorTracer);
        }
    }
    ,
    SCHEMA(DatabaseFile.SCHEMA_STORE, IdType.SCHEMA){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, PageCursorTracer cursorTracer) {
            return neoStores.createSchemaStore(cursorTracer);
        }
    }
    ,
    RELATIONSHIP_GROUP(DatabaseFile.RELATIONSHIP_GROUP_STORE, IdType.RELATIONSHIP_GROUP){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, PageCursorTracer cursorTracer) {
            return neoStores.createRelationshipGroupStore(cursorTracer);
        }
    }
    ,
    META_DATA(DatabaseFile.METADATA_STORE, IdType.NEOSTORE_BLOCK){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, PageCursorTracer cursorTracer) {
            return neoStores.createMetadataStore(cursorTracer);
        }
    };

    private final DatabaseFile databaseFile;
    private final IdType idType;

    private StoreType(DatabaseFile databaseFile, IdType idType) {
        this.databaseFile = databaseFile;
        this.idType = idType;
    }

    abstract CommonAbstractStore open(NeoStores var1, PageCursorTracer var2);

    public DatabaseFile getDatabaseFile() {
        return this.databaseFile;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public static Optional<StoreType> typeOf(DatabaseFile databaseFile) {
        StoreType[] values;
        Objects.requireNonNull(databaseFile);
        for (StoreType value : values = StoreType.values()) {
            if (!value.getDatabaseFile().equals((Object)databaseFile)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

