/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.configuration.Config;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.IdUpdateListener;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.token.api.NamedToken;

public abstract class TokenStore<RECORD extends TokenRecord>
extends CommonAbstractStore<RECORD, NoStoreHeader> {
    public static final int NAME_STORE_BLOCK_SIZE = 30;
    private final DynamicStringStore nameStore;

    public TokenStore(Path path, Path idFile, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, DynamicStringStore nameStore, String typeDescriptor, RecordFormat<RECORD> recordFormat, String storeVersion, ImmutableSet<OpenOption> openOptions) {
        super(path, idFile, configuration, idType, idGeneratorFactory, pageCache, logProvider, typeDescriptor, recordFormat, NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, storeVersion, openOptions);
        this.nameStore = nameStore;
    }

    public DynamicStringStore getNameStore() {
        return this.nameStore;
    }

    public List<NamedToken> getTokens(PageCursorTracer cursorTracer) {
        return this.readAllTokens(false, cursorTracer);
    }

    public List<NamedToken> getAllReadableTokens(PageCursorTracer cursorTracer) {
        return this.readAllTokens(true, cursorTracer);
    }

    private List<NamedToken> readAllTokens(boolean ignoreInconsistentTokens, PageCursorTracer cursorTracer) {
        long highId = this.getHighId();
        ArrayList<NamedToken> records = new ArrayList<NamedToken>();
        records.ensureCapacity(Math.toIntExact(highId));
        TokenRecord record = (TokenRecord)this.newRecord();
        int i = 0;
        while ((long)i < highId) {
            block4: {
                if (this.getRecord(i, record, RecordLoad.LENIENT_CHECK, cursorTracer).inUse() && record.getNameId() != Record.RESERVED.intValue()) {
                    try {
                        String name = this.getStringFor(record, cursorTracer);
                        records.add(new NamedToken(name, i, record.isInternal()));
                    }
                    catch (Exception e) {
                        if (ignoreInconsistentTokens) break block4;
                        throw e;
                    }
                }
            }
            ++i;
        }
        return records;
    }

    public NamedToken getToken(int id, PageCursorTracer cursorTracer) {
        TokenRecord record = this.getRecord(id, (TokenRecord)this.newRecord(), RecordLoad.NORMAL, cursorTracer);
        return new NamedToken(this.getStringFor(record, cursorTracer), record.getIntId(), record.isInternal());
    }

    public Collection<DynamicRecord> allocateNameRecords(byte[] chars, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        HeapTrackingArrayList records = HeapTrackingCollections.newArrayList((MemoryTracker)memoryTracker);
        this.nameStore.allocateRecordsFromBytes((Collection<DynamicRecord>)records, chars, cursorTracer, memoryTracker);
        return records;
    }

    @Override
    public void updateRecord(RECORD record, IdUpdateListener idUpdateListener, PageCursorTracer cursorTracer) {
        super.updateRecord(record, idUpdateListener, cursorTracer);
        if (!((TokenRecord)record).isLight()) {
            for (DynamicRecord keyRecord : ((TokenRecord)record).getNameRecords()) {
                this.nameStore.updateRecord(keyRecord, idUpdateListener, cursorTracer);
            }
        }
    }

    @Override
    public void ensureHeavy(RECORD record, PageCursorTracer cursorTracer) {
        if (!((TokenRecord)record).isLight()) {
            return;
        }
        ((TokenRecord)record).addNameRecords(this.nameStore.getRecords(((TokenRecord)record).getNameId(), RecordLoad.NORMAL, true, cursorTracer));
    }

    public String getStringFor(RECORD nameRecord, PageCursorTracer cursorTracer) {
        this.ensureHeavy(nameRecord, cursorTracer);
        int recordToFind = ((TokenRecord)nameRecord).getNameId();
        Iterator<DynamicRecord> records = ((TokenRecord)nameRecord).getNameRecords().iterator();
        ArrayList<DynamicRecord> relevantRecords = new ArrayList<DynamicRecord>();
        while (recordToFind != Record.NO_NEXT_BLOCK.intValue() && records.hasNext()) {
            DynamicRecord record = records.next();
            if (!record.inUse() || record.getId() != (long)recordToFind) continue;
            recordToFind = (int)record.getNextBlock();
            relevantRecords.add(record);
            records = ((TokenRecord)nameRecord).getNameRecords().iterator();
        }
        return PropertyStore.decodeString((byte[])this.nameStore.readFullByteArray(relevantRecords, PropertyType.STRING, cursorTracer).other());
    }
}

