/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.allocator;

import java.util.Collection;
import java.util.Iterator;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsAllocator;
import org.neo4j.kernel.impl.store.record.DynamicRecord;

public class ReusableRecordsCompositeAllocator
implements DynamicRecordAllocator {
    private final ReusableRecordsAllocator reusableRecordsAllocator;
    private final DynamicRecordAllocator recordAllocator;

    public ReusableRecordsCompositeAllocator(Collection<DynamicRecord> records, DynamicRecordAllocator recordAllocator) {
        this(records.iterator(), recordAllocator);
    }

    public ReusableRecordsCompositeAllocator(Iterator<DynamicRecord> recordsIterator, DynamicRecordAllocator recordAllocator) {
        this.reusableRecordsAllocator = new ReusableRecordsAllocator(recordAllocator.getRecordDataSize(), recordsIterator);
        this.recordAllocator = recordAllocator;
    }

    @Override
    public int getRecordDataSize() {
        return this.recordAllocator.getRecordDataSize();
    }

    @Override
    public DynamicRecord nextRecord(PageCursorTracer cursorTracer) {
        return this.reusableRecordsAllocator.hasNext() ? this.reusableRecordsAllocator.nextRecord(cursorTracer) : this.recordAllocator.nextRecord(cursorTracer);
    }
}

