/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.MetaDataRecordFormat;
import org.neo4j.kernel.impl.store.format.standard.NoRecordFormat;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.storageengine.api.format.Capability;
import org.neo4j.storageengine.api.format.CapabilityType;

public abstract class BaseRecordFormats
implements RecordFormats {
    private final int generation;
    private final Capability[] capabilities;
    private final String storeVersion;
    private final String introductionVersion;

    protected BaseRecordFormats(String storeVersion, String introductionVersion, int generation, Capability ... capabilities) {
        this.storeVersion = storeVersion;
        this.generation = generation;
        this.capabilities = capabilities;
        this.introductionVersion = introductionVersion;
    }

    @Override
    public String storeVersion() {
        return this.storeVersion;
    }

    @Override
    public String introductionVersion() {
        return this.introductionVersion;
    }

    @Override
    public RecordFormat<MetaDataRecord> metaData() {
        return new MetaDataRecordFormat();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RecordFormats)) {
            return false;
        }
        RecordFormats other = (RecordFormats)obj;
        return this.node().equals(other.node()) && this.relationship().equals(other.relationship()) && this.relationshipGroup().equals(other.relationshipGroup()) && this.property().equals(other.property()) && this.labelToken().equals(other.labelToken()) && this.relationshipTypeToken().equals(other.relationshipTypeToken()) && this.propertyKeyToken().equals(other.propertyKeyToken()) && this.dynamic().equals(other.dynamic());
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 31 * hashCode + this.node().hashCode();
        hashCode = 31 * hashCode + this.relationship().hashCode();
        hashCode = 31 * hashCode + this.relationshipGroup().hashCode();
        hashCode = 31 * hashCode + this.property().hashCode();
        hashCode = 31 * hashCode + this.labelToken().hashCode();
        hashCode = 31 * hashCode + this.relationshipTypeToken().hashCode();
        hashCode = 31 * hashCode + this.propertyKeyToken().hashCode();
        hashCode = 31 * hashCode + this.dynamic().hashCode();
        return hashCode;
    }

    public String toString() {
        return "RecordFormat:" + this.getClass().getSimpleName() + "[" + this.storeVersion() + "]";
    }

    @Override
    public int generation() {
        return this.generation;
    }

    @Override
    public Capability[] capabilities() {
        return this.capabilities;
    }

    @Override
    public boolean hasCapability(Capability capability) {
        return ArrayUtil.contains((Object[])this.capabilities(), (Object)capability);
    }

    public static boolean hasCompatibleCapabilities(RecordFormats one, RecordFormats other, CapabilityType type) {
        Set otherFormatCapabilities;
        Set myFormatCapabilities = Stream.of(one.capabilities()).filter(capability -> capability.isType(type)).collect(Collectors.toSet());
        if (myFormatCapabilities.equals(otherFormatCapabilities = Stream.of(other.capabilities()).filter(capability -> capability.isType(type)).collect(Collectors.toSet()))) {
            return true;
        }
        boolean capabilitiesNotRemoved = otherFormatCapabilities.containsAll(myFormatCapabilities);
        otherFormatCapabilities.removeAll(myFormatCapabilities);
        boolean allAddedAreAdditive = otherFormatCapabilities.stream().allMatch(Capability::isAdditive);
        return capabilitiesNotRemoved && allAddedAreAdditive;
    }

    @Override
    public boolean hasCompatibleCapabilities(RecordFormats other, CapabilityType type) {
        return BaseRecordFormats.hasCompatibleCapabilities(this, other, type);
    }

    @Override
    public RecordFormat<SchemaRecord> schema() {
        return new NoRecordFormat<SchemaRecord>();
    }
}

