/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;

public abstract class TokenRecord
extends AbstractBaseRecord {
    private int nameId;
    private List<DynamicRecord> nameRecords;
    private boolean internal;

    public TokenRecord(long id) {
        super(id);
    }

    public TokenRecord(TokenRecord other) {
        super(other);
        this.nameId = other.nameId;
        this.nameRecords = new ArrayList<DynamicRecord>(other.nameRecords.size());
        for (DynamicRecord record : other.nameRecords) {
            this.nameRecords.add(new DynamicRecord(record));
        }
        this.internal = other.internal;
    }

    public TokenRecord initialize(boolean inUse, int nameId) {
        super.initialize(inUse);
        this.nameId = nameId;
        this.nameRecords = new ArrayList<DynamicRecord>(1);
        return this;
    }

    @Override
    public void clear() {
        this.initialize(false, Record.NO_NEXT_BLOCK.intValue());
    }

    public boolean isLight() {
        return this.nameRecords == null || this.nameRecords.isEmpty();
    }

    public int getNameId() {
        return this.nameId;
    }

    public void setNameId(int blockId) {
        this.nameId = blockId;
    }

    public Collection<DynamicRecord> getNameRecords() {
        return this.nameRecords;
    }

    public void addNameRecord(DynamicRecord record) {
        this.nameRecords.add(record);
    }

    public void addNameRecords(Iterable<DynamicRecord> records) {
        for (DynamicRecord record : records) {
            this.addNameRecord(record);
        }
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenRecord that = (TokenRecord)o;
        return this.getNameId() == that.getNameId() && this.isInternal() == that.isInternal() && Objects.equals(this.getNameRecords(), that.getNameRecords());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNameId(), this.getNameRecords(), this.isInternal());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(this.simpleName()).append('[');
        buf.append(this.getId()).append(',').append(this.inUse() ? "in" : "no").append(" use");
        buf.append(",nameId=").append(this.nameId);
        buf.append(",internal=").append(this.internal);
        this.additionalToString(buf);
        if (!this.isLight()) {
            for (DynamicRecord dyn : this.nameRecords) {
                buf.append(',').append(dyn);
            }
        }
        return buf.append(']').toString();
    }

    protected abstract String simpleName();

    protected void additionalToString(StringBuilder buf) {
    }
}

