/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.OpenOption;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.ScanOnOpenReadOnlyIdGeneratorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

class DirectRecordStoreMigrator {
    private static final String DIRECT_STORE_MIGRATOR_TAG = "directStoreMigrator";
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final Config config;
    private final PageCacheTracer cacheTracer;

    DirectRecordStoreMigrator(PageCache pageCache, FileSystemAbstraction fs, Config config, PageCacheTracer cacheTracer) {
        this.pageCache = pageCache;
        this.fs = fs;
        this.config = config;
        this.cacheTracer = cacheTracer;
    }

    public void migrate(DatabaseLayout fromDirectoryStructure, RecordFormats fromFormat, DatabaseLayout toDirectoryStructure, RecordFormats toFormat, ProgressReporter progressReporter, StoreType[] types, StoreType ... additionalTypesToOpen) throws IOException {
        StoreType[] storesToOpen = (StoreType[])ArrayUtil.concat((Object[])types, (Object[])additionalTypesToOpen);
        progressReporter.start((long)storesToOpen.length);
        try (NeoStores fromStores = new StoreFactory(fromDirectoryStructure, this.config, (IdGeneratorFactory)new ScanOnOpenReadOnlyIdGeneratorFactory(), this.pageCache, this.fs, fromFormat, (LogProvider)NullLogProvider.getInstance(), this.cacheTracer, (ImmutableSet<OpenOption>)Sets.immutable.empty()).openNeoStores(true, storesToOpen);
             NeoStores toStores = new StoreFactory(toDirectoryStructure, this.withPersistedStoreHeadersAsConfigFrom(fromStores, storesToOpen), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs, RecoveryCleanupWorkCollector.immediate()), this.pageCache, this.fs, toFormat, (LogProvider)NullLogProvider.getInstance(), this.cacheTracer, (ImmutableSet<OpenOption>)Sets.immutable.empty()).openNeoStores(true, storesToOpen);
             PageCursorTracer cursorTracer = this.cacheTracer.createPageCursorTracer(DIRECT_STORE_MIGRATOR_TAG);){
            toStores.start(cursorTracer);
            for (StoreType type : types) {
                DirectRecordStoreMigrator.migrate(fromStores.getRecordStore(type), toStores.getRecordStore(type), cursorTracer);
                progressReporter.progress(1L);
            }
        }
    }

    private static <RECORD extends AbstractBaseRecord> void migrate(RecordStore<RECORD> from, RecordStore<RECORD> to, PageCursorTracer cursorTracer) {
        to.setHighestPossibleIdInUse(from.getHighestPossibleIdInUse(cursorTracer));
        from.scanAllRecords(record -> {
            to.prepareForCommit(record, cursorTracer);
            to.updateRecord(record, cursorTracer);
            return false;
        }, cursorTracer);
    }

    private Config withPersistedStoreHeadersAsConfigFrom(NeoStores legacyStores, StoreType[] types) {
        if (ArrayUtil.contains((Object[])types, (Object)((Object)StoreType.RELATIONSHIP_GROUP))) {
            this.config.set(GraphDatabaseSettings.dense_node_threshold, (Object)legacyStores.getRelationshipGroupStore().getStoreHeaderInt());
        }
        if (ArrayUtil.contains((Object[])types, (Object)((Object)StoreType.PROPERTY))) {
            this.config.set(GraphDatabaseInternalSettings.array_block_size, (Object)legacyStores.getPropertyStore().getArrayStore().getRecordDataSize());
            this.config.set(GraphDatabaseInternalSettings.string_block_size, (Object)legacyStores.getPropertyStore().getStringStore().getRecordDataSize());
        }
        if (ArrayUtil.contains((Object[])types, (Object)((Object)StoreType.NODE_LABEL))) {
            this.config.set(GraphDatabaseInternalSettings.label_block_size, (Object)legacyStores.getNodeStore().getDynamicLabelStore().getRecordDataSize());
        }
        return this.config;
    }
}

