/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.common.EntityType;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.BatchImporter;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.ImportLogic;
import org.neo4j.internal.batchimport.InputIterable;
import org.neo4j.internal.batchimport.InputIterator;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.InputChunk;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.batchimport.staging.CoarseBoundedProgressExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionSupervisors;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.ScanOnOpenOverwritingIdGeneratorFactory;
import org.neo4j.internal.id.ScanOnOpenReadOnlyIdGeneratorFactory;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.internal.recordstorage.RecordNodeCursor;
import org.neo4j.internal.recordstorage.RecordStorageEngineFactory;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.RecordStorageCapability;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.DirectRecordStoreMigrator;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.IdGeneratorMigrator;
import org.neo4j.kernel.impl.storemigration.SchemaStorage;
import org.neo4j.kernel.impl.storemigration.StoreMigratorFileOperation;
import org.neo4j.kernel.impl.storemigration.StoreScanAsInputIterator;
import org.neo4j.kernel.impl.storemigration.StoreScanChunk;
import org.neo4j.kernel.impl.storemigration.legacy.SchemaStorage35;
import org.neo4j.kernel.impl.storemigration.legacy.SchemaStore35;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;
import org.neo4j.kernel.impl.transaction.log.files.RangeLogVersionVisitor;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.LogFilesInitializer;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.format.CapabilityType;
import org.neo4j.storageengine.migration.AbstractStoreMigrationParticipant;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccess;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;

public class RecordStorageMigrator
extends AbstractStoreMigrationParticipant {
    private static final char TX_LOG_COUNTERS_SEPARATOR = 'A';
    private static final String RECORD_STORAGE_MIGRATION_TAG = "recordStorageMigration";
    private static final String NODE_CHUNK_MIGRATION_TAG = "nodeChunkMigration";
    private static final String RELATIONSHIP_CHUNK_MIGRATION_TAG = "relationshipChunkMigration";
    private final Config config;
    private final LogService logService;
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private final JobScheduler jobScheduler;
    private final PageCacheTracer cacheTracer;
    private final BatchImporterFactory batchImporterFactory;
    private final MemoryTracker memoryTracker;

    public RecordStorageMigrator(FileSystemAbstraction fileSystem, PageCache pageCache, Config config, LogService logService, JobScheduler jobScheduler, PageCacheTracer cacheTracer, BatchImporterFactory batchImporterFactory, MemoryTracker memoryTracker) {
        super("Store files");
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.config = config;
        this.logService = logService;
        this.jobScheduler = jobScheduler;
        this.cacheTracer = cacheTracer;
        this.batchImporterFactory = batchImporterFactory;
        this.memoryTracker = memoryTracker;
    }

    public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progressReporter, String versionToMigrateFrom, String versionToMigrateTo) throws IOException, KernelException {
        Path neoStore = directoryLayout.metadataStore();
        try (PageCursorTracer cursorTracer = this.cacheTracer.createPageCursorTracer(RECORD_STORAGE_MIGRATION_TAG);){
            long lastTxId = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID, cursorTracer);
            TransactionId lastTxInfo = this.extractTransactionIdInformation(neoStore, lastTxId, cursorTracer);
            LogPosition lastTxLogPosition = this.extractTransactionLogPosition(neoStore, directoryLayout, lastTxId, cursorTracer);
            long checkpointLogVersion = this.extractCheckpointLogVersion(neoStore, directoryLayout, lastTxLogPosition, cursorTracer);
            this.writeLastTxInformation(migrationLayout, lastTxInfo);
            this.writeLastTxLogPosition(migrationLayout, lastTxLogPosition);
            if (versionToMigrateFrom.equals("vE.H.0")) {
                versionToMigrateFrom = "vE.H.0b";
            }
            RecordFormats oldFormat = RecordFormatSelector.selectForVersion(versionToMigrateFrom);
            RecordFormats newFormat = RecordFormatSelector.selectForVersion(versionToMigrateTo);
            boolean requiresDynamicStoreMigration = !newFormat.dynamic().equals(oldFormat.dynamic());
            boolean requiresPropertyMigration = !newFormat.property().equals(oldFormat.property()) || requiresDynamicStoreMigration;
            boolean requiresIdFilesMigration = IdGeneratorMigrator.requiresIdFilesMigration(oldFormat, newFormat);
            if (FormatFamily.isHigherFamilyFormat(newFormat, oldFormat) || FormatFamily.isSameFamily(oldFormat, newFormat) && RecordStorageMigrator.isDifferentCapabilities(oldFormat, newFormat)) {
                this.migrateWithBatchImporter(directoryLayout, migrationLayout, lastTxId, lastTxInfo.checksum(), lastTxLogPosition.getLogVersion(), lastTxLogPosition.getByteOffset(), checkpointLogVersion, progressReporter, oldFormat, newFormat, requiresDynamicStoreMigration, requiresPropertyMigration);
            }
            LogPosition logPosition = this.readLastTxLogPosition(migrationLayout);
            this.updateOrAddNeoStoreFieldsAsPartOfMigration(migrationLayout, directoryLayout, versionToMigrateTo, logPosition, requiresIdFilesMigration, cursorTracer);
            if (this.requiresSchemaStoreMigration(oldFormat, newFormat) || requiresPropertyMigration) {
                List<DatabaseFile> databaseFiles = Arrays.asList(DatabaseFile.PROPERTY_STORE, DatabaseFile.PROPERTY_ARRAY_STORE, DatabaseFile.PROPERTY_STRING_STORE, DatabaseFile.PROPERTY_KEY_TOKEN_STORE, DatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, DatabaseFile.LABEL_TOKEN_STORE, DatabaseFile.LABEL_TOKEN_NAMES_STORE, DatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, DatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE);
                StoreMigratorFileOperation.fileOperation(FileOperation.COPY, this.fileSystem, directoryLayout, migrationLayout, databaseFiles, true, !requiresIdFilesMigration, ExistingTargetStrategy.SKIP);
                this.migrateSchemaStore(directoryLayout, migrationLayout, oldFormat, newFormat, cursorTracer, this.memoryTracker);
            }
            if (this.requiresCountsStoreMigration(oldFormat, newFormat)) {
                this.migrateCountsStore(directoryLayout, migrationLayout, oldFormat, cursorTracer, this.memoryTracker);
            }
        }
    }

    private void migrateCountsStore(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, RecordFormats oldFormat, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) throws IOException {
        StoreFactory oldStoreFactory = this.createStoreFactory(directoryLayout, oldFormat, (IdGeneratorFactory)new ScanOnOpenReadOnlyIdGeneratorFactory());
        try (NeoStores oldStores = oldStoreFactory.openAllNeoStores();
             GBPTreeCountsStore countsStore = new GBPTreeCountsStore(this.pageCache, migrationLayout.countStore(), this.fileSystem, RecoveryCleanupWorkCollector.immediate(), new CountsComputer(oldStores, this.pageCache, this.cacheTracer, directoryLayout, memoryTracker, this.logService.getInternalLog(((Object)((Object)this)).getClass())), false, this.cacheTracer, GBPTreeCountsStore.NO_MONITOR);){
            countsStore.start(cursorTracer, memoryTracker);
            countsStore.checkpoint(IOLimiter.UNLIMITED, cursorTracer);
        }
    }

    private boolean requiresCountsStoreMigration(RecordFormats oldFormat, RecordFormats newFormat) {
        return !oldFormat.hasCapability(RecordStorageCapability.GBPTREE_COUNTS_STORE) && newFormat.hasCapability(RecordStorageCapability.GBPTREE_COUNTS_STORE);
    }

    private static boolean isDifferentCapabilities(RecordFormats oldFormat, RecordFormats newFormat) {
        return !oldFormat.hasCompatibleCapabilities(newFormat, CapabilityType.FORMAT);
    }

    void writeLastTxInformation(DatabaseLayout migrationStructure, TransactionId txInfo) throws IOException {
        RecordStorageMigrator.writeTxLogCounters(this.fileSystem, RecordStorageMigrator.lastTxInformationFile(migrationStructure), txInfo.transactionId(), txInfo.checksum(), txInfo.commitTimestamp());
    }

    void writeLastTxLogPosition(DatabaseLayout migrationStructure, LogPosition lastTxLogPosition) throws IOException {
        RecordStorageMigrator.writeTxLogCounters(this.fileSystem, RecordStorageMigrator.lastTxLogPositionFile(migrationStructure), lastTxLogPosition.getLogVersion(), lastTxLogPosition.getByteOffset());
    }

    TransactionId readLastTxInformation(DatabaseLayout migrationStructure) throws IOException {
        long[] counters = RecordStorageMigrator.readTxLogCounters(this.fileSystem, RecordStorageMigrator.lastTxInformationFile(migrationStructure), 3);
        return new TransactionId(counters[0], (int)counters[1], counters[2]);
    }

    LogPosition readLastTxLogPosition(DatabaseLayout migrationStructure) throws IOException {
        long[] counters = RecordStorageMigrator.readTxLogCounters(this.fileSystem, RecordStorageMigrator.lastTxLogPositionFile(migrationStructure), 2);
        return new LogPosition(counters[0], counters[1]);
    }

    private static void writeTxLogCounters(FileSystemAbstraction fs, Path path, long ... counters) throws IOException {
        try (Writer writer = fs.openAsWriter(path, StandardCharsets.UTF_8, false);){
            writer.write(StringUtils.join((long[])counters, (char)'A'));
        }
    }

    private static long[] readTxLogCounters(FileSystemAbstraction fs, Path path, int numberOfCounters) throws IOException {
        try (Reader reader = fs.openAsReader(path, StandardCharsets.UTF_8);){
            String line = IOUtils.lineIterator((Reader)reader).next();
            String[] split = StringUtils.split((String)line, (char)'A');
            if (split.length != numberOfCounters) {
                throw new IllegalArgumentException("Unexpected number of tx counters '" + numberOfCounters + "', file contains: '" + line + "'");
            }
            long[] counters = new long[numberOfCounters];
            for (int i = 0; i < split.length; ++i) {
                counters[i] = Long.parseLong(split[i]);
            }
            long[] lArray = counters;
            return lArray;
        }
    }

    private static Path lastTxInformationFile(DatabaseLayout migrationStructure) {
        return migrationStructure.file("lastxinformation");
    }

    private static Path lastTxLogPositionFile(DatabaseLayout migrationStructure) {
        return migrationStructure.file("lastxlogposition");
    }

    TransactionId extractTransactionIdInformation(Path neoStore, long lastTransactionId, PageCursorTracer cursorTracer) throws IOException {
        int checksum = (int)MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, cursorTracer);
        long commitTimestamp = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, cursorTracer);
        if ((long)checksum != -1L && commitTimestamp != -1L) {
            return new TransactionId(lastTransactionId, checksum, commitTimestamp);
        }
        return RecordStorageMigrator.specificTransactionInformationSupplier(lastTransactionId);
    }

    long extractCheckpointLogVersion(Path neoStore, DatabaseLayout directoryLayout, LogPosition txLogPosition, PageCursorTracer cursorTracer) throws IOException {
        long checkpointLogVersion = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.CHECKPOINT_LOG_VERSION, cursorTracer);
        if (checkpointLogVersion != -1L) {
            return checkpointLogVersion;
        }
        return txLogPosition.getLogVersion();
    }

    private static TransactionId specificTransactionInformationSupplier(long lastTransactionId) {
        return lastTransactionId == 1L ? new TransactionId(lastTransactionId, -559063315, 0L) : new TransactionId(lastTransactionId, 1, 1L);
    }

    LogPosition extractTransactionLogPosition(Path neoStore, DatabaseLayout sourceDirectoryStructure, long lastTxId, PageCursorTracer cursorTracer) throws IOException {
        long lastClosedTxLogVersion = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, cursorTracer);
        long lastClosedTxLogByteOffset = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, cursorTracer);
        if (lastClosedTxLogVersion != -1L && lastClosedTxLogByteOffset != -1L) {
            return new LogPosition(lastClosedTxLogVersion, lastClosedTxLogByteOffset);
        }
        if (lastTxId == 1L) {
            return new LogPosition(0L, 64L);
        }
        TransactionLogFilesHelper logFiles = new TransactionLogFilesHelper(this.fileSystem, sourceDirectoryStructure.getTransactionLogsDirectory());
        RangeLogVersionVisitor versionVisitor = new RangeLogVersionVisitor();
        logFiles.accept((LogVersionVisitor)versionVisitor);
        long logVersion = versionVisitor.getHighestVersion();
        if (logVersion == -1L) {
            return new LogPosition(0L, 64L);
        }
        long offset = this.fileSystem.getFileSize(versionVisitor.getHighestFile());
        return new LogPosition(logVersion, offset);
    }

    private void migrateWithBatchImporter(DatabaseLayout sourceDirectoryStructure, DatabaseLayout migrationDirectoryStructure, long lastTxId, int lastTxChecksum, long lastTxLogVersion, long lastTxLogByteOffset, long lastCheckpointLogVersion, ProgressReporter progressReporter, RecordFormats oldFormat, RecordFormats newFormat, boolean requiresDynamicStoreMigration, boolean requiresPropertyMigration) throws IOException {
        this.prepareBatchImportMigration(sourceDirectoryStructure, migrationDirectoryStructure, oldFormat, newFormat);
        try (NeoStores legacyStore = this.instantiateLegacyStore(oldFormat, sourceDirectoryStructure);){
            Configuration.Overridden importConfig = new Configuration.Overridden(Configuration.defaultConfiguration((Path)sourceDirectoryStructure.databaseDirectory()), this.config);
            AdditionalInitialIds additionalInitialIds = RecordStorageMigrator.readAdditionalIds(lastTxId, lastTxChecksum, lastTxLogVersion, lastTxLogByteOffset, lastCheckpointLogVersion);
            BatchImporter importer = this.batchImporterFactory.instantiate(migrationDirectoryStructure, this.fileSystem, this.pageCache, this.cacheTracer, (Configuration)importConfig, this.logService, ExecutionSupervisors.withDynamicProcessorAssignment(RecordStorageMigrator.migrationBatchImporterMonitor(legacyStore, progressReporter, (Configuration)importConfig), (Configuration)importConfig), additionalInitialIds, this.config, newFormat, ImportLogic.NO_MONITOR, this.jobScheduler, Collector.STRICT, LogFilesInitializer.NULL, this.memoryTracker);
            InputIterable nodes = () -> RecordStorageMigrator.legacyNodesAsInput(legacyStore, requiresPropertyMigration, this.cacheTracer, this.memoryTracker);
            InputIterable relationships = () -> RecordStorageMigrator.legacyRelationshipsAsInput(legacyStore, requiresPropertyMigration, this.cacheTracer, this.memoryTracker);
            long propertyStoreSize = RecordStorageMigrator.storeSize(legacyStore.getPropertyStore()) / 2L + RecordStorageMigrator.storeSize(legacyStore.getPropertyStore().getStringStore()) / 2L + RecordStorageMigrator.storeSize(legacyStore.getPropertyStore().getArrayStore()) / 2L;
            Input.Estimates estimates = Input.knownEstimates((long)legacyStore.getNodeStore().getNumberOfIdsInUse(), (long)legacyStore.getRelationshipStore().getNumberOfIdsInUse(), (long)legacyStore.getPropertyStore().getNumberOfIdsInUse(), (long)legacyStore.getPropertyStore().getNumberOfIdsInUse(), (long)(propertyStoreSize / 2L), (long)(propertyStoreSize / 2L), (long)0L);
            importer.doImport(Input.input((InputIterable)nodes, (InputIterable)relationships, (org.neo4j.internal.batchimport.input.IdType)org.neo4j.internal.batchimport.input.IdType.ACTUAL, (Input.Estimates)estimates, (ReadableGroups)ReadableGroups.EMPTY));
            ArrayList<DatabaseFile> storesToDeleteFromMigratedDirectory = new ArrayList<DatabaseFile>();
            storesToDeleteFromMigratedDirectory.add(DatabaseFile.METADATA_STORE);
            if (!requiresPropertyMigration) {
                storesToDeleteFromMigratedDirectory.addAll(Arrays.asList(DatabaseFile.PROPERTY_STORE, DatabaseFile.PROPERTY_STRING_STORE, DatabaseFile.PROPERTY_ARRAY_STORE));
            }
            if (!requiresDynamicStoreMigration) {
                storesToDeleteFromMigratedDirectory.addAll(Arrays.asList(DatabaseFile.NODE_LABEL_STORE, DatabaseFile.LABEL_TOKEN_STORE, DatabaseFile.LABEL_TOKEN_NAMES_STORE, DatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, DatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, DatabaseFile.PROPERTY_KEY_TOKEN_STORE, DatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, DatabaseFile.SCHEMA_STORE));
            }
            StoreMigratorFileOperation.fileOperation(FileOperation.DELETE, this.fileSystem, migrationDirectoryStructure, migrationDirectoryStructure, storesToDeleteFromMigratedDirectory, true, true, null);
        }
    }

    private static long storeSize(CommonAbstractStore<? extends AbstractBaseRecord, ? extends StoreHeader> store) {
        return store.getNumberOfIdsInUse() * (long)store.getRecordSize();
    }

    private NeoStores instantiateLegacyStore(RecordFormats format, DatabaseLayout directoryStructure) {
        return new StoreFactory(directoryStructure, this.config, (IdGeneratorFactory)new ScanOnOpenReadOnlyIdGeneratorFactory(), this.pageCache, this.fileSystem, format, (LogProvider)NullLogProvider.getInstance(), this.cacheTracer, (ImmutableSet<OpenOption>)Sets.immutable.empty()).openAllNeoStores(true);
    }

    private void prepareBatchImportMigration(DatabaseLayout sourceDirectoryStructure, DatabaseLayout migrationStrcuture, RecordFormats oldFormat, RecordFormats newFormat) throws IOException {
        this.createStore(migrationStrcuture, newFormat);
        DatabaseFile[] storesFilesToMigrate = new DatabaseFile[]{DatabaseFile.LABEL_TOKEN_STORE, DatabaseFile.LABEL_TOKEN_NAMES_STORE, DatabaseFile.PROPERTY_KEY_TOKEN_STORE, DatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, DatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, DatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, DatabaseFile.NODE_LABEL_STORE};
        if (newFormat.dynamic().equals(oldFormat.dynamic())) {
            StoreMigratorFileOperation.fileOperation(FileOperation.COPY, this.fileSystem, sourceDirectoryStructure, migrationStrcuture, Arrays.asList(storesFilesToMigrate), true, !IdGeneratorMigrator.requiresIdFilesMigration(oldFormat, newFormat), ExistingTargetStrategy.OVERWRITE);
        } else {
            DirectRecordStoreMigrator migrator = new DirectRecordStoreMigrator(this.pageCache, this.fileSystem, this.config, this.cacheTracer);
            StoreType[] storesToMigrate = new StoreType[]{StoreType.LABEL_TOKEN, StoreType.LABEL_TOKEN_NAME, StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY_KEY_TOKEN_NAME, StoreType.RELATIONSHIP_TYPE_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN_NAME, StoreType.NODE_LABEL};
            ProgressReporter progressReporter = ProgressReporter.SILENT;
            migrator.migrate(sourceDirectoryStructure, oldFormat, migrationStrcuture, newFormat, progressReporter, storesToMigrate, StoreType.NODE);
        }
        this.createStoreFactory(migrationStrcuture, newFormat, (IdGeneratorFactory)new ScanOnOpenOverwritingIdGeneratorFactory(this.fileSystem)).openAllNeoStores().close();
    }

    private void createStore(DatabaseLayout migrationDirectoryStructure, RecordFormats newFormat) {
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(this.fileSystem, RecoveryCleanupWorkCollector.immediate());
        this.createStoreFactory(migrationDirectoryStructure, newFormat, (IdGeneratorFactory)idGeneratorFactory).openAllNeoStores(true).close();
    }

    private StoreFactory createStoreFactory(DatabaseLayout databaseLayout, RecordFormats formats, IdGeneratorFactory idGeneratorFactory) {
        return new StoreFactory(databaseLayout, this.config, idGeneratorFactory, this.pageCache, this.fileSystem, formats, (LogProvider)NullLogProvider.getInstance(), this.cacheTracer, (ImmutableSet<OpenOption>)Sets.immutable.empty());
    }

    private static AdditionalInitialIds readAdditionalIds(final long lastTxId, final int lastTxChecksum, final long lastTxLogVersion, final long lastTxLogByteOffset, final long lastCheckpointLogVersion) {
        return new AdditionalInitialIds(){

            @Override
            public long lastCommittedTransactionId() {
                return lastTxId;
            }

            @Override
            public int lastCommittedTransactionChecksum() {
                return lastTxChecksum;
            }

            @Override
            public long lastCommittedTransactionLogVersion() {
                return lastTxLogVersion;
            }

            @Override
            public long lastCommittedTransactionLogByteOffset() {
                return lastTxLogByteOffset;
            }

            @Override
            public long checkpointLogVersion() {
                return lastCheckpointLogVersion;
            }
        };
    }

    private static ExecutionMonitor migrationBatchImporterMonitor(NeoStores legacyStore, ProgressReporter progressReporter, Configuration config) {
        return new BatchImporterProgressMonitor(legacyStore.getNodeStore().getHighId(), legacyStore.getRelationshipStore().getHighId(), config, progressReporter);
    }

    private static InputIterator legacyRelationshipsAsInput(final NeoStores legacyStore, final boolean requiresPropertyMigration, final PageCacheTracer cacheTracer, final MemoryTracker memoryTracker) {
        return new StoreScanAsInputIterator<RelationshipRecord>((RecordStore)legacyStore.getRelationshipStore()){

            public InputChunk newChunk() {
                PageCursorTracer cursorTracer = cacheTracer.createPageCursorTracer(RecordStorageMigrator.RELATIONSHIP_CHUNK_MIGRATION_TAG);
                return new RelationshipRecordChunk(new RecordStorageReader(legacyStore), requiresPropertyMigration, cursorTracer, memoryTracker);
            }
        };
    }

    private static InputIterator legacyNodesAsInput(final NeoStores legacyStore, final boolean requiresPropertyMigration, final PageCacheTracer cacheTracer, final MemoryTracker memoryTracker) {
        return new StoreScanAsInputIterator<NodeRecord>((RecordStore)legacyStore.getNodeStore()){

            public InputChunk newChunk() {
                PageCursorTracer cursorTracer = cacheTracer.createPageCursorTracer(RecordStorageMigrator.NODE_CHUNK_MIGRATION_TAG);
                return new NodeRecordChunk(new RecordStorageReader(legacyStore), requiresPropertyMigration, cursorTracer, memoryTracker);
            }
        };
    }

    public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToUpgradeFrom, String versionToUpgradeTo) throws IOException {
        StoreMigratorFileOperation.fileOperation(FileOperation.MOVE, this.fileSystem, migrationLayout, directoryLayout, Iterables.iterable((Object[])DatabaseFile.values()), true, true, ExistingTargetStrategy.OVERWRITE);
        RecordFormats oldFormat = RecordFormatSelector.selectForVersion(versionToUpgradeFrom);
        RecordFormats newFormat = RecordFormatSelector.selectForVersion(versionToUpgradeTo);
        if (this.requiresCountsStoreMigration(oldFormat, newFormat)) {
            this.fileSystem.deleteFile(directoryLayout.databaseDirectory().resolve("neostore.counts.db.a"));
            this.fileSystem.deleteFile(directoryLayout.databaseDirectory().resolve("neostore.counts.db.b"));
        }
    }

    private void updateOrAddNeoStoreFieldsAsPartOfMigration(DatabaseLayout migrationStructure, DatabaseLayout sourceDirectoryStructure, String versionToMigrateTo, LogPosition lastClosedTxLogPosition, boolean requiresIdFilesMigration, PageCursorTracer cursorTracer) throws IOException {
        Path storeDirNeoStore = sourceDirectoryStructure.metadataStore();
        Path migrationDirNeoStore = migrationStructure.metadataStore();
        StoreMigratorFileOperation.fileOperation(FileOperation.COPY, this.fileSystem, sourceDirectoryStructure, migrationStructure, Iterables.iterable((Object[])new DatabaseFile[]{DatabaseFile.METADATA_STORE}), true, !requiresIdFilesMigration, ExistingTargetStrategy.SKIP);
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_ID, MetaDataStore.getRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_ID, cursorTracer), cursorTracer);
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.UPGRADE_TIME, System.currentTimeMillis(), cursorTracer);
        TransactionId lastTxInfo = this.readLastTxInformation(migrationStructure);
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, lastTxInfo.checksum(), cursorTracer);
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM, lastTxInfo.checksum(), cursorTracer);
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, lastTxInfo.commitTimestamp(), cursorTracer);
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, lastTxInfo.commitTimestamp(), cursorTracer);
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, lastClosedTxLogPosition.getLogVersion(), cursorTracer);
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, lastClosedTxLogPosition.getByteOffset(), cursorTracer);
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.STORE_VERSION, MetaDataStore.versionStringToLong(versionToMigrateTo), cursorTracer);
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.CHECKPOINT_LOG_VERSION, 0L, cursorTracer);
    }

    private boolean requiresSchemaStoreMigration(RecordFormats oldFormat, RecordFormats newFormat) {
        return oldFormat.hasCapability(RecordStorageCapability.FLEXIBLE_SCHEMA_STORE) != newFormat.hasCapability(RecordStorageCapability.FLEXIBLE_SCHEMA_STORE);
    }

    private void migrateSchemaStore(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, RecordFormats oldFormat, RecordFormats newFormat, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) throws IOException, KernelException {
        ScanOnOpenReadOnlyIdGeneratorFactory srcIdGeneratorFactory = new ScanOnOpenReadOnlyIdGeneratorFactory();
        StoreFactory srcFactory = this.createStoreFactory(directoryLayout, oldFormat, (IdGeneratorFactory)srcIdGeneratorFactory);
        StoreFactory dstFactory = this.createStoreFactory(migrationLayout, newFormat, (IdGeneratorFactory)new ScanOnOpenOverwritingIdGeneratorFactory(this.fileSystem));
        if (newFormat.hasCapability(RecordStorageCapability.FLEXIBLE_SCHEMA_STORE)) {
            SchemaStorageCreator schemaStorageCreator = oldFormat.hasCapability(RecordStorageCapability.FLEXIBLE_SCHEMA_STORE) ? this.schemaStorageCreatorFlexible() : this.schemaStorageCreator35(directoryLayout, oldFormat, (IdGeneratorFactory)srcIdGeneratorFactory);
            StoreType[] sourceStoresToOpen = new StoreType[]{StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY_KEY_TOKEN_NAME, StoreType.LABEL_TOKEN, StoreType.LABEL_TOKEN_NAME, StoreType.RELATIONSHIP_TYPE_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN_NAME};
            sourceStoresToOpen = (StoreType[])ArrayUtil.concat((Object[])sourceStoresToOpen, (Object[])schemaStorageCreator.additionalStoresToOpen());
            try (NeoStores srcStore = srcFactory.openNeoStores(sourceStoresToOpen);
                 NeoStores dstStore = dstFactory.openNeoStores(true, StoreType.SCHEMA, StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY);
                 SchemaStorageCreator schemaStorageCreator2 = schemaStorageCreator;){
                dstStore.start(cursorTracer);
                TokenHolders srcTokenHolders = new TokenHolders(StoreTokens.createReadOnlyTokenHolder("PropertyKey"), StoreTokens.createReadOnlyTokenHolder("Label"), StoreTokens.createReadOnlyTokenHolder("RelationshipType"));
                srcTokenHolders.setInitialTokens(StoreTokens.allTokens(srcStore), cursorTracer);
                SchemaStorage srcAccess = schemaStorageCreator.create(srcStore, srcTokenHolders, cursorTracer);
                SchemaRuleMigrationAccess dstAccess = RecordStorageEngineFactory.createMigrationTargetSchemaRuleAccess(dstStore, cursorTracer, memoryTracker);
                RecordStorageMigrator.migrateSchemaRules(srcTokenHolders, srcAccess, dstAccess, cursorTracer);
                dstStore.flush(IOLimiter.UNLIMITED, cursorTracer);
            }
        }
    }

    static void migrateSchemaRules(TokenHolders srcTokenHolders, SchemaStorage srcAccess, SchemaRuleMigrationAccess dstAccess, PageCursorTracer cursorTracer) throws KernelException {
        LinkedHashMap<Long, SchemaRule> rules = new LinkedHashMap<Long, SchemaRule>();
        RecordStorageMigrator.schemaGenerateNames(srcAccess.getAll(cursorTracer), srcTokenHolders, rules);
        for (SchemaRule rule : rules.values()) {
            dstAccess.writeSchemaRule(rule);
        }
    }

    public static void schemaGenerateNames(Iterable<SchemaRule> srcRules, TokenHolders srcTokenHolders, Map<Long, SchemaRule> rules) throws KernelException {
        SchemaNameGiver nameGiver = new SchemaNameGiver(srcTokenHolders);
        ArrayList namedRules = new ArrayList();
        ArrayList unnamedRules = new ArrayList();
        srcRules.forEach(r -> (RecordStorageMigrator.hasName(r) ? namedRules : unnamedRules).add(r));
        namedRules.forEach(r -> rules.put(r.getId(), (SchemaRule)r));
        unnamedRules.forEach(r -> rules.put(r.getId(), (SchemaRule)r));
        for (Map.Entry<Long, SchemaRule> entry : rules.entrySet()) {
            IndexBackedConstraintDescriptor ibc;
            SchemaRule rule = entry.getValue();
            if (rule instanceof IndexDescriptor) {
                IndexDescriptor index = (IndexDescriptor)rule;
                OptionalLong owningConstraintId = index.getOwningConstraintId();
                if (owningConstraintId.isPresent() && rules.containsKey(owningConstraintId.getAsLong())) {
                    ConstraintDescriptor constraint = (ConstraintDescriptor)rules.get(owningConstraintId.getAsLong());
                    constraint = nameGiver.ensureHasUniqueName(constraint);
                    rules.put(constraint.getId(), (SchemaRule)constraint);
                    index = index.withName(constraint.getName());
                } else {
                    index = nameGiver.ensureHasUniqueName(index);
                }
                entry.setValue((SchemaRule)index);
                continue;
            }
            ConstraintDescriptor constraint = (ConstraintDescriptor)rule;
            constraint = nameGiver.ensureHasUniqueName(constraint);
            entry.setValue((SchemaRule)constraint);
            if (!constraint.isIndexBackedConstraint() || !(ibc = constraint.asIndexBackedConstraint()).hasOwnedIndexId()) continue;
            IndexDescriptor index = (IndexDescriptor)rules.get(ibc.ownedIndexId());
            rules.put(index.getId(), (SchemaRule)index.withName(constraint.getName()));
        }
    }

    private static boolean hasName(SchemaRule rule) {
        String name = rule.getName();
        return name != null && !name.startsWith("index_") && !name.startsWith("constraint_");
    }

    private static String[] getEntityTokenNames(TokenHolders tokenHolders, SchemaRule rule) throws KernelException {
        SchemaDescriptor schema = rule.schema();
        int[] entityTokenIds = schema.getEntityTokenIds();
        String[] entityTokenNames = new String[entityTokenIds.length];
        TokenHolder tokenHolder = schema.entityType() == EntityType.NODE ? tokenHolders.labelTokens() : tokenHolders.relationshipTypeTokens();
        for (int i = 0; i < entityTokenIds.length; ++i) {
            try {
                entityTokenNames[i] = tokenHolder.getTokenById(entityTokenIds[i]).name();
                continue;
            }
            catch (TokenNotFoundException e) {
                if (schema.entityType() == EntityType.NODE) {
                    throw new LabelNotFoundKernelException((long)entityTokenIds[i], (Exception)((Object)e));
                }
                throw new RelationshipTypeIdNotFoundKernelException((long)entityTokenIds[i], (Exception)((Object)e));
            }
        }
        return entityTokenNames;
    }

    private static String[] getPropertyTokenNames(TokenHolders tokenHolders, SchemaRule rule) throws KernelException {
        SchemaDescriptor schema = rule.schema();
        int[] propertyIds = schema.getPropertyIds();
        String[] propertyNames = new String[propertyIds.length];
        TokenHolder tokenHolder = tokenHolders.propertyKeyTokens();
        for (int i = 0; i < propertyIds.length; ++i) {
            try {
                propertyNames[i] = tokenHolder.getTokenById(propertyIds[i]).name();
                continue;
            }
            catch (TokenNotFoundException e) {
                throw new PropertyKeyIdNotFoundKernelException(propertyIds[i], (Exception)((Object)e));
            }
        }
        return propertyNames;
    }

    public void cleanup(DatabaseLayout migrationLayout) throws IOException {
        this.fileSystem.deleteRecursively(migrationLayout.databaseDirectory());
    }

    public String toString() {
        return "Kernel StoreMigrator";
    }

    private SchemaStorageCreator schemaStorageCreatorFlexible() {
        return new SchemaStorageCreator(){
            private SchemaStore schemaStore;

            @Override
            public SchemaStorage create(NeoStores store, TokenHolders tokenHolders, PageCursorTracer cursorTracer) {
                this.schemaStore = store.getSchemaStore();
                return new org.neo4j.internal.recordstorage.SchemaStorage(this.schemaStore, tokenHolders);
            }

            @Override
            public StoreType[] additionalStoresToOpen() {
                return new StoreType[]{StoreType.PROPERTY, StoreType.PROPERTY_STRING, StoreType.PROPERTY_ARRAY, StoreType.SCHEMA};
            }

            @Override
            public void close() throws IOException {
                org.neo4j.io.IOUtils.closeAll((AutoCloseable[])new SchemaStore[]{this.schemaStore});
            }
        };
    }

    private SchemaStorageCreator schemaStorageCreator35(final DatabaseLayout directoryLayout, final RecordFormats oldFormat, final IdGeneratorFactory srcIdGeneratorFactory) {
        return new SchemaStorageCreator(){
            SchemaStore35 srcSchema;

            @Override
            public SchemaStorage create(NeoStores store, TokenHolders tokenHolders, PageCursorTracer cursorTracer) {
                this.srcSchema = new SchemaStore35(directoryLayout.schemaStore(), directoryLayout.idSchemaStore(), RecordStorageMigrator.this.config, IdType.SCHEMA, srcIdGeneratorFactory, RecordStorageMigrator.this.pageCache, (LogProvider)NullLogProvider.getInstance(), oldFormat, (ImmutableSet<OpenOption>)Sets.immutable.empty());
                this.srcSchema.initialise(true, cursorTracer);
                return new SchemaStorage35(this.srcSchema);
            }

            @Override
            public StoreType[] additionalStoresToOpen() {
                return new StoreType[0];
            }

            @Override
            public void close() throws IOException {
                org.neo4j.io.IOUtils.closeAll((AutoCloseable[])new SchemaStore35[]{this.srcSchema});
            }
        };
    }

    private static class BatchImporterProgressMonitor
    extends CoarseBoundedProgressExecutionMonitor {
        private final ProgressReporter progressReporter;

        BatchImporterProgressMonitor(long highNodeId, long highRelationshipId, Configuration configuration, ProgressReporter progressReporter) {
            super(highNodeId, highRelationshipId, configuration);
            this.progressReporter = progressReporter;
            this.progressReporter.start(this.total());
        }

        @Override
        protected void progress(long progress) {
            this.progressReporter.progress(progress);
        }
    }

    private static class RelationshipRecordChunk
    extends StoreScanChunk<StorageRelationshipScanCursor> {
        RelationshipRecordChunk(RecordStorageReader storageReader, boolean requiresPropertyMigration, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
            super(storageReader.allocateRelationshipScanCursor(cursorTracer), storageReader, requiresPropertyMigration, cursorTracer, memoryTracker);
        }

        @Override
        protected void read(StorageRelationshipScanCursor cursor, long id) {
            cursor.single(id);
        }

        @Override
        protected void visitRecord(StorageRelationshipScanCursor record, InputEntityVisitor visitor) {
            visitor.startId(record.sourceNodeReference());
            visitor.endId(record.targetNodeReference());
            visitor.type(record.type());
            this.visitProperties(record, visitor);
        }
    }

    private static class NodeRecordChunk
    extends StoreScanChunk<RecordNodeCursor> {
        NodeRecordChunk(RecordStorageReader storageReader, boolean requiresPropertyMigration, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
            super(storageReader.allocateNodeCursor(cursorTracer), storageReader, requiresPropertyMigration, cursorTracer, memoryTracker);
        }

        @Override
        protected void read(RecordNodeCursor cursor, long id) {
            cursor.single(id);
        }

        @Override
        protected void visitRecord(RecordNodeCursor record, InputEntityVisitor visitor) {
            visitor.id(record.entityReference());
            visitor.labelField(record.getLabelField());
            this.visitProperties(record, visitor);
        }
    }

    private static interface SchemaStorageCreator
    extends Closeable {
        public SchemaStorage create(NeoStores var1, TokenHolders var2, PageCursorTracer var3);

        public StoreType[] additionalStoresToOpen();
    }

    private static final class SchemaNameGiver {
        private final Map<String, SchemaRule> takenNames = new HashMap<String, SchemaRule>();
        private final TokenHolders tokens;

        private SchemaNameGiver(TokenHolders tokens) {
            this.tokens = tokens;
        }

        private <T extends SchemaRule> T ensureHasUniqueName(T rule) throws KernelException {
            Object name = rule.getName();
            if (name != null && this.takenNames.get(name) == rule) {
                return rule;
            }
            if (!RecordStorageMigrator.hasName(rule)) {
                String[] entityTokenNames = RecordStorageMigrator.getEntityTokenNames(this.tokens, rule);
                String[] propertyTokenNames = RecordStorageMigrator.getPropertyTokenNames(this.tokens, rule);
                name = SchemaRule.generateName(rule, (String[])entityTokenNames, (String[])propertyTokenNames);
            }
            int count = 0;
            String originalName = name;
            while (this.takenNames.containsKey(name)) {
                name = originalName + "_" + ++count;
            }
            rule = rule.withName((String)name);
            this.takenNames.put((String)name, (SchemaRule)rule);
            return rule;
        }
    }
}

