/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.StoreVersion;
import org.neo4j.storageengine.migration.RollingUpgradeCompatibility;

public class RecordStoreRollingUpgradeCompatibility
implements RollingUpgradeCompatibility {
    private final Map<String, Set<String>> compatibilityMap = new HashMap<String, Set<String>>();

    public RecordStoreRollingUpgradeCompatibility(Iterable<RecordFormats> knownFormats) {
        for (RecordFormats knownFormat : knownFormats) {
            HashSet<String> compatibleVersions = new HashSet<String>();
            for (RecordFormats recordFormats : knownFormat.compatibleVersionsForRollingUpgrade()) {
                compatibleVersions.add(recordFormats.storeVersion());
            }
            this.compatibilityMap.put(knownFormat.storeVersion(), compatibleVersions);
        }
        this.compatibilityMap.put("SF4.3.0", Set.of(StoreVersion.STANDARD_V4_0.versionString()));
        this.compatibilityMap.put("AF4.3.0", Set.of(StoreVersion.ALIGNED_V4_1.versionString()));
        this.compatibilityMap.put("HL4.3.0", Set.of(StoreVersion.HIGH_LIMIT_V4_0_0.versionString()));
    }

    public boolean isVersionCompatibleForRollingUpgrade(String format, String otherFormat) {
        return Objects.equals(format, otherFormat) || this.compatibilityMap.getOrDefault(otherFormat, Collections.emptySet()).contains(format);
    }

    public boolean isVersionCompatibleForRollingUpgrade(long format, long otherFormat) {
        return this.isVersionCompatibleForRollingUpgrade(MetaDataStore.versionLongToString(format), MetaDataStore.versionLongToString(otherFormat));
    }
}

