/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.RecordFormatPropertyConfigurator;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.storemigration.RecordStoreVersion;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionCheck;

public class RecordStoreVersionCheck
implements StoreVersionCheck {
    private final PageCache pageCache;
    private final Path metaDataFile;
    private final RecordFormats configuredFormat;
    private final Config config;

    public RecordStoreVersionCheck(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout databaseLayout, LogProvider logProvider, Config config, PageCacheTracer pageCacheTracer) {
        this(pageCache, databaseLayout, RecordStoreVersionCheck.configuredVersion(config, databaseLayout, fs, pageCache, logProvider, pageCacheTracer), config);
    }

    RecordStoreVersionCheck(PageCache pageCache, DatabaseLayout databaseLayout, RecordFormats configuredFormat, Config config) {
        this.pageCache = pageCache;
        this.metaDataFile = databaseLayout.metadataStore();
        this.configuredFormat = configuredFormat;
        this.config = config;
    }

    public Optional<String> storeVersion(PageCursorTracer cursorTracer) {
        try {
            String version = this.readVersion(cursorTracer);
            return Optional.of(version);
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public String storeVersionToString(long storeVersion) {
        return MetaDataStore.versionLongToString(storeVersion);
    }

    private String readVersion(PageCursorTracer cursorTracer) throws IOException {
        long record = MetaDataStore.getRecord(this.pageCache, this.metaDataFile, MetaDataStore.Position.STORE_VERSION, cursorTracer);
        if (record == -1L) {
            throw new IllegalStateException("Uninitialized version field in " + this.metaDataFile);
        }
        return MetaDataStore.versionLongToString(record);
    }

    public StoreVersion versionInformation(String storeVersion) {
        return new RecordStoreVersion(RecordFormatSelector.selectForVersion(storeVersion));
    }

    public String configuredVersion() {
        RecordFormatPropertyConfigurator.configureRecordFormat(this.configuredFormat, this.config);
        return this.configuredFormat.storeVersion();
    }

    public boolean isVersionConfigured() {
        return StringUtils.isNotEmpty((CharSequence)((CharSequence)this.config.get(GraphDatabaseSettings.record_format)));
    }

    public StoreVersionCheck.Result checkUpgrade(String desiredVersion, PageCursorTracer cursorTracer) {
        String version;
        try {
            version = this.readVersion(cursorTracer);
        }
        catch (IllegalStateException e) {
            return new StoreVersionCheck.Result(StoreVersionCheck.Outcome.storeVersionNotFound, null, this.metaDataFile.getFileName().toString());
        }
        catch (IOException e) {
            return new StoreVersionCheck.Result(StoreVersionCheck.Outcome.missingStoreFile, null, this.metaDataFile.getFileName().toString());
        }
        if (desiredVersion.equals(version)) {
            return new StoreVersionCheck.Result(StoreVersionCheck.Outcome.ok, version, this.metaDataFile.getFileName().toString());
        }
        try {
            RecordFormats format = RecordFormatSelector.selectForVersion(desiredVersion);
            RecordFormats fromFormat = RecordFormatSelector.selectForVersion(version);
            if (FormatFamily.isLowerFamilyFormat(format, fromFormat)) {
                return new StoreVersionCheck.Result(StoreVersionCheck.Outcome.unexpectedUpgradingVersion, version, this.metaDataFile.toAbsolutePath().toString());
            }
            if (FormatFamily.isSameFamily(fromFormat, format) && fromFormat.generation() > format.generation()) {
                return new StoreVersionCheck.Result(StoreVersionCheck.Outcome.attemptedStoreDowngrade, fromFormat.storeVersion(), this.metaDataFile.toAbsolutePath().toString());
            }
            return new StoreVersionCheck.Result(StoreVersionCheck.Outcome.ok, version, this.metaDataFile.toAbsolutePath().toString());
        }
        catch (IllegalArgumentException e) {
            return new StoreVersionCheck.Result(StoreVersionCheck.Outcome.unexpectedStoreVersion, version, this.metaDataFile.toAbsolutePath().toString());
        }
    }

    private static RecordFormats configuredVersion(Config config, DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, LogProvider logProvider, PageCacheTracer pageCacheTracer) {
        return RecordFormatSelector.selectNewestFormat(config, databaseLayout, fs, pageCache, logProvider, pageCacheTracer);
    }
}

