/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.Status;

public class DropConstraintFailureException
extends SchemaKernelException {
    private final Object constraint;

    public DropConstraintFailureException(SchemaDescriptorSupplier constraint, Throwable cause) {
        super((Status)Status.Schema.ConstraintDropFailed, cause, "Unable to drop constraint: " + cause.getMessage(), new Object[0]);
        this.constraint = constraint;
    }

    public DropConstraintFailureException(String nameOrSchema, Throwable cause) {
        super((Status)Status.Schema.ConstraintDropFailed, cause, "Unable to drop constraint `" + nameOrSchema + "`: " + cause.getMessage(), new Object[0]);
        this.constraint = nameOrSchema;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        String message;
        if (this.constraint instanceof SchemaDescriptorSupplier) {
            SchemaDescriptorSupplier schemaish = (SchemaDescriptorSupplier)this.constraint;
            message = "Unable to drop constraint on " + schemaish.userDescription(tokenNameLookup) + ": ";
        } else if (this.constraint instanceof String) {
            String name = (String)this.constraint;
            message = "Unable to drop constraint `" + name + "`: ";
        } else {
            return this.getMessage();
        }
        Throwable cause = this.getCause();
        if (cause instanceof KernelException) {
            KernelException exception = (KernelException)cause;
            message = message + exception.getUserMessage(tokenNameLookup);
        } else {
            message = message + cause.getMessage();
        }
        return message;
    }
}

