/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Objects;
import java.util.UUID;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.util.Id;

public class DatabaseId {
    private final Id id;

    DatabaseId(UUID uuid) {
        Objects.requireNonNull(uuid, "Database UUID should be not null.");
        this.id = new Id(uuid);
    }

    public UUID uuid() {
        return this.id.uuid();
    }

    Id id() {
        return this.id;
    }

    public boolean isSystemDatabase() {
        return DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID.databaseId().equals(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseId that = (DatabaseId)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "DatabaseId{" + this.id + "}";
    }
}

