/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;

public class MapCachingDatabaseIdRepository
implements DatabaseIdRepository.Caching {
    private static final Optional<NamedDatabaseId> OPT_SYS_DB = Optional.of(NAMED_SYSTEM_DATABASE_ID);
    private final DatabaseIdRepository delegate;
    private final Map<String, NamedDatabaseId> databaseIdsByName;
    private final Map<DatabaseId, NamedDatabaseId> databaseIdsByUuid;

    public MapCachingDatabaseIdRepository(DatabaseIdRepository delegate) {
        this.delegate = delegate;
        this.databaseIdsByName = new ConcurrentHashMap<String, NamedDatabaseId>();
        this.databaseIdsByUuid = new ConcurrentHashMap<DatabaseId, NamedDatabaseId>();
    }

    @Override
    public Optional<NamedDatabaseId> getByName(NormalizedDatabaseName databaseName) {
        if (NAMED_SYSTEM_DATABASE_ID.name().equals(databaseName.name())) {
            return OPT_SYS_DB;
        }
        return Optional.ofNullable(this.databaseIdsByName.computeIfAbsent(databaseName.name(), name -> this.delegate.getByName((String)name).orElse(null)));
    }

    @Override
    public Optional<NamedDatabaseId> getById(DatabaseId uuid) {
        if (NAMED_SYSTEM_DATABASE_ID.databaseId().equals(uuid)) {
            return OPT_SYS_DB;
        }
        return Optional.ofNullable(this.databaseIdsByUuid.computeIfAbsent(uuid, id -> this.delegate.getById((DatabaseId)id).orElse(null)));
    }

    @Override
    public void invalidate(NamedDatabaseId namedDatabaseId) {
        this.databaseIdsByName.remove(namedDatabaseId.name());
        this.databaseIdsByUuid.remove(namedDatabaseId.databaseId());
    }

    @Override
    public void cache(NamedDatabaseId namedDatabaseId) {
        this.databaseIdsByName.put(namedDatabaseId.name(), namedDatabaseId);
        this.databaseIdsByUuid.put(namedDatabaseId.databaseId(), namedDatabaseId);
    }
}

