/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.util.MonotonicCounter;
import org.neo4j.resources.CpuClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class ExecutingQueryFactory {
    private static final MonotonicCounter lastQueryId = MonotonicCounter.newAtomicMonotonicCounter();
    private final SystemNanoClock clock;
    private final AtomicReference<CpuClock> cpuClockRef;
    private final AtomicBoolean trackQueryAllocations;

    public ExecutingQueryFactory(SystemNanoClock clock, AtomicReference<CpuClock> cpuClockRef, Config config) {
        this.clock = clock;
        this.cpuClockRef = cpuClockRef;
        this.trackQueryAllocations = new AtomicBoolean((Boolean)config.get(GraphDatabaseSettings.track_query_allocation));
        config.addListener(GraphDatabaseSettings.track_query_allocation, (before, after) -> this.trackQueryAllocations.set((boolean)after));
    }

    public ExecutingQuery createForStatement(KernelStatement statement, String queryText, MapValue queryParameters) {
        KernelTransactionImplementation transaction = statement.getTransaction();
        ExecutingQuery executingQuery = this.createUnbound(queryText, queryParameters, transaction.clientInfo(), statement.username(), transaction.getMetaData());
        this.bindToStatement(executingQuery, statement);
        return executingQuery;
    }

    public ExecutingQuery createUnbound(String queryText, MapValue queryParameters, ClientConnectionInfo clientConnectionInfo, String username, Map<String, Object> transactionMetaData) {
        Thread thread = Thread.currentThread();
        return new ExecutingQuery(lastQueryId.incrementAndGet(), clientConnectionInfo, username, queryText, queryParameters, transactionMetaData, thread.getId(), thread.getName(), this.clock, this.cpuClockRef.get(), this.trackQueryAllocations.get());
    }

    public void bindToStatement(ExecutingQuery executingQuery, KernelStatement statement) {
        executingQuery.onTransactionBound(new ExecutingQuery.TransactionBinding(statement.namedDatabaseId(), statement::getHits, statement::getFaults, () -> statement.locks().activeLockCount()));
    }
}

