/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.token.TokenHolders;

class TokenHoldersIdLookup
implements LoginContext.IdLookup {
    private final TokenHolders tokens;
    private final GlobalProcedures globalProcedures;
    private final String specialCharacters = "<([{\\^-=$!|]})+.>";
    private final String escapedSpecialCharacters = "<([{\\^-=$!|]})+.>".replaceAll(".", "\\\\$0");
    private final Pattern specialCharacterPattern = Pattern.compile("[" + this.escapedSpecialCharacters + "]");

    TokenHoldersIdLookup(TokenHolders tokens, GlobalProcedures globalProcedures) {
        this.tokens = tokens;
        this.globalProcedures = globalProcedures;
    }

    public int getPropertyKeyId(String name) {
        return this.tokens.propertyKeyTokens().getIdByName(name);
    }

    public int getLabelId(String name) {
        return this.tokens.labelTokens().getIdByName(name);
    }

    public int getRelTypeId(String name) {
        return this.tokens.relationshipTypeTokens().getIdByName(name);
    }

    public int[] getProcedureIds(String procedureGlobbing) {
        Predicate<String> matcherPredicate = this.predicate(procedureGlobbing);
        return this.globalProcedures.getIdsOfProceduresMatching(p -> matcherPredicate.test(p.signature().name().toString()));
    }

    public int[] getAdminProcedureIds() {
        return this.globalProcedures.getIdsOfProceduresMatching(p -> p.signature().admin());
    }

    public int[] getFunctionIds(String functionGlobbing) {
        Predicate<String> matcherPredicate = this.predicate(functionGlobbing);
        return this.globalProcedures.getIdsOfFunctionsMatching(f -> matcherPredicate.test(f.signature().name().toString()));
    }

    public int[] getAggregatingFunctionIds(String functionGlobbing) {
        Predicate<String> matcherPredicate = this.predicate(functionGlobbing);
        return this.globalProcedures.getIdsOfAggregatingFunctionsMatching(f -> matcherPredicate.test(f.signature().name().toString()));
    }

    private Predicate<String> predicate(String globbing) {
        Matcher m = this.specialCharacterPattern.matcher(globbing);
        String escaped = m.replaceAll("\\\\$0");
        String escapedString = escaped.replaceAll("\\*", ".*").replaceAll("\\?", ".{1}");
        return Pattern.compile(escapedString, 2).asMatchPredicate();
    }
}

