/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.scan;

import java.io.IOException;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.index.label.FullStoreChangeStream;
import org.neo4j.internal.index.label.TokenScanWriter;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityTokenUpdate;

public abstract class FullTokenStream
implements FullStoreChangeStream,
Visitor<EntityTokenUpdate, IOException> {
    private final IndexStoreView indexStoreView;
    private TokenScanWriter writer;
    private long count;

    FullTokenStream(IndexStoreView indexStoreView) {
        this.indexStoreView = indexStoreView;
    }

    abstract StoreScan<IOException> getStoreScan(IndexStoreView var1, Visitor<EntityTokenUpdate, IOException> var2, PageCursorTracer var3, MemoryTracker var4);

    public long applyTo(TokenScanWriter writer, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) throws IOException {
        this.writer = writer;
        StoreScan<IOException> scan = this.getStoreScan(this.indexStoreView, this, cursorTracer, memoryTracker);
        scan.run();
        return this.count;
    }

    public boolean visit(EntityTokenUpdate update) throws IOException {
        this.writer.write(update);
        ++this.count;
        return false;
    }
}

