/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.token.TokenCreator;

abstract class IsolatedTransactionTokenCreator
implements TokenCreator {
    private final Supplier<Kernel> kernelSupplier;

    IsolatedTransactionTokenCreator(Supplier<Kernel> kernelSupplier) {
        this.kernelSupplier = kernelSupplier;
    }

    public synchronized int createToken(String name, boolean internal) throws KernelException {
        Kernel kernel = this.kernelSupplier.get();
        try (KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
            int id = this.createKey(tx, name, internal);
            tx.commit();
            int n = id;
            return n;
        }
    }

    public synchronized void createTokens(String[] names, int[] ids, boolean internal, IntPredicate filter) throws KernelException {
        Kernel kernel = this.kernelSupplier.get();
        try (KernelTransaction tx = kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
            for (int i = 0; i < ids.length; ++i) {
                if (!filter.test(i)) continue;
                ids[i] = this.createKey(tx, names[i], internal);
            }
            tx.commit();
        }
    }

    abstract int createKey(KernelTransaction var1, String var2, boolean var3) throws KernelException;
}

