/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.function.Function;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexOrderCapability;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.values.storable.ValueCategory;

public class FusionIndexCapability
implements IndexCapability {
    private static final Function<ValueCategory, ValueCategory> categoryOf = Function.identity();
    private final SlotSelector slotSelector;
    private final InstanceSelector<IndexCapability> instanceSelector;
    private final IndexBehaviour[] behaviours;

    FusionIndexCapability(SlotSelector slotSelector, InstanceSelector<IndexCapability> instanceSelector) {
        this.slotSelector = slotSelector;
        this.instanceSelector = instanceSelector;
        this.behaviours = FusionIndexCapability.buildBehaviours(slotSelector);
    }

    private static IndexBehaviour[] buildBehaviours(SlotSelector slotSelector) {
        IndexSlot slot = slotSelector.selectSlot(new ValueCategory[]{ValueCategory.TEXT}, categoryOf);
        if (slot != IndexSlot.LUCENE) {
            return new IndexBehaviour[]{IndexBehaviour.SLOW_CONTAINS};
        }
        return new IndexBehaviour[0];
    }

    public IndexOrderCapability orderCapability(ValueCategory ... valueCategories) {
        IndexSlot slot = this.slotSelector.selectSlot(valueCategories, categoryOf);
        if (slot == null) {
            return IndexOrderCapability.NONE;
        }
        return this.instanceSelector.select(slot).orderCapability(valueCategories);
    }

    public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
        IndexSlot slot = this.slotSelector.selectSlot(valueCategories, categoryOf);
        if (slot == null) {
            return IndexValueCapability.PARTIAL;
        }
        return this.instanceSelector.select(slot).valueCapability(valueCategories);
    }

    public IndexBehaviour[] behaviours() {
        return this.behaviours;
    }
}

