/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.PrimitiveSortedMergeJoin;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.txstate.LongDiffSets;

class DefaultNodeLabelIndexCursor
extends IndexCursor<IndexProgressor>
implements NodeLabelIndexCursor {
    private Read read;
    private long node;
    private TokenSet labels;
    private LongIterator added;
    private LongSet removed;
    private boolean useMergeSort;
    private final PrimitiveSortedMergeJoin sortedMergeJoin = new PrimitiveSortedMergeJoin();
    private final CursorPool<DefaultNodeLabelIndexCursor> pool;
    private final DefaultNodeCursor securityNodeCursor;
    private AccessMode accessMode;
    private boolean shortcutSecurity;

    DefaultNodeLabelIndexCursor(CursorPool<DefaultNodeLabelIndexCursor> pool, DefaultNodeCursor securityNodeCursor) {
        this.pool = pool;
        this.securityNodeCursor = securityNodeCursor;
        this.node = -1L;
    }

    public void scan(IndexProgressor progressor, int label, IndexOrder order) {
        super.initialize(progressor);
        if (this.read.hasTxStateWithChanges()) {
            LongDiffSets changes = this.read.txState().nodesWithLabelChanged(label);
            LongSet frozenAdded = changes.getAdded().freeze();
            switch (order) {
                case NONE: {
                    this.useMergeSort = false;
                    this.added = frozenAdded.longIterator();
                    break;
                }
                case ASCENDING: 
                case DESCENDING: {
                    this.useMergeSort = true;
                    this.sortedMergeJoin.initialize(order);
                    long[] addedSortedArray = frozenAdded.toSortedArray();
                    this.added = IndexOrder.DESCENDING == order ? PrimitiveLongCollections.reverseIterator((long[])addedSortedArray) : PrimitiveLongCollections.iterator((long[])addedSortedArray);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported index order:" + order);
                }
            }
            this.removed = PrimitiveLongCollections.mergeToSet((LongIterable)this.read.txState().addedAndRemovedNodes().getRemoved(), (LongIterable)changes.getRemoved());
        } else {
            this.useMergeSort = false;
        }
        if (this.tracer != null) {
            this.tracer.onLabelScan(label);
        }
        this.initSecurity(label);
    }

    public void scan(IndexProgressor progressor, LongIterator added, LongSet removed, int label) {
        super.initialize(progressor);
        this.useMergeSort = false;
        this.added = added;
        this.removed = removed;
        this.initSecurity(label);
    }

    IndexProgressor.EntityTokenClient nodeLabelClient() {
        return (reference, labels) -> {
            if (this.isRemoved(reference) || !this.allowed(reference, labels)) {
                return false;
            }
            this.node = reference;
            this.labels = labels;
            return true;
        };
    }

    private void initSecurity(int label) {
        this.shortcutSecurity = this.allowsTraverseAllNodesWithLabel(label);
    }

    boolean allowed(long reference, TokenSet labels) {
        if (this.shortcutSecurity) {
            return true;
        }
        if (labels == null) {
            this.read.singleNode(reference, this.securityNodeCursor);
            return this.securityNodeCursor.next();
        }
        return this.accessMode.allowsTraverseNode(labels.all());
    }

    boolean allowsTraverseAllNodesWithLabel(int label) {
        if (this.accessMode == null) {
            this.accessMode = this.read.ktx.securityContext().mode();
        }
        return this.accessMode.allowsTraverseAllNodesWithLabel((long)label);
    }

    public boolean next() {
        if (this.useMergeSort) {
            return this.nextWithOrdering();
        }
        return this.nextWithoutOrder();
    }

    private boolean nextWithoutOrder() {
        if (this.added != null && this.added.hasNext()) {
            this.node = this.added.next();
            if (this.tracer != null) {
                this.tracer.onNode(this.node);
            }
            return true;
        }
        boolean hasNext = this.innerNext();
        if (this.tracer != null && hasNext) {
            this.tracer.onNode(this.node);
        }
        return hasNext;
    }

    private boolean nextWithOrdering() {
        boolean next;
        if (this.sortedMergeJoin.needsA() && this.added.hasNext()) {
            long node = this.added.next();
            this.sortedMergeJoin.setA(node);
        }
        if (this.sortedMergeJoin.needsB() && this.innerNext()) {
            this.sortedMergeJoin.setB(this.node);
        }
        this.node = this.sortedMergeJoin.next();
        boolean bl = next = this.node != -1L;
        if (this.tracer != null && next) {
            this.tracer.onNode(this.node);
        }
        return next;
    }

    public void setRead(Read read) {
        this.read = read;
    }

    public void node(NodeCursor cursor) {
        this.read.singleNode(this.node, cursor);
    }

    public long nodeReference() {
        return this.node;
    }

    public float score() {
        return Float.NaN;
    }

    public TokenSet labels() {
        return this.labels;
    }

    public void closeInternal() {
        if (!this.isClosed()) {
            this.closeProgressor();
            this.node = -1L;
            this.labels = null;
            this.read = null;
            this.removed = null;
            this.accessMode = null;
            this.pool.accept(this);
        }
    }

    public boolean isClosed() {
        return this.isProgressorClosed();
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeLabelIndexCursor[closed state]";
        }
        return "NodeLabelIndexCursor[node=" + this.node + ", labels= " + this.labels + ", underlying record=" + super.toString() + "]";
    }

    private boolean isRemoved(long reference) {
        return this.removed != null && this.removed.contains(reference);
    }

    public void release() {
        if (this.securityNodeCursor != null) {
            this.securityNodeCursor.close();
            this.securityNodeCursor.release();
        }
    }
}

