/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.time.Instant;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.CheckpointLogVersionSelector;
import org.neo4j.storageengine.api.StoreId;

public class DetachedCheckpointLogEntryWriter {
    static final int RECORD_LENGTH_BYTES = 192;
    protected final WritableChecksumChannel channel;

    public DetachedCheckpointLogEntryWriter(WritableChecksumChannel channel) {
        this.channel = channel;
    }

    public void writeCheckPointEntry(LogPosition logPosition, Instant checkpointTime, StoreId storeId, String reason) throws IOException {
        this.channel.beginChecksum();
        DetachedCheckpointLogEntryWriter.writeLogEntryHeader((byte)8, (WritableChannel)this.channel);
        byte[] reasonBytes = reason.getBytes();
        short length = Numbers.safeCastIntToShort((int)Math.min(reasonBytes.length, 120));
        byte[] descriptionBytes = new byte[120];
        System.arraycopy(reasonBytes, 0, descriptionBytes, 0, length);
        this.channel.putLong(logPosition.getLogVersion()).putLong(logPosition.getByteOffset()).putLong(checkpointTime.toEpochMilli()).putLong(storeId.getCreationTime()).putLong(storeId.getRandomId()).putLong(storeId.getStoreVersion()).putLong(storeId.getUpgradeTime()).putLong(storeId.getUpgradeTxId()).putShort(length).put(descriptionBytes, descriptionBytes.length);
        this.channel.putChecksum();
    }

    protected static void writeLogEntryHeader(byte type, WritableChannel channel) throws IOException {
        channel.put(CheckpointLogVersionSelector.LATEST.versionByte()).put(type);
    }
}

