/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.DatabasePageCache;
import org.neo4j.index.internal.gbptree.GroupingRecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.DefaultIdController;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.DefaultForceOperation;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategies;
import org.neo4j.kernel.extension.context.DatabaseExtensionContext;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.storemigration.LegacyTransactionLogsLocator;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.RecoveryThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.util.monitoring.LogProgressReporter;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.DefaultRecoveryService;
import org.neo4j.kernel.recovery.RecoveryExtension;
import org.neo4j.kernel.recovery.RecoveryFacade;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryRequiredChecker;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.kernel.recovery.TransactionLogsRecovery;
import org.neo4j.lock.LockService;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.monitoring.Monitors;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.RecoveryState;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StorageFilesState;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.time.Clocks;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.util.FeatureToggles;

public final class Recovery {
    private static final boolean IGNORE_STORE_ID = FeatureToggles.flag(Recovery.class, (String)"ignoreStoreId", (boolean)false);

    private Recovery() {
    }

    public static RecoveryFacade recoveryFacade(FileSystemAbstraction fs, PageCache pageCache, Tracers tracers, Config config, StorageEngineFactory storageEngineFactory, MemoryTracker memoryTracker) {
        return new RecoveryFacade(fs, pageCache, new DatabaseTracers(tracers), config, storageEngineFactory, memoryTracker);
    }

    public static boolean isRecoveryRequired(DatabaseLayout databaseLayout, Config config, MemoryTracker memoryTracker) throws Exception {
        Objects.requireNonNull(databaseLayout);
        Objects.requireNonNull(config);
        try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();){
            boolean bl = Recovery.isRecoveryRequired((FileSystemAbstraction)fs, databaseLayout, config, memoryTracker);
            return bl;
        }
    }

    public static void performRecovery(DatabaseLayout databaseLayout, DatabaseTracers tracers, MemoryTracker memoryTracker) throws Exception {
        Objects.requireNonNull(databaseLayout);
        Config config = Config.defaults();
        try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
             JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
             PageCache pageCache = Recovery.getPageCache(config, (FileSystemAbstraction)fs, jobScheduler);){
            Recovery.performRecovery((FileSystemAbstraction)fs, pageCache, tracers, config, databaseLayout, memoryTracker);
        }
    }

    public static boolean isRecoveryRequired(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config config, MemoryTracker memoryTracker) throws Exception {
        Objects.requireNonNull(databaseLayout);
        Objects.requireNonNull(config);
        Objects.requireNonNull(fs);
        try (JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();){
            boolean bl;
            block12: {
                PageCache pageCache = Recovery.getPageCache(config, fs, jobScheduler);
                try {
                    StorageEngineFactory storageEngineFactory = StorageEngineFactory.selectStorageEngine();
                    bl = Recovery.isRecoveryRequired(fs, pageCache, databaseLayout, storageEngineFactory, config, Optional.empty(), memoryTracker);
                    if (pageCache == null) break block12;
                }
                catch (Throwable throwable) {
                    if (pageCache != null) {
                        try {
                            pageCache.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pageCache.close();
            }
            return bl;
        }
    }

    public static void performRecovery(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, MemoryTracker memoryTracker) throws IOException {
        Recovery.performRecovery(fs, pageCache, tracers, config, databaseLayout, StorageEngineFactory.selectStorageEngine(), false, memoryTracker);
    }

    public static void performRecovery(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory, boolean forceRunRecovery, MemoryTracker memoryTracker) throws IOException {
        Objects.requireNonNull(fs);
        Objects.requireNonNull(pageCache);
        Objects.requireNonNull(config);
        Objects.requireNonNull(databaseLayout);
        Objects.requireNonNull(storageEngineFactory);
        Config recoveryConfig = Config.newBuilder().fromConfig(config).set(GraphDatabaseSettings.transaction_logs_root_path, null).build();
        Recovery.performRecovery(fs, pageCache, tracers, recoveryConfig, databaseLayout, StorageEngineFactory.selectStorageEngine(), forceRunRecovery, (LogProvider)NullLogProvider.getInstance(), new Monitors(), Recovery.loadExtensions(), Optional.empty(), RecoveryStartupChecker.EMPTY_CHECKER, memoryTracker, Clocks.systemClock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performRecovery(FileSystemAbstraction fs, PageCache pageCache, DatabaseTracers tracers, Config config, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory, boolean forceRunRecovery, LogProvider logProvider, Monitors globalMonitors, Iterable<ExtensionFactory<?>> extensionFactories, Optional<LogFiles> providedLogFiles, RecoveryStartupChecker startupChecker, MemoryTracker memoryTracker, Clock clock) throws IOException {
        Log recoveryLog = logProvider.getLog(Recovery.class);
        if (!forceRunRecovery && !Recovery.isRecoveryRequired(fs, pageCache, databaseLayout, storageEngineFactory, config, providedLogFiles, memoryTracker)) {
            return;
        }
        Recovery.checkAllFilesPresence(databaseLayout, fs, pageCache, storageEngineFactory);
        LifeSupport recoveryLife = new LifeSupport();
        Monitors monitors = new Monitors(globalMonitors);
        DatabasePageCache databasePageCache = new DatabasePageCache(pageCache, EmptyVersionContextSupplier.EMPTY, databaseLayout.getDatabaseName());
        SimpleLogService logService = new SimpleLogService(logProvider);
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(storageEngineFactory.commandReaderFactory());
        DatabaseSchemaState schemaState = new DatabaseSchemaState(logProvider);
        JobScheduler scheduler = JobSchedulerFactory.createInitialisedScheduler();
        DatabaseHealth databaseHealth = new DatabaseHealth(PanicEventGenerator.NO_OP, recoveryLog);
        TokenHolders tokenHolders = new TokenHolders((TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "PropertyKey"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "Label"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "RelationshipType"));
        GroupingRecoveryCleanupWorkCollector recoveryCleanupCollector = new GroupingRecoveryCleanupWorkCollector(scheduler, Group.INDEX_CLEANUP, Group.INDEX_CLEANUP_WORK, databaseLayout.getDatabaseName());
        DatabaseExtensions extensions = Recovery.instantiateRecoveryExtensions(databaseLayout, fs, config, (LogService)logService, databasePageCache, scheduler, (RecoveryCleanupWorkCollector)recoveryCleanupCollector, DbmsInfo.TOOL, monitors, tokenHolders, (RecoveryCleanupWorkCollector)recoveryCleanupCollector, extensionFactories);
        DefaultIndexProviderMap indexProviderMap = new DefaultIndexProviderMap((DependencyResolver)extensions, config);
        StorageEngine storageEngine = storageEngineFactory.instantiate(fs, databaseLayout, config, (PageCache)databasePageCache, tokenHolders, (SchemaState)schemaState, (ConstraintRuleAccessor)ConstraintSemantics.getConstraintSemantics(), (IndexConfigCompleter)indexProviderMap, LockService.NO_LOCK_SERVICE, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fs, (RecoveryCleanupWorkCollector)recoveryCleanupCollector), (IdController)new DefaultIdController(), databaseHealth, logService.getInternalLogProvider(), (RecoveryCleanupWorkCollector)recoveryCleanupCollector, tracers.getPageCacheTracer(), true, memoryTracker);
        NeoStoreIndexStoreView neoStoreIndexStoreView = new NeoStoreIndexStoreView(LockService.NO_LOCK_SERVICE, () -> ((StorageEngine)storageEngine).newReader());
        LabelScanStore labelScanStore = Database.buildLabelIndex((RecoveryCleanupWorkCollector)recoveryCleanupCollector, storageEngine, neoStoreIndexStoreView, monitors, logProvider, databasePageCache, databaseLayout, fs, false, tracers.getPageCacheTracer(), memoryTracker);
        RelationshipTypeScanStore relationshipTypeScanStore = Database.buildRelationshipTypeIndex((RecoveryCleanupWorkCollector)recoveryCleanupCollector, storageEngine, neoStoreIndexStoreView, monitors, logProvider, databasePageCache, databaseLayout, fs, false, config, tracers.getPageCacheTracer(), memoryTracker);
        DynamicIndexStoreView indexStoreView = new DynamicIndexStoreView(neoStoreIndexStoreView, labelScanStore, relationshipTypeScanStore, LockService.NO_LOCK_SERVICE, () -> ((StorageEngine)storageEngine).newReader(), logProvider, config);
        IndexStatisticsStore indexStatisticsStore = new IndexStatisticsStore((PageCache)databasePageCache, databaseLayout, (RecoveryCleanupWorkCollector)recoveryCleanupCollector, false, tracers.getPageCacheTracer());
        IndexingService indexingService = Database.buildIndexingService(storageEngine, schemaState, indexStoreView, indexStatisticsStore, config, scheduler, indexProviderMap, (TokenNameLookup)tokenHolders, logProvider, logProvider, (IndexingService.Monitor)monitors.newMonitor(IndexingService.Monitor.class, new String[0]), tracers.getPageCacheTracer(), memoryTracker, databaseLayout.getDatabaseName(), false);
        MetadataProvider metadataProvider = storageEngine.metadataProvider();
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{databaseLayout, config, databasePageCache, fs, logProvider, tokenHolders, schemaState, ConstraintSemantics.getConstraintSemantics(), LockService.NO_LOCK_SERVICE, databaseHealth, new DefaultIdGeneratorFactory(fs, (RecoveryCleanupWorkCollector)recoveryCleanupCollector), new DefaultIdController(), EmptyVersionContextSupplier.EMPTY, logService, metadataProvider});
        LogFiles logFiles = LogFilesBuilder.builder(databaseLayout, fs).withLogEntryReader((LogEntryReader)logEntryReader).withConfig(config).withDependencies((DependencyResolver)dependencies).withMemoryTracker(memoryTracker).build();
        boolean failOnCorruptedLogFiles = (Boolean)config.get(GraphDatabaseInternalSettings.fail_on_corrupted_log_files);
        Recovery.validateStoreId(logFiles, storageEngine.getStoreId());
        TransactionMetadataCache metadataCache = new TransactionMetadataCache();
        PhysicalLogicalTransactionStore transactionStore = new PhysicalLogicalTransactionStore(logFiles, metadataCache, (LogEntryReader)logEntryReader, monitors, failOnCorruptedLogFiles);
        BatchingTransactionAppender transactionAppender = new BatchingTransactionAppender(logFiles, LogRotation.NO_ROTATION, metadataCache, (TransactionIdStore)metadataProvider, (Health)databaseHealth);
        LifeSupport schemaLife = new LifeSupport();
        schemaLife.add(storageEngine.schemaAndTokensLifecycle());
        schemaLife.add((Lifecycle)indexingService);
        TransactionLogsRecovery transactionLogsRecovery = Recovery.transactionLogRecovery(fs, (TransactionIdStore)metadataProvider, (RecoveryMonitor)monitors.newMonitor(RecoveryMonitor.class, new String[0]), (RecoveryStartInformationProvider.Monitor)monitors.newMonitor(RecoveryStartInformationProvider.Monitor.class, new String[0]), logFiles, storageEngine, transactionStore, (LogVersionRepository)metadataProvider, (Lifecycle)schemaLife, databaseLayout, failOnCorruptedLogFiles, recoveryLog, startupChecker, tracers.getPageCacheTracer(), memoryTracker);
        DefaultForceOperation forceOperation = new DefaultForceOperation(indexingService, labelScanStore, relationshipTypeScanStore, storageEngine);
        CheckpointAppender checkpointAppender = logFiles.getCheckpointFile().getCheckpointAppender();
        CheckPointerImpl checkPointer = new CheckPointerImpl(metadataProvider, RecoveryThreshold.INSTANCE, forceOperation, LogPruning.NO_PRUNING, checkpointAppender, (Health)databaseHealth, logProvider, tracers, IOLimiter.UNLIMITED, new StoreCopyCheckPointMutex(), clock);
        recoveryLife.add((Lifecycle)scheduler);
        recoveryLife.add((Lifecycle)recoveryCleanupCollector);
        recoveryLife.add((Lifecycle)extensions);
        recoveryLife.add((Lifecycle)indexProviderMap);
        recoveryLife.add((Lifecycle)storageEngine);
        recoveryLife.add((Lifecycle)new MissingTransactionLogsCheck(databaseLayout, config, fs, logFiles, recoveryLog));
        recoveryLife.add((Lifecycle)labelScanStore);
        recoveryLife.add((Lifecycle)relationshipTypeScanStore);
        recoveryLife.add((Lifecycle)logFiles);
        recoveryLife.add((Lifecycle)transactionLogsRecovery);
        recoveryLife.add((Lifecycle)transactionAppender);
        recoveryLife.add((Lifecycle)checkPointer);
        try {
            recoveryLife.start();
            if (databaseHealth.isHealthy()) {
                checkPointer.forceCheckPoint(new SimpleTriggerInfo("Recovery completed."));
            }
        }
        finally {
            recoveryLife.shutdown();
        }
    }

    public static void validateStoreId(LogFiles logFiles, StoreId storeId) {
        StoreId txStoreId;
        if (!(IGNORE_STORE_ID || StoreId.UNKNOWN.equals((Object)(txStoreId = logFiles.getTailInformation().lastStoreId)) || storeId.equalsIgnoringUpdate((Object)txStoreId))) {
            throw new RuntimeException("Mismatching store id. Store StoreId: " + storeId + ". Transaction log StoreId: " + txStoreId);
        }
    }

    private static void checkAllFilesPresence(DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, StorageEngineFactory storageEngineFactory) {
        StorageFilesState state = storageEngineFactory.checkStoreFileState(fs, databaseLayout, pageCache);
        if (state.getRecoveryState() == RecoveryState.UNRECOVERABLE) {
            throw new RuntimeException(String.format("Store files %s is(are) missing and recovery is not possible. Please restore from a consistent backup.", state.getMissingFiles()));
        }
    }

    private static TransactionLogsRecovery transactionLogRecovery(FileSystemAbstraction fileSystemAbstraction, TransactionIdStore transactionIdStore, RecoveryMonitor recoveryMonitor, RecoveryStartInformationProvider.Monitor positionMonitor, LogFiles logFiles, StorageEngine storageEngine, LogicalTransactionStore logicalTransactionStore, LogVersionRepository logVersionRepository, Lifecycle schemaLife, DatabaseLayout databaseLayout, boolean failOnCorruptedLogFiles, Log log, RecoveryStartupChecker startupChecker, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        DefaultRecoveryService recoveryService = new DefaultRecoveryService(storageEngine, transactionIdStore, logicalTransactionStore, logVersionRepository, logFiles, positionMonitor, log);
        CorruptedLogsTruncator logsTruncator = new CorruptedLogsTruncator(databaseLayout.databaseDirectory(), logFiles, fileSystemAbstraction, memoryTracker);
        LogProgressReporter progressReporter = new LogProgressReporter(log);
        return new TransactionLogsRecovery(recoveryService, logsTruncator, schemaLife, recoveryMonitor, progressReporter, failOnCorruptedLogFiles, startupChecker, pageCacheTracer);
    }

    private static Iterable<ExtensionFactory<?>> loadExtensions() {
        return Iterables.cast((Iterable)Services.loadAll(ExtensionFactory.class));
    }

    private static DatabaseExtensions instantiateRecoveryExtensions(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, Config config, LogService logService, PageCache pageCache, JobScheduler jobScheduler, RecoveryCleanupWorkCollector recoveryCollector, DbmsInfo dbmsInfo, Monitors monitors, TokenHolders tokenHolders, RecoveryCleanupWorkCollector recoveryCleanupCollector, Iterable<ExtensionFactory<?>> extensionFactories) {
        List<ExtensionFactory<?>> recoveryExtensions = Iterables.stream(extensionFactories).filter(extension -> extension.getClass().isAnnotationPresent(RecoveryExtension.class)).collect(Collectors.toList());
        Dependencies deps = new Dependencies();
        NonListenableMonitors nonListenableMonitors = new NonListenableMonitors(monitors);
        deps.satisfyDependencies(new Object[]{fileSystem, config, logService, pageCache, recoveryCollector, nonListenableMonitors, jobScheduler, tokenHolders, recoveryCleanupCollector});
        DatabaseExtensionContext extensionContext = new DatabaseExtensionContext(databaseLayout, dbmsInfo, (DependencySatisfier)deps);
        return new DatabaseExtensions(extensionContext, recoveryExtensions, deps, ExtensionFailureStrategies.fail());
    }

    private static boolean isRecoveryRequired(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory, Config config, Optional<LogFiles> logFiles, MemoryTracker memoryTracker) throws IOException {
        RecoveryRequiredChecker requiredChecker = new RecoveryRequiredChecker(fs, pageCache, config, storageEngineFactory);
        return logFiles.isPresent() ? requiredChecker.isRecoveryRequiredAt(databaseLayout, logFiles.get()) : requiredChecker.isRecoveryRequiredAt(databaseLayout, memoryTracker);
    }

    private static PageCache getPageCache(Config config, FileSystemAbstraction fs, JobScheduler jobScheduler) {
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fs, config, PageCacheTracer.NULL, (Log)NullLog.getInstance(), EmptyVersionContextSupplier.EMPTY, jobScheduler, Clocks.nanoClock(), new MemoryPools());
        return pageCacheFactory.getOrCreatePageCache();
    }

    static void throwUnableToCleanRecover(Throwable t) {
        throw new RuntimeException("Error reading transaction logs, recovery not possible. To force the database to start anyway, you can specify '" + GraphDatabaseInternalSettings.fail_on_corrupted_log_files.name() + "=false'. This will try to recover as much as possible and then truncate the corrupt part of the transaction log. Doing this means your database integrity might be compromised, please consider restoring from a consistent backup instead.", t);
    }

    private static class MissingTransactionLogsCheck
    extends LifecycleAdapter {
        private final DatabaseLayout databaseLayout;
        private final Config config;
        private final FileSystemAbstraction fs;
        private final LogFiles logFiles;
        private final Log log;

        MissingTransactionLogsCheck(DatabaseLayout databaseLayout, Config config, FileSystemAbstraction fs, LogFiles logFiles, Log log) {
            this.databaseLayout = databaseLayout;
            this.config = config;
            this.fs = fs;
            this.logFiles = logFiles;
            this.log = log;
        }

        public void init() {
            this.checkForMissingLogFiles();
        }

        private void checkForMissingLogFiles() {
            if (this.logFiles.getTailInformation().logsMissing()) {
                if (((Boolean)this.config.get(GraphDatabaseSettings.fail_on_missing_files)).booleanValue()) {
                    this.log.error("Transaction logs are missing and recovery is not possible.");
                    this.log.info("To force the database to start anyway, you can specify '%s=false'. This will create new transaction log and will update database metadata accordingly. Doing this means your database integrity might be compromised, please consider restoring from a consistent backup instead.", new Object[]{GraphDatabaseSettings.fail_on_missing_files.name()});
                    Path[] logFiles = this.findLegacyLogFiles();
                    if (logFiles.length > 0) {
                        this.log.warn("Transaction log files were found in database directory, rather than the transaction log directory.");
                        this.log.warn("Please move or remove the following %s misplaced transaction log file or files:", new Object[]{logFiles.length});
                        for (Path logFile : logFiles) {
                            this.log.warn(logFile.toAbsolutePath().toString());
                        }
                    }
                    throw new RuntimeException("Transaction logs are missing and recovery is not possible.");
                }
                this.log.warn("No transaction logs were detected, but recovery was forced by user.");
            }
        }

        private Path[] findLegacyLogFiles() {
            LegacyTransactionLogsLocator locator = new LegacyTransactionLogsLocator(Config.defaults(), this.databaseLayout);
            Path logsDirectory = locator.getTransactionLogsDirectory();
            TransactionLogFilesHelper logFilesHelper = new TransactionLogFilesHelper(this.fs, logsDirectory);
            return logFilesHelper.getMatchedFiles();
        }
    }

    private static class NonListenableMonitors
    extends Monitors {
        NonListenableMonitors(Monitors monitors) {
            super(monitors);
        }

        public void addMonitorListener(Object monitorListener, String ... tags) {
        }
    }
}

