/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.sampler.AggregatingIndexSampler;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.impl.schema.reader.SimpleIndexReader;
import org.neo4j.kernel.api.index.AbstractIndexReader;
import org.neo4j.kernel.api.index.BridgingIndexProgressor;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.values.storable.Value;

public class PartitionedIndexReader
extends AbstractIndexReader {
    private final List<SimpleIndexReader> indexReaders;

    public PartitionedIndexReader(List<SearcherReference> partitionSearchers, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TaskCoordinator taskCoordinator) {
        this(descriptor, partitionSearchers.stream().map(partitionSearcher -> new SimpleIndexReader((SearcherReference)partitionSearcher, descriptor, samplingConfig, taskCoordinator)).collect(Collectors.toList()));
    }

    PartitionedIndexReader(IndexDescriptor descriptor, List<SimpleIndexReader> readers) {
        super(descriptor);
        this.indexReaders = readers;
    }

    public void query(QueryContext context, IndexProgressor.EntityValueClient client, IndexQueryConstraints constraints, IndexQuery ... query) throws IndexNotApplicableKernelException {
        try {
            BridgingIndexProgressor bridgingIndexProgressor = new BridgingIndexProgressor(client, this.descriptor.schema().getPropertyIds());
            this.indexReaders.parallelStream().forEach(reader -> {
                try {
                    reader.query(context, (IndexProgressor.EntityValueClient)bridgingIndexProgressor, constraints, query);
                }
                catch (IndexNotApplicableKernelException e) {
                    throw new InnerException(e);
                }
            });
            client.initialize(this.descriptor, (IndexProgressor)bridgingIndexProgressor, query, constraints, false);
        }
        catch (InnerException e) {
            throw e.getCause();
        }
    }

    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return false;
    }

    public long countIndexedNodes(long nodeId, PageCursorTracer cursorTracer, int[] propertyKeyIds, Value ... propertyValues) {
        return this.indexReaders.parallelStream().mapToLong(reader -> reader.countIndexedNodes(nodeId, cursorTracer, propertyKeyIds, propertyValues)).sum();
    }

    public IndexSampler createSampler() {
        List<IndexSampler> indexSamplers = this.indexReaders.parallelStream().map(SimpleIndexReader::createSampler).collect(Collectors.toList());
        return new AggregatingIndexSampler(indexSamplers);
    }

    public void close() {
        try {
            IOUtils.closeAll(this.indexReaders);
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    private static final class InnerException
    extends RuntimeException {
        private InnerException(IndexNotApplicableKernelException e) {
            super((Throwable)e);
        }

        public synchronized IndexNotApplicableKernelException getCause() {
            return (IndexNotApplicableKernelException)super.getCause();
        }
    }
}

