/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.Comparator;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeGenerationTarget;
import org.neo4j.index.internal.gbptree.GenerationSafePointer;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

abstract class TreeNode<KEY, VALUE> {
    static final int BYTE_POS_NODE_TYPE = 0;
    static final byte NODE_TYPE_TREE_NODE = 1;
    static final byte NODE_TYPE_FREE_LIST_NODE = 2;
    static final byte NODE_TYPE_OFFLOAD = 3;
    static final int SIZE_PAGE_REFERENCE = 24;
    static final int BYTE_POS_TYPE = 1;
    static final int BYTE_POS_GENERATION = 2;
    static final int BYTE_POS_KEYCOUNT = 6;
    static final int BYTE_POS_RIGHTSIBLING = 10;
    static final int BYTE_POS_LEFTSIBLING = 34;
    static final int BYTE_POS_SUCCESSOR = 58;
    static final int BASE_HEADER_LENGTH = 82;
    static final byte LEAF_FLAG = 1;
    static final byte INTERNAL_FLAG = 0;
    static final long NO_NODE_FLAG = 0L;
    static final long NO_OFFLOAD_ID = -1L;
    static final int NO_KEY_VALUE_SIZE_CAP = -1;
    final Layout<KEY, VALUE> layout;
    final int pageSize;

    TreeNode(int pageSize, Layout<KEY, VALUE> layout) {
        this.pageSize = pageSize;
        this.layout = layout;
    }

    static byte nodeType(PageCursor cursor) {
        return cursor.getByte(0);
    }

    private static void writeBaseHeader(PageCursor cursor, byte type, long stableGeneration, long unstableGeneration) {
        cursor.putByte(0, (byte)1);
        cursor.putByte(1, type);
        TreeNode.setGeneration(cursor, unstableGeneration);
        TreeNode.setKeyCount(cursor, 0);
        TreeNode.setRightSibling(cursor, 0L, stableGeneration, unstableGeneration);
        TreeNode.setLeftSibling(cursor, 0L, stableGeneration, unstableGeneration);
        TreeNode.setSuccessor(cursor, 0L, stableGeneration, unstableGeneration);
    }

    void initializeLeaf(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        TreeNode.writeBaseHeader(cursor, (byte)1, stableGeneration, unstableGeneration);
        this.writeAdditionalHeader(cursor);
    }

    void initializeInternal(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        TreeNode.writeBaseHeader(cursor, (byte)0, stableGeneration, unstableGeneration);
        this.writeAdditionalHeader(cursor);
    }

    abstract void writeAdditionalHeader(PageCursor var1);

    static byte treeNodeType(PageCursor cursor) {
        return cursor.getByte(1);
    }

    static boolean isLeaf(PageCursor cursor) {
        return TreeNode.treeNodeType(cursor) == 1;
    }

    static boolean isInternal(PageCursor cursor) {
        return TreeNode.treeNodeType(cursor) == 0;
    }

    static long generation(PageCursor cursor) {
        return (long)cursor.getInt(2) & 0xFFFFFFFFL;
    }

    static int keyCount(PageCursor cursor) {
        return cursor.getInt(6);
    }

    static long rightSibling(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        return TreeNode.rightSibling(cursor, stableGeneration, unstableGeneration, GBPTreeGenerationTarget.NO_GENERATION_TARGET);
    }

    static long rightSibling(PageCursor cursor, long stableGeneration, long unstableGeneration, GBPTreeGenerationTarget generationTarget) {
        cursor.setOffset(10);
        return GenerationSafePointerPair.read(cursor, stableGeneration, unstableGeneration, generationTarget);
    }

    static long leftSibling(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        return TreeNode.leftSibling(cursor, stableGeneration, unstableGeneration, GBPTreeGenerationTarget.NO_GENERATION_TARGET);
    }

    static long leftSibling(PageCursor cursor, long stableGeneration, long unstableGeneration, GBPTreeGenerationTarget generationTarget) {
        cursor.setOffset(34);
        return GenerationSafePointerPair.read(cursor, stableGeneration, unstableGeneration, generationTarget);
    }

    static long successor(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        return TreeNode.successor(cursor, stableGeneration, unstableGeneration, GBPTreeGenerationTarget.NO_GENERATION_TARGET);
    }

    static long successor(PageCursor cursor, long stableGeneration, long unstableGeneration, GBPTreeGenerationTarget generationTarget) {
        cursor.setOffset(58);
        return GenerationSafePointerPair.read(cursor, stableGeneration, unstableGeneration, generationTarget);
    }

    static void setGeneration(PageCursor cursor, long generation) {
        GenerationSafePointer.assertGenerationOnWrite(generation);
        cursor.putInt(2, (int)generation);
    }

    static void setKeyCount(PageCursor cursor, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Invalid key count, " + count + ". On tree node " + cursor.getCurrentPageId() + ".");
        }
        cursor.putInt(6, count);
    }

    static void setRightSibling(PageCursor cursor, long rightSiblingId, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(10);
        long result = GenerationSafePointerPair.write(cursor, rightSiblingId, stableGeneration, unstableGeneration);
        GenerationSafePointerPair.assertSuccess(result);
    }

    static void setLeftSibling(PageCursor cursor, long leftSiblingId, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(34);
        long result = GenerationSafePointerPair.write(cursor, leftSiblingId, stableGeneration, unstableGeneration);
        GenerationSafePointerPair.assertSuccess(result);
    }

    static void setSuccessor(PageCursor cursor, long successorId, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(58);
        long result = GenerationSafePointerPair.write(cursor, successorId, stableGeneration, unstableGeneration);
        GenerationSafePointerPair.assertSuccess(result);
    }

    static void insertSlotsAt(PageCursor cursor, int pos, int numberOfSlots, int totalSlotCount, int baseOffset, int slotSize) {
        cursor.shiftBytes(baseOffset + pos * slotSize, (totalSlotCount - pos) * slotSize, numberOfSlots * slotSize);
    }

    static void removeSlotAt(PageCursor cursor, int pos, int totalSlotCount, int baseOffset, int slotSize) {
        cursor.shiftBytes(baseOffset + (pos + 1) * slotSize, (totalSlotCount - (pos + 1)) * slotSize, -slotSize);
    }

    abstract long offloadIdAt(PageCursor var1, int var2, Type var3);

    abstract KEY keyAt(PageCursor var1, KEY var2, int var3, Type var4, PageCursorTracer var5);

    abstract void keyValueAt(PageCursor var1, KEY var2, VALUE var3, int var4, PageCursorTracer var5);

    abstract void insertKeyAndRightChildAt(PageCursor var1, KEY var2, long var3, int var5, int var6, long var7, long var9, PageCursorTracer var11) throws IOException;

    abstract void insertKeyValueAt(PageCursor var1, KEY var2, VALUE var3, int var4, int var5, long var6, long var8, PageCursorTracer var10) throws IOException;

    abstract void removeKeyValueAt(PageCursor var1, int var2, int var3, long var4, long var6, PageCursorTracer var8) throws IOException;

    abstract void removeKeyAndRightChildAt(PageCursor var1, int var2, int var3, long var4, long var6, PageCursorTracer var8) throws IOException;

    abstract void removeKeyAndLeftChildAt(PageCursor var1, int var2, int var3, long var4, long var6, PageCursorTracer var8) throws IOException;

    abstract boolean setKeyAtInternal(PageCursor var1, KEY var2, int var3);

    abstract VALUE valueAt(PageCursor var1, VALUE var2, int var3, PageCursorTracer var4);

    abstract boolean setValueAt(PageCursor var1, VALUE var2, int var3);

    long childAt(PageCursor cursor, int pos, long stableGeneration, long unstableGeneration) {
        return this.childAt(cursor, pos, stableGeneration, unstableGeneration, GBPTreeGenerationTarget.NO_GENERATION_TARGET);
    }

    long childAt(PageCursor cursor, int pos, long stableGeneration, long unstableGeneration, GBPTreeGenerationTarget generationTarget) {
        cursor.setOffset(this.childOffset(pos));
        return GenerationSafePointerPair.read(cursor, stableGeneration, unstableGeneration, generationTarget);
    }

    abstract void setChildAt(PageCursor var1, long var2, int var4, long var5, long var7);

    static void writeChild(PageCursor cursor, long child, long stableGeneration, long unstableGeneration) {
        long write = GenerationSafePointerPair.write(cursor, child, stableGeneration, unstableGeneration);
        GenerationSafePointerPair.assertSuccess(write);
    }

    abstract int keyValueSizeCap();

    abstract int inlineKeyValueSizeCap();

    abstract void validateKeyValueSize(KEY var1, VALUE var2);

    abstract boolean reasonableKeyCount(int var1);

    abstract boolean reasonableChildCount(int var1);

    abstract int childOffset(int var1);

    static boolean isNode(long node) {
        return GenerationSafePointerPair.pointer(node) != 0L;
    }

    Comparator<KEY> keyComparator() {
        return this.layout;
    }

    static void goTo(PageCursor cursor, String messageOnError, long nodeId) throws IOException {
        PageCursorUtil.goTo(cursor, messageOnError, GenerationSafePointerPair.pointer(nodeId));
    }

    abstract Overflow internalOverflow(PageCursor var1, int var2, KEY var3);

    abstract Overflow leafOverflow(PageCursor var1, int var2, KEY var3, VALUE var4);

    abstract void defragmentLeaf(PageCursor var1);

    abstract void defragmentInternal(PageCursor var1);

    abstract boolean leafUnderflow(PageCursor var1, int var2);

    abstract int canRebalanceLeaves(PageCursor var1, int var2, PageCursor var3, int var4);

    abstract boolean canMergeLeaves(PageCursor var1, int var2, PageCursor var3, int var4);

    abstract void doSplitLeaf(PageCursor var1, int var2, PageCursor var3, int var4, KEY var5, VALUE var6, KEY var7, double var8, long var10, long var12, PageCursorTracer var14) throws IOException;

    abstract void doSplitInternal(PageCursor var1, int var2, PageCursor var3, int var4, KEY var5, long var6, long var8, long var10, KEY var12, double var13, PageCursorTracer var15) throws IOException;

    abstract void moveKeyValuesFromLeftToRight(PageCursor var1, int var2, PageCursor var3, int var4, int var5);

    abstract void copyKeyValuesFromLeftToRight(PageCursor var1, int var2, PageCursor var3, int var4);

    abstract void printNode(PageCursor var1, boolean var2, boolean var3, long var4, long var6, PageCursorTracer var8);

    abstract String checkMetaConsistency(PageCursor var1, int var2, Type var3, GBPTreeConsistencyCheckVisitor<KEY> var4);

    static enum Overflow {
        YES,
        NO,
        NO_NEED_DEFRAG;

    }

    static enum Type {
        LEAF,
        INTERNAL;

    }
}

